%est_sequential_r.m 
%est_sequential.m 
%estimates the matrices F, G, and Sigma defining the SVAR system of owrld prices and NIPA variables (Y,C,I,TBY) one at the time for 138 countries. The SVAR system is the one studied in the paper ``World Shocks, World Prices,  And Business Cycles.''
%The main output  of this program is the 138x4 variable `result'  containg  estimates of the share of the variances of the NIPA variables explained by world shocks mediated by commodity prices and the interest rate  for the 138 countries in the panel. 
% Martn Uribe, June 2016 
clear all 
warning('off')
format compact
clc

%load vdet_hp100 BP country_name readme b raw_data %added
%produced by running vdet.m in z:\joint\isom16\138cou
[raw_data]=xlsread('Datos_VAR_3.xlsx'); %added

%Agriculture
%i=3; added
i=2;
A = log(raw_data(:,i,1));

%Fuels
%i=4; %added
i=3; %added
F = log(raw_data(:,i,1));

%Metals
%i=5; added
i=4; %added
M = log(raw_data(:,i,1));

%Interest Rate
%i=6; added 
i=5 ; %added
R = log(1+raw_data(:,i,1)/100);

%HP Filter (100)
a = hpfilter(A,100);
f = hpfilter(F,100);
m = hpfilter(M,100);
r = hpfilter(R,100);

%INF = log(raw_data(31:end,8,1));
INF = raw_data(31:end,8,1)
inf = hpfilter(INF,100);
PIB = log(raw_data(:,6,1));
pib = hpfilter(PIB,100);
C = log(raw_data(11:end,9,1));
c = hpfilter(C,100);
INV = log(raw_data(11:end,10,1));
inv = hpfilter(INV,100);
CPI = log(raw_data(30:end,i,1));
cpi = hpfilter(CPI,100);

xlRange = 'B2'; 
xlswrite('graph_variables.xlsx',a,'agro',xlRange)
xlswrite('graph_variables.xlsx',f,'fuel',xlRange)
xlswrite('graph_variables.xlsx',m,'metal',xlRange)
xlswrite('graph_variables.xlsx',r,'BAA',xlRange)
%xlswrite('graph_variables.xlsx',INF,'inflation',xlRange)
xlswrite('graph_variables.xlsx',inf,'inflation_hp',xlRange)
xlswrite('graph_variables.xlsx',cpi,'ipc',xlRange)
xlswrite('graph_variables.xlsx',pib,'pib',xlRange)
xlswrite('graph_variables.xlsx',c,'consumption',xlRange)
xlswrite('graph_variables.xlsx',inv,'investment',xlRange)