/* ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */
/* Estadisticos de precios (como referencia ver Medina, Rapport & Soto (2007)). */
/* Detalles adicionales en archivo instructivo adjunto y minuta.*/

global dir = "T:\GMA\DAE\Proyecto Separata 2020\Capitulo - Microestructura de Precios\"
global codes = "${dir}Codigos\"
global results = "${dir}Resultados\"
global data = "${dir}Datos\"
global separata = "${results}\Separata\"
global graph = "${dir}\Graficos"

/* definiciones producto categoria */
global variedad  "division grupo clase subclase producto variedad"
global producto  "division grupo clase subclase producto"
global grupo	 "division"
global epsilon = 0  // diferencia minima para considerar cambio de precio (%)

/* ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */
/* 1.- Base de datos. */
** periodos relevantes son 1 y 4

global periodo = 1

if ${periodo}==1{
	use "${data}\ipc-base-anual-2013-100\Base IPC 2014-2018.dta", clear
	}
else if ${periodo}==2{
	use "${data}\ipc-base-anual-2018-100\Base IPC 2019.dta", clear
		keep if date<=716
	}
else if ${periodo}==3{
	use "${data}\ipc-base-anual-2018-100\Base IPC 2019.dta", clear
		keep if date>=717
	}
else if ${periodo}==4{
	use "${data}\ipc-base-anual-2018-100\Base IPC 2019.dta", clear
	}

/* ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */
/* Canastas IPC.*/
** Agregamos los ponderadores de las canastas del IPC para construir graficos y regresiones

sort division grupo clase subclase producto
merge division grupo clase subclase producto using "T:\GMA\DAE\Proyecto Separata 2020\Capitulo - Microestructura de Precios\Datos\Canasta_2009.dta"
	drop if _merge==2
	drop _merge
	
sort division grupo clase subclase producto
merge division grupo clase subclase producto using "T:\GMA\DAE\Proyecto Separata 2020\Capitulo - Microestructura de Precios\Datos\Canasta_2013.dta"
	drop if _merge==2
	drop _merge
	
sort division grupo clase subclase producto
merge division grupo clase subclase producto using "T:\GMA\DAE\Proyecto Separata 2020\Capitulo - Microestructura de Precios\Datos\Canasta_2018.dta"
	drop if _merge==2
	drop _merge

/* ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */
/* 2.- Crear variables. */
** Creamos variables de precios (p_ijt), donde i es la firma, j la variedad y t el mes. A partir de esta variable se definen ajustes positivos y negativos.

sort id date
gen p_ijt = ln(pm_)
gen p_ijt_1= ln(l.pm_)

by id: gen comp_ij = p_ijt!=. & p_ijt_1!=. & reemplaza & l.reemplaza
by id: gen adj_ij  = p_ijt!=p_ijt_1 & comp_ij 

gen pos = adj_ij & p_ijt_1<p_ijt
gen neg = adj_ij & p_ijt_1>p_ijt

gen dif_ij = p_ijt - p_ijt_1 if adj_ij
gen abs_ij = abs(p_ijt - p_ijt_1) if adj_ij

egen T_ = group(date)
egen T = max(T_)
	drop T_

label def division 1 "Alimentos" 2 "Bebidas" 3 "Vestuario" 4 "Vivienda" 5 "Hogar" 6 "Salud" 7 "Transporte" 8 "Comunicaciones" 9 "Cultura" 10 "Educacion" 11 "Restaurantes" 12 "ByS diversos"
label val division division

/* ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */
/* 3.- Graficos introductorios. */

keep if comp_ij==1
snapshot save, label("Baseline")
local snap = r(snapshot)

if ${periodo}==1{
	sort id date
		gen crec = (pm_-l.pm_)/l.pm_
		
	merge m:1 date division grupo clase subclase producto using "${data}\IPC_productos.dta", nogenerate keep(1 3)
	collapse (mean) crec ipc_ine, by(date codigo2013)

	xtset codigo2013 date, m
		replace crec = 100*crec

	tsline crec ipc_ine if codigo2013==1011101 , ///
		title("Arroz", size(large)) xtitle("Fecha") ytitle("Porcentaje") ///
		xlabel(648 (12)707) ///
		legend(pos(6) label(1 "Microdata") label(2 "INE") cols(2)) saving("${graph}\arroz", replace)
	tsline crec ipc_ine if codigo2013==9043201 , ///
		title("Artículos de Escritorio", size(large)) xtitle("Fecha") ytitle("Porcentaje") ///
		xlabel(648 (12)707) ///
		legend(pos(6) label(1 "Microdata") label(2 "INE") cols(2)) saving("${graph}\escritorio", replace)
		
	graph combine "${graph}\arroz" "${graph}\escritorio"
		graph export "${graph}\arroz_escritorio.png", as(png) replace
}

/* ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */
/* 4.- Tablas de resultados. */
snapshot restore `snap'

* A. Frecuencias de cambios de precios.
sort ${variedad} fuente
by ${variedad}: egen adj_i  = total(adj_ij)
by ${variedad}: egen comp_i = total(comp_ij)
by ${variedad}: gen aux_j_i = fuente!= fuente[_n-1]
by ${variedad}: egen j_i    = total(aux_j_i)
	
by ${variedad}: gen f_i = adj_i / (comp_i )
				label var f_i "Frecuencia de Ajustes de Precios, Variedad"
by ${variedad}: gen id_i = _n==1				
			
	histogram f_i if id_i , fraction bin(50) title("Frecuencia de ajuste de precios", size(large)) subtitle("Periodo ${periodo}") xtitle("") ytitle("Porcentaje")
	*graph export "${separata}\Graficos\dist_frecuencia_periodo${periodo}.png" , as(png) replace
	
	sort ${grupo} date
	by ${grupo} date: gen id_gt= _n==1
	by ${grupo} date: egen adj_gt = total(adj_ij)
	by ${grupo} date: egen comp_gt = total(comp_ij)

	by ${grupo} date: gen f_gt = adj_gt / (comp_gt )
				label var f_gt "Frecuencia de Ajustes de Precios, Grupo"

	di "Tabla 1: Frecuencia por Grupo"
	table ${grupo} if id_gt, c(mean f_gt median f_gt)

* Series de tiempo
	di "Tabla 2: Series de Tiempo de Frecuencias por Grupo"
	table date ${grupo} if id_gt, c(mean f_gt)

* Frecuencias positivas y negativas
	sort ${grupo} date
	by ${grupo} date: egen adj_gt_pos = total(adj_ij * pos)
	by ${grupo} date: gen f_gt_pos = adj_gt_pos / (comp_gt)
				label var f_gt_pos "Frequency of upward price adjustment, Group"
				
	by ${grupo} date : egen adj_gt_neg = total(adj_ij * neg)
	by ${grupo} date: gen f_gt_neg = adj_gt_neg / (comp_gt)
				label var f_gt_neg "Frequency of downward price adjustment, Group"

	di "Tabla 3b"
	table ${grupo} if id_gt, c(mean f_gt mean f_gt_pos median f_gt_pos mean f_gt_neg median f_gt_neg)

	
/* --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */	
* B.- Tamaño de ajustes de precios
	
	sort ${grupo} date
	by ${grupo} date: egen abs_gt = total(abs_ij)
	by ${grupo} date: gen pi_gt = abs_gt / comp_gt
				label var pi_gt "Tamaño promedio de ajustes de precios"
				
	by ${grupo} date: egen pi_gt_pos = total(adj_ij * dif_ij * pos)
	by ${grupo} date: replace pi_gt_pos = pi_gt_pos / adj_gt_pos


	by ${grupo} date: egen pi_gt_neg = total(adj_ij * dif_ij * neg)
	by ${grupo} date: replace pi_gt_neg = pi_gt_neg / adj_gt_neg

	gen check =  (pi_gt_pos * f_gt_pos )-( pi_gt_neg * f_gt_neg)

	di "Tabla 4a"
	table ${grupo} if id_gt, c(mean pi_gt mean check)
	table ${grupo} if id_gt, c(mean pi_gt mean pi_gt_pos mean f_gt_pos mean pi_gt_neg mean f_gt_neg)
	
	table date ${grupo} if id_gt, c(mean pi_gt)
		

/* --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */	
* C.- Dispersion de precios.
	sort ${variedad} date
	by ${variedad} date: egen pbar_it = mean(p_ijt)

	sort ${grupo} date
	by ${grupo} date: gen dif2_ij = (p_ijt - pbar_it)^2
	by ${grupo} date: egen sum_dif2 = mean(dif2_ij)
	by ${grupo} date: gen disp_gt = sqrt(sum_dif2)

	di "Tabla 5a"
	table $grupo if id_gt, c(mean disp_gt median disp_gt)
	table date $grupo if id_gt, c(mean disp_gt)
	
	* C.a.- Numero de variedades, productos y establecimientos 
		sort ${variedad} date
		by ${variedad} date: gen id_vt = _n==1
		by ${variedad} date: gen obs_vt = _N
		
		sort ${producto} date
		by ${producto} date: gen id_pt = _n==1
		
		table date ${grupo}, c(sum id_vt)
		table date ${grupo}, c(sum id_pt)
		table date ${grupo}, c(count p_ijt)

/* --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */	
* D.- Sincronizacion.

	sort ${grupo} date
	by ${grupo}: egen adj_g = total(adj_ij)
	by ${grupo}: egen comp_g = total(comp_ij)
	by ${grupo}: gen f_g = adj_g / (comp_g)
					label var f_g "Frecuencias de ajustes de precios, Grupo"

	by ${grupo} date: gen aux_s_g = (f_gt - f_g)^2 if _n==1
	by ${grupo}: egen s_g = mean(aux_s_g / (f_g*(1-f_g)))
	by ${grupo}: replace s_g = sqrt(s_g)
	
	di "Tabla 6a"
	table ${grupo} if id_gt, c(mean s_g)
	
/* --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- */	