// OLG modelo pensiones Informe de pensiones 2017.

close all;
clc;

// Determine if you want to report the result tables or not ( 0  sets them off)
   @#define Resultados = 1
// Define the number of skill-groups in the model
   @#define nl = 5

   @#include "OLG_especificaciones.mod"

// Define the number of steps to be used in the homothopy algorithm.
   @#define homo_steps = 50
// Define the initial and final values for "tau_W" in the homothopy setup (in percentage points).
   @#define tau_W_ini = 10
   @#define tau_W_fin = 10
// Define the initial and final values for "tau_F" in the homothopy setup (in percentage points).
   @#define tau_F_ini = 0
   @#define tau_F_fin = 5
// Define the initial and final values for "betta" in the homothopy setup (in 1000 points).
   @#define betta_ini = [53410,43465,39490,35400,41440]
   @#define betta_fin = betta_ini
// Define the initial and final values for "theta" in the homothopy setup (in percentage points).
   @#define theta_ini = 100
   @#define theta_fin = 100
// Define the initial and final values for "upsilon" in the homothopy setup (in percentage points). upsilon = 0 => CRRA
   @#define upsilon_ini = 100
   @#define upsilon_fin = 100
// Define the initial and fin10al values for "gamastar" in the homothopy setup (in 100000 points). upsilon = 0 => CRRA
   @#define gamastar_vec = 3660
// Define the initial and final values for "b_i" in the homothopy setup (in 10000 points). Is a vector of dimension 1xnl at least!
   @#define b_ini =  [20810,40340,48260,57950,1882000]
   @#define b_fin =  b_ini
// Define the initial and final values for "rho" in the homothopy setup (in percentage points).
   @#define rho_ini = 33
   @#define rho_fin = 33
// Define the income quantiles in Chile 2015
   @#define inc_Q = [147810,49470,32960,21447,457]
// Define the vecor of chi_i that normalizes labour supply when to 1.
   @#define chi_vec = [2900,2063,1771,1519,1106]
//-------------------------------------------------------------------------
// model variables
//-------------------------------------------------------------------------
var y l_hat w rk r cy cm co s sy sm sp spwy spwm spfy spfm st p pw pf pbs k pts wybar wmbar wlm xrr h
@#for i in 1:nl
cy_@{i} cm_@{i} co_@{i} s_@{i} sy_@{i} sm_@{i} spwy_@{i} spwm_@{i} p_@{i} pw_@{i}
ly_@{i} lm_@{i} hy_@{i} hm_@{i} wy_@{i} wm_@{i} l_@{i} pf_@{i} wly_@{i} wlm_@{i}
bahy_@{i} bahm_@{i} aux_hy_@{i} aux_hm_@{i} pts_@{i}
@#endfor
check_1 check_2 check_3
@#if mu>1&&mu<4
    @#for i in (i_bar+1):nl
         check_4_@{i}
    @#endfor
@#endif
;

//-------------------------------------------------------------------------
// parameters
//-------------------------------------------------------------------------
parameters tau_W tau_F theta phi rho alfa n g delta e upsilon kappa beta_i 
           kl b_i chi_i alfa_0 alfa_1 gama gamastar rstar tau_F_indicator 
           gamastar_out Mu1 Mu2 Mu3 Mu4 Mu5
@#for i in 1:nl
           lambda_@{i} chiy_@{i} chim_@{i} a_@{i} b_@{i} varphi_@{i} beta_@{i}
@#endfor
;
// capital elasticity of production function
beta_i = 0.673;
alfa   = 0.48;                         
phi    = 3;
e      = 1;
kappa  = 324;
n      = (1 + 0.005)^20 - 1;           // crecimiento anual 2016-2050 fuerza laboral 0.1%
g      = (1 + 0.02)^20 - 1;            // tendencia anual 2016-2050: 2.418%
delta  =  1 - (1 - 0.04)^20;           // Adolfson, M. et al 2008
// points rule
alfa_0   = 0;
alfa_1   = 0;
gama     = @{gama_}/10;
rstar    = (1 + 0.03)^20 - 1;
gamastar_out = @{gamastar_vec}/100000;
save('Param_initial_b_i_and_k_l_ratio','alfa','phi','e','kappa','n','g','delta','beta_i','gama')
fun = @initial_b_i_and_k_l_ratio;
x   = fsolve(fun,[0.5;1]);

kl  = real(x(1));
b_i = real(x(2));
chi_i = 0.18*(e*(beta_i*(1-delta + alfa*kl^(alfa-1))*e/(1+g))^(1/(phi-1))+(1+n)^(-1))^phi*((1+(1-alfa)*kl^alfa)^(1-phi)*(beta_i^2+beta_i+1)/((1+b_i)*(beta_i+(beta_i*(1-delta + alfa*kl^(alfa-1))*e/(1+g))^(phi/(phi-1)))));

tau_W_in  = @{tau_W_ini}/100;
tau_W_fin = @{tau_W_fin}/100;
tau_F_in  = @{tau_F_ini}/100;
tau_F_fin = @{tau_F_fin}/100;

// population fraction - disutility of labor weight - relative productivity of labor types
@#for i in 1:nl
      lambda_@{i} = 1/@{nl};
      a_aux_@{i}  = @{inc_Q[i]};
      a_@{i}      = a_aux_@{i}/a_aux_1;
      varphi_@{i} = @{varphi_vec[i]}/100;
      chiy_@{i}   = chi_i;
      chim_@{i}   = chi_i;
      //chiy_@{i}   = @{chi_vec[i]}/10000;
      //chim_@{i}   = chiy_@{i};
@#endfor

// The next parameter is an indicator that is 0 if tau_F is set to 0 or 1 if tau_F is positive
@#if tau_F_ini
    tau_F_indicator = 1;
@#else
    tau_F_indicator = 0;
@#endif
// pension scheme
Mu1 = 0;
Mu2 = 0;
Mu3 = 0;
Mu4 = 0;
Mu5 = 0;
@#if mu==1
     Mu1 = 1;
@#endif
@#if mu==2
    Mu2 = 1;
@#endif
@#if mu==3
     Mu3 = 1;
@#endif
@#if mu==4
     Mu4 = 1;
@#endif
@#if mu==5
     Mu5 = 1;
@#endif

//-------------------------------------------------------------------------
// model block
//-------------------------------------------------------------------------
model;
@#for i in 1:nl
     cy_@{i}   = wy_@{i}*ly_@{i}+e*b_@{i}*a_@{i}*hy_@{i}-sy_@{i}-spwy_@{i};
     cm_@{i}   = wm_@{i}*lm_@{i}+(1+g)*b_@{i}*a_@{i}*hm_@{i}+r*sy_@{i}(-1)-sm_@{i}-spwm_@{i};
     co_@{i}   = r*sm_@{i}(-1)+p_@{i};
     cy_@{i}   =((1-tau_W)*(wy_@{i}*ly_@{i}+wm_@{i}(+1)*lm_@{i}(+1)/r(+1))+e*b_@{i}*a_@{i}*hy_@{i}+(1+g)*b_@{i}*a_@{i}*hm_@{i}(+1)/r(+1)+varphi_@{i}*p_@{i}(+2)/(r(+1)*r(+2)))
                /(1+beta_@{i}^(1/theta)*r(+1)^((1-theta)/theta)+beta_@{i}^(2/theta)*(r(+1)*r(+2))^((1-theta)/theta));
     cm_@{i}   =(r*sy_@{i}(-1)+(1-tau_W)*wm_@{i}*lm_@{i}+(1+g)*b_@{i}*a_@{i}*hm_@{i}+varphi_@{i}*p_@{i}(+1)/r(+1))
                /(1+beta_@{i}^(1/theta)*r(+1)^((1-theta)/theta));
     spwy_@{i} = tau_W*wy_@{i}*ly_@{i};
     spwm_@{i} = tau_W*wm_@{i}*lm_@{i};
     p_@{i}    = pw_@{i}+pf_@{i};
     pw_@{i}   = r*(spwm_@{i}(-1)+r(-1)*spwy_@{i}(-2));
     wy_@{i}   = e*a_@{i}*w*(l_hat/(lambda_@{i}*l_@{i}))^(1-rho);
     wm_@{i}   = a_@{i}*(1+g)*w*(l_hat/(lambda_@{i}*l_@{i}))^(1-rho);
     l_@{i}    = e*ly_@{i}+lm_@{i}/(1+n);
     pts_@{i}  = r*(alfa_0+lm_@{i}(-1)*(wm_@{i}(-1)/wmbar(-1))^alfa_1+r(-1)*(alfa_0+ly_@{i}(-2)*(wy_@{i}(-2)/wybar(-2))^alfa_1));
@#endfor

@#for i in 1:(i_bar)
     pf_@{i} = Mu1*r*tau_F*(wm_@{i}(-1)*lm_@{i}(-1)+r(-1)*wy_@{i}(-2)*ly_@{i}(-2))+Mu4*pts_@{i}/pts*pf;
     chiy_@{i}*(ly_@{i}+hy_@{i})^(phi-1) = cy_@{i}^(-theta*(1-upsilon))*wy_@{i}*(1-(1-varphi_@{i})*tau_W+varphi_@{i}*Mu4*wy_@{i}^(alfa_1-1)/wybar^(alfa_1)*pf(+2)/pts(+2));
     chim_@{i}*(lm_@{i}+hm_@{i})^(phi-1) = cm_@{i}^(-theta*(1-upsilon))*wm_@{i}*(1-(1-varphi_@{i})*tau_W+varphi_@{i}*Mu4*wm_@{i}^(alfa_1-1)/wmbar^(alfa_1)*pf(+1)/pts(+1));
     aux_hy_@{i} = max(0,(cy_@{i}^(-theta*(1-upsilon))/chiy_@{i}*((e*b_@{i}*a_@{i}-wy_@{i}*(1-(1-varphi_@{i})*tau_W
                                                                           +varphi_@{i}*Mu4*wy_@{i}^(alfa_1-1)/wybar^(alfa_1)*pf(+2)/pts(+2)))/kappa)));
     aux_hm_@{i} = max(0,(cm_@{i}^(-theta*(1-upsilon))/chim_@{i}*(((1+g)*b_@{i}*a_@{i}-wm_@{i}*(1-(1-varphi_@{i})*tau_W
                                                                           +varphi_@{i}*Mu4*wm_@{i}^(alfa_1-1)/wmbar^(alfa_1)*pf(+1)/pts(+1)))/kappa)));
     hy_@{i}^(phi-1) = aux_hy_@{i};
     hm_@{i}^(phi-1) = aux_hm_@{i};
@#endfor
@#for i in (i_bar+1):nl
     pf_@{i} = Mu1*r*tau_F*(wm_@{i}(-1)*lm_@{i}(-1)+r(-1)*wy_@{i}(-2)*ly_@{i}(-2))
               +(Mu2+Mu3)*(pbs-1/3*r*tau_W*(wm_@{i}(-1)*lm_@{i}(-1)+r(-1)*wy_@{i}(-2)*ly_@{i}(-2)))*tau_F_indicator
               + Mu4*pts_@{i}/pts*pf
               + Mu5*r*wm_@{i}(-1)*lm_@{i}(-1)/wlm(-1)*pf;
     chiy_@{i}*(ly_@{i}+hy_@{i})^(phi-1) = cy_@{i}^(-theta*(1-upsilon))*wy_@{i}*(1-(1-varphi_@{i})*tau_W+varphi_@{i}*((Mu1*tau_F-(Mu2+Mu3)*tau_W/3)*tau_F_indicator
                                                                           +Mu4*wy_@{i}^(alfa_1-1)/wybar^(alfa_1)*pf(+2)/pts(+2)));
     chim_@{i}*(lm_@{i}+hm_@{i})^(phi-1) = cm_@{i}^(-theta*(1-upsilon))*wm_@{i}*(1-(1-varphi_@{i})*tau_W+varphi_@{i}*((Mu1*tau_F-(Mu2+Mu3)*tau_W/3)*tau_F_indicator
                                                                           +Mu4*wm_@{i}^(alfa_1-1)/wmbar^(alfa_1)*pf(+1)/pts(+1)+Mu5*pf(+1)/wlm));
     aux_hy_@{i} = max(0,(cy_@{i}^(-theta*(1-upsilon))/chiy_@{i}*
                      ((e*b_@{i}*a_@{i}-wy_@{i}*(1-(1-varphi_@{i})*tau_W+varphi_@{i}*((Mu1*tau_F-(Mu2+Mu3)*tau_W/3)*tau_F_indicator
                                                                           +Mu4*wy_@{i}^(alfa_1-1)/wybar^(alfa_1)*pf(+2)/pts(+2))))/kappa)));
     aux_hm_@{i} = max(0,(cm_@{i}^(-theta*(1-upsilon))/chim_@{i}*
                      (((1+g)*b_@{i}*a_@{i}-wm_@{i}*(1-(1-varphi_@{i})*tau_W+varphi_@{i}*((Mu1*tau_F-(Mu2+Mu3)*tau_W/3)*tau_F_indicator
                                                                           +Mu4*wm_@{i}^(alfa_1-1)/wmbar^(alfa_1)*pf(+1)/pts(+1)+Mu5*pf(+1)/wlm)))/kappa)));
     hy_@{i}^(phi-1) = aux_hy_@{i};
     hm_@{i}^(phi-1) = aux_hm_@{i};
@#endfor

@#for i in 1:nl
     wly_@{i}  = wy_@{i}*ly_@{i};
     wlm_@{i}  = wm_@{i}*lm_@{i};
     bahy_@{i} = e*b_@{i}*a_@{i}*hy_@{i};
     bahm_@{i} = (1+g)*b_@{i}*a_@{i}*hm_@{i};
@#endfor

pts  =(
       @#for i in 1:nl
       +lambda_@{i}*pts_@{i}
       @#endfor
);

wybar = (
         @#for i in 1:nl
         +lambda_@{i}*wy_@{i}
         @#endfor
);
wmbar = (
         @#for i in 1:nl
         +lambda_@{i}*wm_@{i}
         @#endfor
);

wlm  = r(+1)*(
              @#for i in i_bar+1:nl
              +lambda_@{i}*wm_@{i}*lm_@{i}
              @#endfor
);

xrr  = pf/wlm(-1);

h    =(
       @#for i in 3:nl
       +lambda_@{i}*(hy_@{i}+hm_@{i}/(1+n))
       @#endfor
);

cy   =(
       @#for i in 1:nl
       +lambda_@{i}*cy_@{i}
       @#endfor
);
cm   =(
       @#for i in 1:nl
       +lambda_@{i}*cm_@{i}
       @#endfor
);
co   =(
       @#for i in 1:nl
       +lambda_@{i}*co_@{i}
       @#endfor
);
pbs = tau_F_indicator/(
          @#for i in (i_bar+1):nl
               +lambda_@{i}
          @#endfor
          )*(Mu2*(spfm*(1+n)*(1+g)+spfy*(1+n)^2*(1+g)^2+1/3*(
          @#for i in (i_bar+1):nl
               +lambda_@{i}*pw_@{i}
          @#endfor
          ))+Mu3*(r*(spfm(-1)+r(-1)*spfy(-2))+1/3*(
          @#for i in (i_bar+1):nl
               +lambda_@{i}*pw_@{i}
          @#endfor
          )));

y     = k(-1)^(alfa)*l_hat^(1-alfa);
l_hat^(rho) =(
        @#for i in 1:nl
             +a_@{i}*(lambda_@{i}*l_@{i})^rho
        @#endfor
);
w  = ((1-alfa)/(1+tau_F))*y/l_hat; //(1+tau_F)
rk = alfa*y/k(-1);
r  = 1 + (1-gama)*(rk - delta)+ gama*rstar;
@#for i in 1:nl
     s_@{i} = sy_@{i} + sm_@{i}/(1+g);
@#endfor
s  = sy + sm/((1+g)*(1+n));
sy =(
     @#for i in 1:nl
          +lambda_@{i}*sy_@{i}
     @#endfor
);
sm =(
     @#for i in 1:nl
          +lambda_@{i}*sm_@{i}
     @#endfor
);
sp = (spwm+r*spwy(-1))/((1+g)*(1+n))+spwy+(Mu1+Mu3+Mu4)*((spfm+r*spfy(-1))/((1+g)*(1+n))+spfy);
p  = pw + pf;
pf = (Mu1+Mu3+Mu4)*r*(spfm(-1)+r(-1)*spfy(-2))+(Mu2+Mu5)*((1+g)*(1+n)*spfm+(1+g)^2*(1+n)^2*spfy);
pw = r*(spwm(-1)+r(-1)*spwy(-2));
spwy =tau_W*(
       @#for i in 1:nl
       +lambda_@{i}*wy_@{i}*ly_@{i}
       @#endfor
);
spwm =tau_W*(
       @#for i in 1:nl
       +lambda_@{i}*wm_@{i}*lm_@{i}
       @#endfor
);
spfy =tau_F*(
       @#for i in 1:nl
       +lambda_@{i}*wy_@{i}*ly_@{i}
       @#endfor
);
spfm =tau_F*(
       @#for i in 1:nl
       +lambda_@{i}*wm_@{i}*lm_@{i}
       @#endfor
);
st = s+sp;
(1+n)*(1+g)*k = (1-gama)*st + gamastar;

// check that zero profit condition is satisfied
check_1 = y-rk*k(-1)-(1+tau_F)*(   
          @#for i in 1:nl
          +lambda_@{i}*(wy_@{i}*ly_@{i}+wm_@{i}*lm_@{i}/((1+n)*(1+g)))
          @#endfor
);
// check that the budget constraint is satisfied
check_2 = p/((1+n)*(1+g))+(1+n)*(1+g)*(sp-spwy-spfy)-(r*sp+spwm+spfm);
// check that the IBC of workers is staisfied for each type in ss
check_3 = (
           @#for i in 1:nl
                 +abs(cy_@{i}+cm_@{i}/r+co_@{i}/r^2-(1-tau_W)*wy_@{i}*ly_@{i}-((1-tau_W)*wm_@{i}*lm_@{i})/r-e*b_@{i}*a_@{i}*hy_@{i}-(1+g)*b_@{i}*a_@{i}*hm_@{i}/r-p_@{i}/r^2)
           @#endfor
           );
// check that for the chilenean formula the max is ex-post satisfied
@#if mu>1&&mu<4
    @#for i in (i_bar+1):nl
         check_4_@{i} = tau_F_indicator*(pbs-pw_@{i}/3);
    @#endfor
@#endif

end;

//----------------------------------------------------------------------------------------
// Steady state - for beta_i=cte; chiy_i=chim_i; rho=theta=1; tau_W=tau_F=0 and upsilon=0.
//----------------------------------------------------------------------------------------

// variables associated with public pension
@#for i in 1:nl
    spwy_ss_@{i} = 0;
    spwm_ss_@{i} = 0;
    pw_ss_@{i}   = 0;
    pf_ss_@{i}   = 0;
    p_ss_@{i}    = 0;
@#endfor
sp_ss = 0; 
spwy_ss = 0;
spwm_ss = 0;
spfy_ss = 0;
spfm_ss = 0;
pw_ss   = 0;
pf_ss   = 0;
p_ss    = 0;
pbs_ss  = 0;
xrr_ss  = 0;
// capital-labor ratio
k_l_ss = kl;
// labor share of output
w_ss = (1-alfa)*k_l_ss^alfa;
// capital share of output
rk_ss = alfa*k_l_ss^(alfa-1);
// interest rate
r_ss = 1 + (1-gama)*(rk_ss - delta) + gama*rstar;;

//labor supply
@#for i in 1:nl
    ly_ss_@{i} = (1/chiy_@{i}*(1+w_ss)^(1-phi)*(beta_i^2+beta_i+1)/((1+b_i)*(beta_i+(beta_i*r_ss*e/(1+g))^(phi/(phi-1)))))^(1/phi)*...
                 (beta_i*r_ss*e/(1+g))^(1/(phi-1));
    lm_ss_@{i} = (1/chim_@{i}*(1+w_ss)^(1-phi)*(beta_i^2+beta_i+1)/((1+b_i)*(beta_i+(beta_i*r_ss*e/(1+g))^(phi/(phi-1)))))^(1/phi);
    l_ss_@{i}  = e*ly_ss_@{i} + lm_ss_@{i}/(1+n);
    hy_ss_@{i} = w_ss*ly_ss_@{i};
    hm_ss_@{i} = w_ss*lm_ss_@{i};
@#endfor

// labour bundle
l_hat_ss = (...
    @#for i in 1:nl
        +a_@{i}*lambda_@{i}*l_ss_@{i}...
    @#endfor
);
// informal labor
h_ss =(...
       @#for i in 3:nl
       +lambda_@{i}*(hy_ss_@{i}+hm_ss_@{i}/(1+n))...
       @#endfor
);
// capital
k_ss = k_l_ss*l_hat_ss;
// output
y_ss = k_ss^alfa*l_hat_ss^(1-alfa);

@#for i in 1:nl
// wage, consumprion and savings for each worker type
    wy_ss_@{i}   = e*a_@{i}*w_ss;
    wm_ss_@{i}   = (1+g)*a_@{i}*w_ss;
    cy_ss_@{i}   = ((1+g)*lm_ss_@{i}+r_ss*e*ly_ss_@{i})*(1+b_i)*a_@{i}*w_ss/((beta_i^2+beta_i+1)*r_ss);
    cm_ss_@{i}   = beta_i*((1+g)*lm_ss_@{i}+r_ss*e*ly_ss_@{i})*(1+b_i)*a_@{i}*w_ss/(beta_i^2+beta_i+1);
    co_ss_@{i}   = beta_i*r_ss*cm_ss_@{i};
    sy_ss_@{i}   = wy_ss_@{i}*ly_ss_@{i}+e*b_i*a_@{i}*hy_ss_@{i}-cy_ss_@{i};
    sm_ss_@{i}   = wm_ss_@{i}*lm_ss_@{i}+(1+g)*b_i*a_@{i}*hm_ss_@{i}+r_ss*sy_ss_@{i}-cm_ss_@{i};
    wly_ss_@{i}  = wy_ss_@{i}*ly_ss_@{i};
    wlm_ss_@{i}  = wm_ss_@{i}*lm_ss_@{i};
    bahy_ss_@{i} = e*b_i*a_@{i}*hy_ss_@{i};
    bahm_ss_@{i} = (1+g)*b_i*a_@{i}*hm_ss_@{i};
    s_ss_@{i}    = sy_ss_@{i}+sm_ss_@{i}/(1+g);
@#endfor

wybar_ss = (...
            @#for i in 1:nl
            +lambda_@{i}*wy_ss_@{i}...
            @#endfor
);
wmbar_ss = (...
            @#for i in 1:nl
            +lambda_@{i}*wm_ss_@{i}...
            @#endfor
);

@#for i in 1:nl
pts_ss_@{i}  = r_ss*(alfa_0+lm_ss_@{i}*(wm_ss_@{i}/wmbar_ss)^alfa_1+r_ss*(alfa_0+ly_ss_@{i}*(wy_ss_@{i}/wybar_ss)^alfa_1));
@#endfor

wlm_ss = r_ss*(...
    @#for i in (i_bar+1):nl
        +lambda_@{i}*wm_ss_@{i}*lm_ss_@{i}...
    @#endfor
);

pts_ss  =(...
          @#for i in 1:nl
          +lambda_@{i}*pts_ss_@{i}...
          @#endfor
);

// aggregate savings of young and middle-aged workers
sy_ss = (...
    @#for i in 1:nl
        +lambda_@{i}*sy_ss_@{i}...
    @#endfor
);
sm_ss = (...
    @#for i in 1:nl
        +lambda_@{i}*sm_ss_@{i}...
    @#endfor
);
// aggregate private savings
s_ss = sy_ss + sm_ss/((1+n)*(1+g));
// aggregate consumption for young, middle-aged and old individuals
cy_ss =(...
       @#for i in 1:nl
       +lambda_@{i}*cy_ss_@{i}...
       @#endfor
);
cm_ss =(...
       @#for i in 1:nl
       +lambda_@{i}*cm_ss_@{i}...
       @#endfor
);
co_ss =(...
       @#for i in 1:nl
       +lambda_@{i}*co_ss_@{i}...
       @#endfor
);
// aggregate total savings in the economy
st_ss = s_ss+sp_ss;

// initial values
initval;
y      = y_ss;
l_hat  = l_hat_ss;
h      = h_ss;
w      = w_ss;
wybar  = wybar_ss;
wmbar  = wmbar_ss;
wlm    = wlm_ss;
rk     = rk_ss;
r      = r_ss;
cy     = cy_ss;
cm     = cm_ss;
co     = co_ss;
s      = s_ss;
sy     = sy_ss;
sm     = sm_ss;
sp     = sp_ss;
spwy   = spwy_ss;
spwm   = spwm_ss;
spfy   = spfy_ss;
spfm   = spfm_ss;
st     = st_ss;
pbs    = pbs_ss;
p      = p_ss;
pw     = pw_ss;
pf     = pf_ss;
pts    = pts_ss;
k      = k_ss;
xrr    = xrr_ss;
@#for i in 1:nl
cy_@{i}   = cy_ss_@{i};
cm_@{i}   = cm_ss_@{i};
co_@{i}   = co_ss_@{i};
s_@{i}    = s_ss_@{i};
sy_@{i}   = sy_ss_@{i};
sm_@{i}   = sm_ss_@{i};
spwy_@{i} = spwy_ss_@{i};
spwm_@{i} = spwm_ss_@{i};
p_@{i}    = p_ss_@{i};
pf_@{i}   = pf_ss;
pw_@{i}   = pw_ss;
pts_@{i}  = pts_ss_@{i};
ly_@{i}   = ly_ss_@{i};
lm_@{i}   = lm_ss_@{i};
hy_@{i}   = hy_ss_@{i};
hm_@{i}   = hm_ss_@{i};
wy_@{i}   = wy_ss_@{i};
wm_@{i}   = wm_ss_@{i};
l_@{i}    = l_ss_@{i};
wly_@{i}  = wly_ss_@{i};
wlm_@{i}  = wlm_ss_@{i};
bahy_@{i} = bahy_ss_@{i};
bahm_@{i} = bahm_ss_@{i};
@#endfor
end; 

// homotopy
homotopy_setup;
// tax on labor income to finance pensions
tau_W, 0 , @{tau_W_ini}/100;
// tax on labor hires by firms
tau_F, 0 , @{tau_F_ini}/100;
// subjective discount factor: 1/(1 + 0.02)^20
@#for i in 1:nl
beta_@{i}, beta_i , @{betta_ini[i]}/100000;
@#endfor
// intertemporal elasticity of consumption
theta, 1 , @{theta_ini}/100;
// preference shifter Gali, Smets, Wouters (2012)
upsilon, 0 , @{upsilon_ini}/100;
// productivities in the informal sector
@#for i in 1:nl
b_@{i}, b_i, @{b_ini[i]}/10000;
@#endfor
// elasticity of substitution between skilled and unskilled workers: 1
rho, 1 , @{rho_ini}/100;
// capital owned by foreigners
gamastar, 0 , @{gamastar_vec}/100000;
end;

// initial steady state
steady(solve_algo = 0, homotopy_mode = 1,homotopy_steps = @{homo_steps});
// check BK conditions
check;

// The next parameter is an indicator that is 0 if tau_F is set to 0 or 1 if tau_F is positive
@#if tau_F_fin
    tau_F_indicator = 1;
@#else
    tau_F_indicator = 0;
@#endif

// final values
endval;
y      = y_ss;
l_hat  = l_hat_ss;
h      = h_ss;
w      = w_ss;
wybar  = wybar_ss;
wmbar  = wmbar_ss;
wlm    = wlm_ss;
rk     = rk_ss;
r      = r_ss;
cy     = cy_ss;
cm     = cm_ss;
co     = co_ss;
s      = s_ss;
sy     = sy_ss;
sm     = sm_ss;
sp     = sp_ss;
spwy   = spwy_ss;
spwm   = spwm_ss;
spfy   = spfy_ss;
spfm   = spfm_ss;
st     = st_ss;
pbs    = pbs_ss;
p      = p_ss;
pw     = pw_ss;
pf     = pf_ss;
pts    = pts_ss;
k      = k_ss;
xrr    = xrr_ss;
@#for i in 1:nl
cy_@{i}   = cy_ss_@{i};
cm_@{i}   = cm_ss_@{i};
co_@{i}   = co_ss_@{i};
s_@{i}    = s_ss_@{i};
sy_@{i}   = sy_ss_@{i};
sm_@{i}   = sm_ss_@{i};
spwy_@{i} = spwy_ss_@{i};
spwm_@{i} = spwm_ss_@{i};
p_@{i}    = p_ss_@{i};
pf_@{i}   = pf_ss;
pw_@{i}   = pw_ss;
pts_@{i}  = pts_ss_@{i};
ly_@{i}   = ly_ss_@{i};
lm_@{i}   = lm_ss_@{i};
hy_@{i}   = hy_ss_@{i};
hm_@{i}   = hm_ss_@{i};
wy_@{i}   = wy_ss_@{i};
wm_@{i}   = wm_ss_@{i};
l_@{i}    = l_ss_@{i};
wly_@{i}  = wly_ss_@{i};
wlm_@{i}  = wlm_ss_@{i};
bahy_@{i} = bahy_ss_@{i};
bahm_@{i} = bahm_ss_@{i};
@#endfor
end; 

// homotopy
homotopy_setup;
// tax on labor income to finance pensions
tau_W, 0 , @{tau_W_fin}/100;
// tax on labor hires by firms
tau_F, 0 , @{tau_F_fin}/100;
// subjective discount factor: 1/(1 + 0.02)^20
@#for i in 1:nl
beta_@{i}, beta_i ,@{betta_fin[i]}/100000;
@#endfor
// intertemporal elasticity of consumption
theta, 1 , @{theta_fin}/100;
// preference shifter Gali, Smets, Wouters (2012)
upsilon, 0 , @{upsilon_fin}/100;
// productivities in the informal sector
@#for i in 1:nl
b_@{i}, b_i, @{b_fin[i]}/10000;
@#endfor
// elasticity of substitution between skilled and unskilled workers: 1
rho, 1 , @{rho_fin}/100;
// capital owned by foreigners
gamastar, 0 , @{gamastar_vec}/100000;
end;


// final steady state
steady(solve_algo = 0, homotopy_mode = 1,homotopy_steps = @{homo_steps});
// check BK conditions
check;

// simulate transition path between the two steady states
simul(periods=6);

@#if Resultados
Resultados_base
@#endif