function Crear_tabla(Sistemas_pensiones,Velo)
% esta función corre distintas versiones del modelo de pensiones y crea una
% tabla resumiendo los resultados base.
Nombres ={'Capitalizacion individual';...
          'Ahorro intra-generacional incondicional';...
          'Ahorro intra-generacional condicional';...
          'Reparto'};

Nombre_corto = ['CI';'AI';'AC';'Re'];

Sistemas_pensiones = [1;4;3;5]; % 1: Capitalización individual;
                                % 3; Ahorro intra-generacional incondicional.
                                % 4; Ahorro intra-generacional condicional.
                                % 5; Reparto
% El velo, en realidad, expresa la fracción de la pensión futura internalizada.                                
Velo = [ 50, 45, 43, 32, 18;... % Velo heterogéneo.
        100,100,100,100,100;... % Sin Velo.
         50, 50, 50, 50, 50;... % Velo homogéneo.
          0,  0,  0,  0,  0;... % Velo total.
          50, 50, 50, 50, 50];  % Velo homogéneo + sin inversión en extranjero
base = 3; % numero de fila de velo base.


    for i_sp = 1:4
        for i_v = 1:5
            velo_ = Velo(i_v,:);
            sistema_ = Sistemas_pensiones(i_sp,1);
            crear_mod_especificaciones_OLG(velo_,sistema_,i_v,sistema_);
            global oo_ M_
            dynare('OLG_informe_pensiones','noclearall','nointeractive','console')
            %guardar resultados
            load('Resultados_temp')
            resultados.(Nombre_corto(i_sp,:)).trabajo(i_v)   = Trabajo_formal;
            resultados.(Nombre_corto(i_sp,:)).salario(i_v)   = Salario_formal;
            resultados.(Nombre_corto(i_sp,:)).ahorro(i_v)    = Ahorro_total;
            resultados.(Nombre_corto(i_sp,:)).consumo(i_v)   = Consumo;
            resultados.(Nombre_corto(i_sp,:)).PIB(i_v)       = PIB;
            resultados.(Nombre_corto(i_sp,:)).pensiones(i_v) = Pensiones_totales;
        end
    end
for i_sp = 1:4
    % Base
    Trabajo(i_sp,1)   = round(resultados.(Nombre_corto(i_sp,:)).trabajo(base),1);
    Salarios(i_sp,1)  = round(resultados.(Nombre_corto(i_sp,:)).salario(base),1);
    Ahorro(i_sp,1)    = round(resultados.(Nombre_corto(i_sp,:)).ahorro(base),1);
    Consumo(i_sp,1)   = round(resultados.(Nombre_corto(i_sp,:)).consumo(base),1);
    PIB(i_sp,1)       = round(resultados.(Nombre_corto(i_sp,:)).PIB(base),1);
    Pensiones(i_sp,1) = round(resultados.(Nombre_corto(i_sp,:)).pensiones(base),1);
    % Máximo
    Trabajo_max(i_sp,1)   = round(max(resultados.(Nombre_corto(i_sp,:)).trabajo),1);
    Salarios_max(i_sp,1)  = round(max(resultados.(Nombre_corto(i_sp,:)).salario),1);
    Ahorro_max(i_sp,1)    = round(max(resultados.(Nombre_corto(i_sp,:)).ahorro),1);
    Consumo_max(i_sp,1)   = round(max(resultados.(Nombre_corto(i_sp,:)).consumo),1);
    PIB_max(i_sp,1)       = round(max(resultados.(Nombre_corto(i_sp,:)).PIB),1);
    Pensiones_max(i_sp,1) = round(max(resultados.(Nombre_corto(i_sp,:)).pensiones),1);
    % Mínimo
    Trabajo_min(i_sp,1)   = round(min(resultados.(Nombre_corto(i_sp,:)).trabajo),1);
    Salarios_min(i_sp,1)  = round(min(resultados.(Nombre_corto(i_sp,:)).salario),1);
    Ahorro_min(i_sp,1)    = round(min(resultados.(Nombre_corto(i_sp,:)).ahorro),1);
    Consumo_min(i_sp,1)   = round(min(resultados.(Nombre_corto(i_sp,:)).consumo),1);
    PIB_min(i_sp,1)       = round(min(resultados.(Nombre_corto(i_sp,:)).PIB),1);
    Pensiones_min(i_sp,1) = round(min(resultados.(Nombre_corto(i_sp,:)).pensiones),1);
end
disp('Estimacion efectos base')
T = table(Nombres,Trabajo, Salarios, Ahorro, Consumo, PIB, Pensiones )
disp('Estimación efectos minimos')
T_min = table(Nombres,Trabajo_min, Salarios_min, Ahorro_min, Consumo_min, PIB_min, Pensiones_min )
disp('Estimación efectos maximos')
T_max = table(Nombres,Trabajo_max, Salarios_max, Ahorro_max, Consumo_max, PIB_max, Pensiones_max )

end