
function tab2fig(T,tab_title,ExtraText)   

%from https://www.mathworks.com/matlabcentral/answers/254690-how-can-i-display-a-matlab-table-in-a-figure

figure('NumberTitle', 'off','Name',tab_title,'units','normalized','outerposition',[0 0 1 1])
set(gcf,'WindowStyle','docked');

% Get the table in string form.
TString = evalc('disp(T)');

% Use TeX Markup for bold formatting and underscores.
TString = strrep(TString,'<strong>','\bf');
TString = strrep(TString,'</strong>','\rm');
TString = strrep(TString,'_','\_');
% Get a fixed-width font.
FixedWidth = get(0,'FixedWidthFontName');


%Add extra line with table notes
TString=strcat(TString , [newline ExtraText]);

% Output the table using the annotation command.


annotation(gcf,'Textbox','String',TString,'Interpreter','Tex',...
    'FontName',FixedWidth,'Units','Normalized','Position',[0 0 1 1]);
    
end


