clc 
clearvars -except do_


paths.local             =   cd;
paths.results           =   [paths.local '\replic_aux_codes\results\'];
paths.model_variations  =   [paths.local '\replic_aux_codes\model_variations\'];
paths.models            = { [paths.local '\models\GarciaGuardaKirchnerTranamil_2019\XMAS\']
                            [paths.local '\models\GarciaGuardaKirchnerTranamil_2019\MAS_proxy\']
                            [paths.local '\models\GarciaGuerra_2020\']};
           
addpath([paths.local '\replic_aux_codes'])


                        %%name          Long Name           options     params      e_prior     e_obs    e_command          
 model_spec =    {   'base'             'Baseline Xmas'     0           0         	0           0        0
                     'calvo'            'Calvo pricing'     1          	0       	0           0        0}
 

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;

    solve_models(models,paths);

cd(paths.results) 

load results_base.mat
oo_base=oo_;
M_base=M_;
bayestopt_base=bayestopt_;

load results_calvo.mat
oo_calvo=oo_;
M_calvo=M_;
bayestopt_calvo=bayestopt_;


save models_results_tabs -regexp base$ calvo$
%load models_results_tabs

prior_shape=categorical(bayestopt_base.pshape);
prior_shape(bayestopt_base.pshape==1)='B';
prior_shape(bayestopt_base.pshape==2)='G';
prior_shape(bayestopt_base.pshape==3)='N';
prior_shape(bayestopt_base.pshape==4)='IG';

cd(paths.local)

%% table3

if do_.tab_GGKT_2019(3)

vars_mod={ 
'VARSIGMA'
'PHI'
'bigPSI'
'PHI_I'
'PHI_ICo'
'PHI_UBAR'
'THETA_H'
'THETA_F'
'THETA_Hstar'
'VARTHETA_H'
'VARTHETA_F'
'VARTHETA_Hstar'
'VARTHETA_IDX'
'ETA_C'
'ETA_O'
'ETA_Z'
'ETA_A'
'ETA_Co'
'ETA_I'
'MU'
'VARKAPPA_W'
'UPSILON'
'VARTHETA_W'
'SIGMA_CTIL'
'ETA_KG'
'RHO_R'
'ALPHA_PI'
'ALPHA_PIz'
'ALPHA_Y'
'ETASTAR'
'GAMMA_H'
'GAMMA_Co'
'GAMMA_star'
'GAMMA_Mstar'
'GAMMA_Costar'
'GAMMA_Ostar'
'RHO_O'
'ALPHA_O'
'ETA_CHAT'
};

tab3=table( 'Size',[size(vars_mod,1) 5],...
            'VariableTypes',{'categorical','categorical','double','double','double'},...
            'VariableNames',{'Parameter' 'Prior_Dist' 'Prior_mean' 'Prior_sd' 'Posterior_mean'});

for ii=1:size(vars_mod,1)
    idx_aux=find(ismember(bayestopt_base.name,vars_mod{ii,1}));
    var_name_aux=categorical(bayestopt_base.name(idx_aux));
    tab3(ii,:)={var_name_aux prior_shape(idx_aux)  bayestopt_base.p1(idx_aux) bayestopt_base.p2(idx_aux)  round(oo_base.posterior.optimization.mode(idx_aux),2)};
end

tab_title='Table 3(GGKT_2019): Prior and posterior ditributions: Structural parameters';
tab_notes='';
disp(tab_title)
disp(' ')
disp(tab3)
disp(tab_notes)

tab2fig(tab3,tab_title,tab_notes)  
end

%% table4
if do_.tab_GGKT_2019(4)

vars_mod={ 
'varrho'
'varomega'
'varomegaCo'
'z'
'zCo'
'zstar'
'zA'
'a'
'zetao'
'zetau'
'xiCG'
'xiTR'
'xiIG'
'kappa'
'rhox'
'xiO'
'eR'
'piFstar'
'xiCostar'
'xiOstar'
'xiMstar'
'xistar'
'Rstar'
};
tab4a=table( 'Size',[size(vars_mod,1) 5],...
            'VariableTypes',{'categorical','categorical','double','double','double'},...
            'VariableNames',{'AR1_coef' 'Prior_Dist' 'Prior_mean' 'Prior_sd' 'Posterior_mean'});
tab4b = table(  'Size',[size(vars_mod,1) 5],...
                'VariableTypes',{'categorical','categorical','double','double','double'},...
                'VariableNames',{'Innovation_sd' 'Prior_Dist' 'Prior_mean' 'Prior_sd' 'Posterior_mean'});

for ii=1:size(vars_mod,1)
	idx_aux=find(ismember(bayestopt_base.name,['RHO_' vars_mod{ii,1}]));
    var_name_aux=categorical({['RHO_' vars_mod{ii,1}]});
    tab4a(ii,:)={var_name_aux prior_shape(idx_aux)  bayestopt_base.p1(idx_aux) bayestopt_base.p2(idx_aux)  round(oo_base.posterior.optimization.mode(idx_aux),2)};
end

for ii=1:size(vars_mod,1)
    idx_aux=find(ismember(bayestopt_base.name,['eps_' vars_mod{ii,1}]));
var_name_aux=categorical({[num2str(100) ' X ' ['sigma_' vars_mod{ii,1}]]});
tab4b(ii,:)={var_name_aux prior_shape(idx_aux)  bayestopt_base.p1(idx_aux) bayestopt_base.p2(idx_aux)  round(oo_base.posterior.optimization.mode(idx_aux),2)};
end

tab_title='Table 4a(GGKT_2019): Prior and posterior ditributions: Exogenous processes parameters';
disp(tab_title)
disp(' ')
disp(tab4a)
disp(' ')
disp(tab4b)

tab_title='Table 4a(GGKT_2019): Prior and posterior ditributions: Exogenous processes parameters';
tab_notes='';
tab2fig(tab4a,tab_title,tab_notes)  
tab_title='Table 4b(GGKT_2019): Prior and posterior ditributions: Exogenous processes parameters';
tab_notes='';
tab2fig(tab4b,tab_title,tab_notes)  

end

%% table 5
if do_.tab_GGKT_2019(5)

vars_mod={
            'GDP growth*'                       'gam_Y_obs'     0.98	0.92	0.31
            'Non-Mining GDP growth'             'gam_YR_obs'	1.07	1       0.29
            'Mining GDP growth'                 'gam_YCo_obs'	3.04	-0.05	-0.14
            'Private consumption growth'    	'gam_C_obs'     1.11	0.74	0.41
            'Gov. consumption growth'           'gam_CG_obs'	1.35	-0.12	-0.19
            'Gov. real transfers growth'        'gam_TRG_obs'	3.17	-0.08	-0.43
            'Total investment growth'           'gam_I_obs'     3.75	0.55	0.36
            'Gov. investment growth'            'gam_IG_obs'	13.6	-0.18	-0.46
            'Mining investment growth'          'gam_ICo_obs'	8.8     0.22	0.42
            'Nom. trade balance/GDP'            'stb_obs'       5.17	0.37	0.78
            'Employment growth'             	'gam_N_obs'     0.42	0.46	0.25
            'Hours per employee growth'         'gam_H_obs'     1.35	0.34	-0.63
            'Total hours growth*'               'gam_HN_obs'	1.37	0.47	-0.56
            'Nominal wage growth'               'gam_WN_obs'	0.38	-0.11	0.52
            'Real wage growth*'                 'gam_W_obs'     0.63	-0.08	0.43
            'Headline inflation*'               'pi_obs'        0.67	-0.19	0.59
            'Core inflation'                    'piZ_obs'       0.49	-0.19	0.59
            'Food inflation'                    'piA_obs'       1.39	-0.24	0.53
            'Fuel inflation'                    'piO_obs'       5.37	0.32	0.08
            'Nominal interest rate'             'R_obs'         0.4     -0.26	0.88
            'Real exchange rate'                'rer_obs'       5.01	-0.22	0.75
            'Nominal depreciation*'             'piS_obs'       5.12	-0.27	0.22
        };


tab5=table( 'Size',[size(vars_mod,1) 7],...
            'VariableTypes',{'categorical','double','double','double','double','double','double'},...
            'VariableNames',{'Variable' 'sd_data' 'sd_model' 'corr_YNCo_data' 'corr_YNCo_model' 'AC_order_1_data' 'AC_order_1_model'});

for ii=1:size(vars_mod,1)
    loc1=loc(M_base.endo_names,vars_mod{ii,2});
    loc_yr=loc(M_base.endo_names,'gam_YR_obs') ;   
    desv_est=oo_base.var(loc1,loc1)^0.5;    
    corr_yr=oo_base.var(loc_yr,loc1)/oo_base.var(loc1,loc1)^0.5/oo_base.var(loc_yr,loc_yr)^0.5;    
    ar1=oo_base.autocorr{1,1}(loc1,loc1);      

tab5(ii,:)={vars_mod{ii,1}  vars_mod{ii,3} round(desv_est,2)  vars_mod{ii,4} round(corr_yr,2) vars_mod{ii,5} round(ar1,2)};
end

tab_title='Table 5(GGKT_2019): Second moments';
tab_notes='* Not observed in Xmas';

disp(tab_title)
disp(' ')
disp(tab5)
disp(tab_notes)
disp(' ')

tab2fig(tab5,tab_title,tab_notes)  

end
%% table 6
if do_.tab_GGKT_2019(6)
vars_mod={
            'Inf. anual'                    'pi4'    
            'E(Inf. anual(+1))'             'pi4_E1'
            'E(Inf. anual(+2))'             'pi4_E2'
            'E(Inf. anual(+4))'             'pi4_E4'
        };

    
tab6=table( 'Size',[size(vars_mod,1) 4],...
            'VariableTypes',{'categorical','double','double','double'},...
            'VariableNames',{'Variable' 'Ag_Shock' 'Oil_shocks' 'Other_shocks'});    
    
for ii=1:size(vars_mod,1)
    
    for jj=1:2
        if jj==1    
        loc_endo=loc(M_base.endo_names,vars_mod{ii,2});
        loc_exo=loc(M_base.exo_names,'eps_zA');
        
        var_dec_a=round(oo_base.variance_decomposition(loc_endo,loc_exo),2);
        elseif jj==2
        loc_endo=loc(M_base.endo_names,vars_mod{ii,2});
        loc_exo1=loc(M_base.exo_names,'eps_xiO');   
        loc_exo2=loc(M_base.exo_names,'eps_xiOstar'); 
        
        var_dec_o=round(oo_base.variance_decomposition(loc_endo,loc_exo1),2)+round(oo_base.variance_decomposition(loc_endo,loc_exo2),2);
        end
    end
    

tab6(ii,:)={vars_mod{ii,1}  var_dec_a  var_dec_o 100-var_dec_a-var_dec_o};
end
    
    

tab_title='Table 6(GGKT_2019): Annual inflation variance decomposition';
tab_notes='';
disp(tab_title)
disp(' ')
disp(tab6)

tab2fig(tab6,tab_title,tab_notes)  
end
%% table 8
if do_.tab_GGKT_2019(8)

vars_mod={
            's.d. log(h)'       'h_obs'     1.12
            's.d. log(n)'       'n_obs'     0.85
            's.d. log(h X n)'   'hn_obs'    1.32            
        };


tab8=table( 'Size',[size(vars_mod,1) 4],...
            'VariableTypes',{'categorical','double' ,'double' ,'double'},...
            'VariableNames',{'Variable' 'sd_data' 'sd_model' 'sd_calvo'});

for ii=1:size(vars_mod,1)
    loc1_base=loc(M_base.endo_names,vars_mod{ii,2});  
    desv_est_base=oo_base.var(loc1_base,loc1_base)^0.5;    
    
    loc1_calvo=loc(M_calvo.endo_names,vars_mod{ii,2});  
    desv_est_calvo=oo_calvo.var(loc1_calvo,loc1_calvo)^0.5;   

tab8(ii,:)={vars_mod{ii,1}  vars_mod{ii,3} round(desv_est_base,2) round(desv_est_calvo,2) };
end

tab_title='Table 8(GGKT_2019): Volatility of intensive and extensive margins';
tab_notes='';
disp(tab_title)
disp(' ')
disp(tab8)

tab2fig(tab8,tab_title,tab_notes)  
end


%%

cd(paths.local)