clc 
clearvars -except do_


paths.local             =   cd;
paths.results           =   [paths.local '\replic_aux_codes\results\'];
paths.model_variations  =   [paths.local '\replic_aux_codes\model_variations\'];
paths.models            = { [paths.local '\models\GarciaGuardaKirchnerTranamil_2019\XMAS\']
                            [paths.local '\models\GarciaGuardaKirchnerTranamil_2019\MAS_proxy\']
                            [paths.local '\models\GarciaGuerra_2020\']};
           
addpath([paths.local '\replic_aux_codes'])

                        %%name          Long Name                       options     params      e_prior     e_obs    e_command       
    model_base =    {   'base'          'Baseline Xmas'                 0           0         	0           0        0       }
    
    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_base;
    
    solve_models(models,paths);

    %%doing_plots_a -> same shock, different models
    %%doing_plots_b -> same model, different shocks
    %%doing_plots_c -> different shocks and models
    
%% FIG 2    
    
if do_.fig_GGKT_2019(2) 
                        %%name          Long Name                       options     params      e_prior     e_obs	e_command 
    model_spec =    {
                        'exo_min'       'Exogenous Mining Sector'       1          	0       	0           0       0
                        'no_ttb'        'No Time to Build'              1         	0       	0           0       0
                        'no_mintax'     'No Tax'                        0         	1         	0           0       0
                    }
    
    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results)  
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

 
        %           Name            Latex name          shock scale     long_name
    Impulse     =   {	        
                    'xiCostar'  ,   '\xi^{p^{Co*}}'   , 50/11.46        ,'Figure 2(GGKT_2019): Commodity Price Shock';   
                    };

        %                Name           Latex Name                  Cusum	Factor	Div_ss
    Response    = {     'gam_Y'         ,' $ GDP $ '                ,1   	,1    	,0;
                        'gam_YCo'       ,' $ Mining GDP $ '     	,1  	,1   	,0;
                        'gam_ICo'       ,' $ Min. Investment $ '	,1    	,1    	,0;
                        'renstar'       ,' $ Net rents $ '          ,0    	,1    	,1;  
                        'u'             ,' $ Unemployement $ '      ,0    	,1    	,0;  
                         };

    plot_options.n_col	= 3;
    plot_options.n_row	= 2;

    doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 3    
    
if do_.fig_GGKT_2019(3) 

    model_spec ={}

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);
    
    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

        %           Name            Latex name   	shock scale     long_name
    Impulse     = { 'varomega'      ,'\varpi'     	, 1             ,'Private Investment Shock'; 
                   	'varomegaCo'    ,'\omega^{Co}'	, 1             ,'Commodity Investment Shock';             
                    };

        %           Name    	Latex Name                              Cusum	Factor	Div_ss
    Response    = {	'gam_I'  	,' $ Total Investment $ '               ,1        ,1       ,0;
                    'i'       	,' $ Sectoral Investment $ '            ,0        ,1       ,1;
                    'gam_ICo'	,' $ Sectoral Investment $ '            ,1        ,1       ,0;
                    'gam_WN'  	,' $ Nominal Wages $ '                  ,1        ,1       ,0;
                    'h'      	,' $ Hours per Employee $ '         	,0        ,1       ,1;
                    'u'      	,' $ Unemployment $ '                   ,0        ,1       ,0;
                    'gam_Y'   	,' $ Total GDP $ '                      ,1        ,1       ,0;
                    'gam_YR'  	,' $ Non-Mining GDP $ '                 ,1        ,1       ,0;                   
                    'pi'      	,' $ Headline Inflation($4 \pi $) $ '   ,0        ,4       ,0;
                    'R'       	,' $ Nom. Interest Rate($4 R $) $ '     ,0        ,4       ,0;
                     }

    plot_options.n_col	= 3;
    plot_options.n_row	= 3;
    plot_options.join_shocks =2;
    plot_options.shock_calib='max value';
    plot_options.title  = 'Figure 3(GGKT_2019): Effects of a non-commodity private investment shock, and a commodity investment shock';
    doing_plots_b(model_names,Impulse, Response, plot_options)  

end

%% FIG 4

if do_.fig_GGKT_2019(4) 
                    %%name          Long Name                       options     params      e_prior     e_obs   e_command 
model_spec =    {
                 	'cg_noval'      'No value for CG'               1          	0       	0           0       0
                 	'cg_comp'       'CG as complement to C'         0         	1       	1           0       0
               	}

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end
            
    %           Name            Latex name          shock scale     long_name
Impulse     =   {	        
             	'xiCG'  ,   '\xi^{C^{G}}'   , 10/1.09        ,'Figure 4(GGKT_2019): Government consumption shock';   
                };
      
    %                Name           Latex Name                      Cusum	Factor	Div_ss
Response    = {     'gam_C'         ,' $ Total Private Cons. $ '	,1   	,1    	,0;
                    'gam_CNR'    	,' $ Non-Ricardian Cons. $ '	,1   	,1    	,0;
                    'gam_CR'     	,' $ Ricardian Cons. $ '     	,1   	,1    	,0;
                    'gam_Y'         ,' $ GDP $ '                    ,1   	,1    	,0;
                    'gam_YR'        ,' $ Non-Mining GDP $ '       	,1  	,1   	,0;

                     };
    
plot_options.n_col	= 3;
plot_options.n_row	= 2;

doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 5    
    
if do_.fig_GGKT_2019(5) 

    model_spec =    {}

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

        %           Name            Latex name   	shock scale     long_name
    Impulse     = { 'varomega'      ,'\varpi'     	, 1             'Private Investment Shock'; 
                   	'xiIG'       ,'\xi^{I^G}'       , 1             ,'Government Investment Shock';
                    };

        %           Name    	Latex Name                              Cusum	Factor	Div_ss
    Response    = {	'gam_I'   	,' $ Total Investment $ '               ,1        ,1       ,0;
                    'i'      	,' $ Priv. Non-min. Investment $ '    	,0        ,1       ,1;
                    'gam_IG' 	,' $ Gov Investment $ '                 ,1        ,1       ,0;
                    'gam_WN' 	,' $ Nominal Wages $ '               	,1        ,1       ,0;
                    'h'       	,' $ Hours per Employee $ '           	,0        ,1       ,1;
                    'u'         ,' $ Unemployment $ '                   ,0        ,1       ,0;
                    'ubar'    	,' $ Capital Utilization $ '            ,0        ,1       ,1;
                    'gam_Y'  	,' $ GDP $ '                            ,1        ,1       ,0;
                    'pi'      	,' $ Headline Inflation($4 \pi $) $ '	,0        ,4       ,0;
                     }

    plot_options.n_col	= 3;
    plot_options.n_row	= 3;
    plot_options.join_shocks =[];
    plot_options.shock_calib='initial value';
    plot_options.title  = 'Figure 5(GGKT_2019): Private vs government investment shock';
    doing_plots_b(model_names,Impulse, Response, plot_options)  

end

%% FIG 6

if do_.fig_GGKT_2019(6) 
                    %%name          Long Name                       options     params      e_prior     e_obs   e_command 
model_spec =    {
                 	'ig_subs'      'No value for CG'               0          	1       	1           0       0
                 	'ig_hp'        'CG as complement to C'         0         	1       	1           0       0
                    'ig_hp_subs'   'CG as complement to C'         0         	1       	1           0       0
               	}
            
    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end
            
    %           Name            Latex name          shock scale     long_name
Impulse     =   {	        
             	'xiIG'  ,   '\xi^{I^{G}}'           , 10/10.07      ,'Figure 6(GGKT_2019): Government investment shock';   
                };
      
    %                Name           Latex Name                      Cusum	Factor	Div_ss
Response    = {     'i'             ,' $ Non-min Investment. $ '	,0   	,1    	,1;
                    'R'             ,' $ Nom. Interest Rate($4 R $) $ ',0   	,4    	,0;
                     };
    
plot_options.n_col	= 3;
plot_options.n_row	= 1;

doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 7    
    
if do_.fig_GGKT_2019(7) 

    model_spec =    {}

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

        %           Name            Latex name   	shock scale     long_name
    Impulse     = { 'xiCG'       ,'\xi^{i}'       , 1           ,'Government Consumption';
                    'xiIG'       ,'\xi^{i}'       , 1           ,'Government Investment';
                    'xiTR'       ,'\xi^{i}'        , 1           ,'Transfer Payment (to Ricardian)';            
                    };

        %           Name    	Latex Name                              Cusum	Factor	Div_ss
    Response    = {	'gam_G'    	,' $ Total Gov. Expenditure $ '       	,1        ,1       ,0;
                    'gam_CG' 	,' $ Gov. Exp. Components $ '         	,1        ,1       ,0;
                    'gam_IG'  	,' $ Gov. Exp. Components $ '         	,1        ,1       ,0;
                    'gam_TRG' 	,' $ Gov. Exp. Components $ '         	,1        ,1       ,0;
                    'gam_C'  	,' $ Private Consumption $ '            ,1        ,1       ,0;                    
                    'gam_I'   	,' $ Total Investment $ '               ,1        ,1       ,0;
                    'gam_Y'  	,' $ GDP $ '                            ,1        ,1       ,0;
                    'gam_YR'  	,' $ Non-mining GDP $ '                 ,1        ,1       ,0;               
                    'u'         ,' $ Unemployment $ '                   ,0        ,1       ,0;
                    'pi'        ,' $ Headline inflation($4 \pi $) $ ' 	,0        ,4       ,0;
                    'R'        	,' $ Nom. Interest Rate($4 R $) $ '  	,0        ,4       ,1;
                     }

    plot_options.n_col	= 3;
    plot_options.n_row	= 3;
    plot_options.join_shocks =2;
    plot_options.shock_calib='initial value';
    plot_options.title  = 'Figure 7(GGKT_2019): Government expenditure shocks';
    doing_plots_b(model_names,Impulse, Response, plot_options)  

end

%% FIG 8

if do_.fig_GGKT_2019(8) 
                    %%name          Long Name                       options     params      e_prior     e_obs   e_command 
model_spec =    {
                 	'no_caput'      'No value for CG'               1          	0       	0           0       0
}

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end
            
    %           Name            Latex name          shock scale     long_name
Impulse     =   {	        
             	'eR'            ,'e^R'             ,1           ,'Figure 8(GGKT_2019): Monetary shock with variable capital utilization';
                };
      
    %                Name           Latex Name                              Cusum	Factor	Div_ss
Response    = {     'ubar'          ,' $ Non-min. Capital Utilization $ '	,0        ,1       ,1;
                    'kS'            ,' $ Non-min. Capital Services $ '      ,0        ,1       ,1;
                    'rK'            ,' $ Non-min. Cap. Rental Rate $ '      ,0        ,1       ,1;
                    'mcH'           ,' $ Home Goods Marginal Costs $ '   	,0        ,1       ,1;
                    'pi'            ,' $ Headline Inflation($4 \pi $) $ '   ,0        ,4       ,0;
                     };
    
plot_options.n_col	= 3;
plot_options.n_row	= 2;

doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 9

if do_.fig_GGKT_2019(9) 
                    %%name          Long Name                       options     params      e_prior     e_obs   e_command 
model_spec =    {
                 	'no_oil_sm'      'No smoothing in oil prices'   1          	0       	0           0       0
               	}

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end
            
    %           Name            Latex name          shock scale     long_name
Impulse     =   {	        
             	'xiOstar'       ,'\xi^{O*}'       	,1              ,'Figure 9(GGKT_2019): International oil price shock';
                };
      
    %                Name           Latex Name                            Cusum     Factor	Div_ss
Response    = {     'gam_C'         ,' $ Private Consumption($C$) $ ' 	  ,1        ,1    	,0;
                    'pi'            ,' $ Headline Inflation($4 \pi $) $ ' ,0        ,4   	,0;
                    'piZ'           ,' $ Core Inflation($4 \pi^{Z} $) $ ' ,0        ,4   	,0;
                    'pO'            ,' $ Domestic Oil Price($P^{O} $) $ ' ,0        ,1   	,1;                
                    'R'             ,' $ Nom. Interest Rate($4 R $) $ '	  ,0        ,4    	,0;
                     };
    
plot_options.n_col	= 3;
plot_options.n_row	= 2;

doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 10

if do_.fig_GGKT_2019(10) 
                    %%name          Long Name                           options     params      e_prior     e_obs    e_command 
model_spec =    {
                 	'no_prod_coint'   	'No Delay in Cointegration'     1          	0           0           0        0
                    'high_prod_coint'   'High Delay in Cointegration'   0          	1           1           0        0
               	}

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end
            
    %           Name            Latex name          shock scale     long_name
Impulse     =   {	        
             	'a'             ,'a'                ,1              ,'Figure 10(GGKT_2019): Global productivity shock';
                };
      
    %                Name           Latex Name                          Cusum     Factor	Div_ss
Response    = {     'gam_YH'        ,' $ Home Goods Production $ '      ,1        ,1       ,0;
                    'gam_YCo'       ,' $ Mining GDP $ '                 ,1        ,1       ,0;
                    'gam_Y'         ,' $ GDP $ '                        ,1        ,1       ,0;
                    'aH'            ,' $ Home Trend Productivity $ '	,0        ,1       ,1;
                    'aCo'           ,' $ Mining Trend Productivity $ '	,0        ,1       ,1;
                     };
    
plot_options.n_col	= 3;
plot_options.n_row	= 2;

doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 11

if do_.fig_GGKT_2019(11)
                    %%name              Long Name                       options     params      e_prior     e_obs   e_command 
model_spec =    {
                 	'no_fstar_coint'   	'No Delay in Cointegration'     1          	0       	0           0       0
                    'high_fstar_coint'  'High Delay in Cointegration'   0          	1       	1           0       0
               	}

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end
            
    %           Name            Latex name          shock scale     long_name
Impulse     =   {	        
             	'piFstar'     ,'F^*'                ,1              ,'Figure 11(GGKT_2019): Global price shock';
                };
      
    %                Name           Latex Name                                          Cusum     Factor	Div_ss
Response    = {     'pi'            ,' $ Headline Inflation($4 \pi$) $ '               	,0        ,4       ,0;
                    'piMstar'       ,' $ Change Int. Imports Price($4 \pi^{M^*}$) $ '	,0        ,4       ,0;
                    'piOstar'       ,' $ Change Int. Oil Price($4 \pi^{O^*}$) $ '   	,0        ,4       ,0;
                    'piCostar'    	,' $ Change Int. Copper Price($4 \pi^{Co^*}$) $ '	,0        ,4       ,0;
                    'pistar'        ,' $ Foreign Inflation($4 \pi^*$) $ '            	,0        ,4       ,0;
                     };
    
plot_options.n_col	= 3;
plot_options.n_row	= 2;

doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 13

if do_.fig_GGKT_2019(13)
                    %%name          Long Name                   options     params      e_prior     e_obs   e_command 
model_spec =    {
                 	'calvo'         'Calvo Wages'               1          	0       	0           0       0
               	}

    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);
            
    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

%					Name			Latex name			shock scale		long_name

Impulse = { 		'varomega',		'\varpi',			1,				'Investment';  
					'eR',			'e^R',				1,				'Monetary Policy Rule';
					'xiCG',			'\xi^{C^G}',		1,				'Government Consumption';                  
};

%					Name			Latex Name                              Cusum		Factor		Div_ss
Response = { 		'gam_Y',		' $ GDP $ ',                          	1,			1,			0;
					'pi',			' $ Headline Inflation($4\pi$) $ ',   	0,			4,			0;
					'gam_W',		' $ Real Wages $ ',                   	1,			1,			0;
					'hn',			' $ Total Hours($H \times N$) $ ',    	0,			1,			1;

};

plot_options.n_col	= 4;
plot_options.n_row	= 3;
plot_options.title  = 'Figure 13(GGKT_2019): Demand shocks and the labor market';

doing_plots_c(model_names,Impulse, Response, plot_options)  

end

%% FIG 14,15,16,17 
   

if do_.fig_GGKT_2019(14)|| do_.fig_GGKT_2019(15)||do_.fig_GGKT_2019(16)||do_.fig_GGKT_2019(17)
    
                      	%%name          Long Name                       options     params      e_prior     e_obs  	e_command 
    model_spec_xmas =  {'rec_for_xmas'  'recursive forecast'              0          	0       	0       1     	1}
    model_spec_mas  =  {'rec_for_mas'   'recursive forecast mas proxy'    0          	0       	0       0     	1}
    
    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec_xmas;
    
    solve_models(models,paths);
    cd(paths.model)
    for ii=1:64
        str_aux=[models.modfile '_' num2str(ii)]
        
        if exist(str_aux)==0
        else
            eval(['rmdir ' str_aux ' s'])
        end
    end
        
    paths.model         	= paths.models{2};
    models.modfile          = 'MAS_proxy';
    models.specifications   = model_spec_mas;
    
    solve_models(models,paths);
        cd(paths.model)
    for ii=1:64
        str_aux=[models.modfile '_' num2str(ii)];
        
        if exist(str_aux)==0
        else
            eval(['rmdir ' str_aux ' s'])
        end
    end
    
    cd(paths.results);
    
    forecast_and_RMSE
    
    if do_.fig_GGKT_2019(14)
    
    fig_title='Figure 14(GGKT_2019): Model Forecast of variables present on both Xmas and MAS';   
        for nn=1:min(model_vars)
            if nn==1
                figure('NumberTitle', 'off','Name',fig_title,'units','normalized','outerposition',[0 0 1 1])
                set(gcf,'WindowStyle','docked');
            end
            subplot(4,4,nn)

            for ii=2:nrec+1 
                plot_model1_for=plot(dates1,Forecasts.(var_names{nn,1}).(modelname1)(:,ii),'Color',[1 1 1]*0.0,'LineWidth',0.33);
                hold on  
                plot_model2_for=plot(dates1,Forecasts.(var_names{nn,1}).(modelname2)(:,ii),'Color',[1 1 1]*0.66,'LineWidth',0.33);
                hold on   
            end

            plot_data=plot(dates1,Forecasts.(var_names{nn,1}).(modelname1)(:,1),'Color','k','LineWidth',1.25,'LineStyle', '-');
            hold off

            title(var_names{nn,2},'interpreter','latex','FontSize',12);
            set(gca,'FontSize',8,'FontName','Times')
            xlim([2002.25 2019]);
        end

        h=legend([plot_data,plot_model1_for,plot_model2_for],'Data',[modelname1 ' Forecast'],[modelname2 ' Forecast']);
        set(h,'Position',[0.4 0 0.23 0.51],...
        'Orientation','Horizontal',...
        'Fontsize',8,...
        'Interpreter','Latex');
        legend('boxoff')
    end
    
    if do_.fig_GGKT_2019(15)
    
        fig_title='Figure 15(GGKT_2019): Model Forecast of variables only present on Xmas specification'; 
            for nn=min(model_vars)+1:max(model_vars)
            if nn==min(model_vars)+1
                figure('NumberTitle', 'off','Name',fig_title,'units','normalized','outerposition',[0 0 1 1])
                set(gcf,'WindowStyle','docked');
            end
            subplot(3,3,nn-min(model_vars))

            for ii=2:nrec+1 
                plot_model1_for=plot(dates1,Forecasts.(var_names{nn,1}).(modelname1)(:,ii),'Color',[1 1 1]*0.0,'LineWidth',0.33);
                hold on
            end

            plot_data=plot(dates1,Forecasts.(var_names{nn,1}).(modelname1)(:,1),'Color','k','LineWidth',1.25);
            hold off

            title(var_names{nn,2},'interpreter','latex','FontSize',12);
            set(gca,'FontSize',8,'FontName','Times')
            xlim([2002.25 2019]);
        end

        h=legend([plot_data,plot_model1_for],'Data',[modelname1 ' Forecast']);
        set(h,'Position',[0.4 0 0.23 0.63],...
        'Orientation','Horizontal',...
        'Fontsize',8,...
        'Interpreter','Latex');
        legend('boxoff')
    end
    
    if do_.fig_GGKT_2019(16)

    fig_title='Figure 16(GGKT_2019): RMSE 1 to 8 periods ahead vor variables observed on both Xmas and MAS specifications'; 
        for i=1:numel(dates1)
        yy=floor(dates1(i));
        qq=dates1(i)-floor(dates1(i));
        if qq==0; qq2='Q1'; elseif qq==0.25; qq2='Q2'; elseif qq==0.5; qq2='Q3'; else; qq2='Q4'; end
        dates2{i}=[num2str(yy)  qq2];
        end

        for nn=1:min(model_vars)   
            if nn==1
                figure('NumberTitle', 'off','Name',fig_title,'units','normalized','outerposition',[0 0 1 1])
                set(gcf,'WindowStyle','docked');
            end
            subplot(4,4,nn)
            plot_data_sd=plot(ones(1,nfor)*SD.(var_names{nn,1}).(modelname1)(1),'Color','k','LineWidth',1,'LineStyle',':');
            hold on 
            plot_model2_rmse=plot(MSE.(var_names{nn,1}).(modelname2),'Color',[1 1 1]*0.66,'LineWidth',1,'LineStyle','-');
            hold on 
            plot_model1_rmse=plot(MSE.(var_names{nn,1}).(modelname1),'Color',[1 1 1]*0.0,'LineWidth',1,'LineStyle','-');
            hold on  

            rmse_high=MSE_025.(var_names{nn,1}).(modelname1);
            rmse_low=MSE_975.(var_names{nn,1}).(modelname1);
            
            plot_model1_rmse_high=plot(rmse_high,'Color',[1 1 1]*0.0,'LineWidth',1,'LineStyle','--','LineWidth',1);
            hold on 
            plot_model1_rmse_low=plot(rmse_low,'Color',[1 1 1]*0.0,'LineWidth',1,'LineStyle','--','LineWidth',1);          
            hold off

            title(var_names{nn,2},'interpreter','latex','FontSize',12);
            set(gca,'FontSize',8,'FontName','Times')
            xlim([1 8]);
        end

         h=legend([plot_model1_rmse,plot_model2_rmse,plot_data_sd],[modelname1 ' RMSE'],[modelname2 ' RMSE'],['Obs. variable std. dev.(' dates2{1+drop} '-' dates2{end-nfor} ')']);
        set(h,'Position',[0.4 0 0.23 0.51],...
        'Orientation','Horizontal',...
        'Fontsize',8,...
        'Interpreter','Latex');
        legend('boxoff')

    
    end
    
    if do_.fig_GGKT_2019(17)
    fig_title='Figure 17(GGKT_2019): RMSE 1 to 8 periods ahead vor variables observed only on Xmas specification'; 
    for nn=min(model_vars)+1:max(model_vars)
            if nn==min(model_vars)+1
                figure('NumberTitle', 'off','Name',fig_title,'units','normalized','outerposition',[0 0 1 1])
                set(gcf,'WindowStyle','docked');
            end
            subplot(3,3,nn-min(model_vars))

            plot_model1_rmse=plot(MSE.(var_names{nn,1}).(modelname1),'Color',[1 1 1]*0.0,'LineWidth',1.25);
            hold on  

            plot_data_sd=plot(ones(1,nfor)*SD.(var_names{nn,1}).(modelname1)(1),'Color','k','LineWidth',1,'LineStyle',':');
            hold on 
            
            rmse_high=MSE.(var_names{nn,1}).(modelname1)+MSE_std.(var_names{nn,1}).(modelname1);
            rmse_low=MSE.(var_names{nn,1}).(modelname1)-MSE_std.(var_names{nn,1}).(modelname1);
            
            plot_model1_rmse_high=plot(rmse_high,'Color',[1 1 1]*0.0,'LineWidth',1,'LineStyle','--');
            hold on 
            plot_model1_rmse_low=plot(rmse_low,'Color',[1 1 1]*0.0,'LineWidth',1,'LineStyle','--');          
            hold off

            title(var_names{nn,2},'interpreter','latex','FontSize',12);
            set(gca,'FontSize',8,'FontName','Times')
            xlim([1 8]);
            %ylim([0 inf]);
   end

        h=legend([plot_model1_rmse,plot_data_sd],[modelname1 ' RMSE'],['Obs. variable std. dev.(' dates2{1+drop} '-' dates2{end-nfor} ')']);
        set(h,'Position',[0.4 0 0.23 0.63],...
        'Orientation','Horizontal',...
        'Fontsize',8,...
        'Interpreter','Latex');
        legend('boxoff')
        
    end
    
   cd(paths.local) 

end


%%

cd(paths.local)