% Plot and save impulse responses
function doing_plots_c(model_names,Impulse, Response, plot_options)   


n_cols		= plot_options.n_col;
n_rows		= plot_options.n_row;									
marks      = {'-k','-.k',':k','--k'};
horizon		= 20;
grid_on		= 0;
latex		= 1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure('NumberTitle', 'off','Name',plot_options.title)
set(gcf,'WindowStyle','docked');

n_shocks = n_rows;
n_variables = n_cols;
n_models = length(model_names);

scale = cell2mat(Impulse(:,3));
cusum = cell2mat(Response(:,3));
factor = cell2mat(Response(:,4));
div_ss = cell2mat(Response(:,5));

ir_all = nan(horizon,n_models);

for ii=1:n_shocks
	for jj=1:n_variables
	
		subplot(n_rows,n_cols,4*(ii-1)+jj);
		sh = char(Impulse(ii,1));
		va = char(Response(jj,1));
		
		for kk=1:n_models
			load(char(model_names(kk,1)))
			if isempty(loc(M_.endo_names,va))==0
				if div_ss(jj)
					va_ss = abs(oo_.steady_state(loc(M_.endo_names,va)));
				else
					va_ss = 1;
				end
				if isfield(oo_.irfs,[va '_eps_' sh])
					if cusum(jj)==0
						ir = getfield(oo_.irfs,[va '_eps_' sh])...
							*100*scale(ii)*factor(jj)/va_ss;
					elseif cusum(jj)==1
						ir = cumsum(getfield(oo_.irfs,[va '_eps_' sh]))...
							*100*scale(ii)*factor(jj)/va_ss;
					end
				else
					ir = zeros(1,horizon);
				end
				ir_all(:,kk) = ir(1:horizon);
			else
				ir_all(:,kk) = 0;
			end
        end
        
        if jj==1
            adj = ir_all(1,1);
        end
        
        ir_all = ir_all/adj;
		
		for kk=1:n_models
			hold on;
			plot(1:horizon,ir_all(:,kk),[marks{kk}],'LineWidth',1.25);
		end
		
		if grid_on==1
			grid on;
		end
		
		if latex==1
			va_name = char(Response(jj,2));
			sh_name = char(Impulse(ii,2));
		else
			va_name = va;
			sh_name = sh;
		end
		
        title(['$' sh_name ' \Rightarrow ' va_name '$'],'interpreter','latex','FontSize',12)
		set(gca,'FontSize',8,'FontName','Times')
		xlim([1 horizon]);
		yl=ylim;
        lim_=0.01;
		if max(abs(yl))<lim_
			ylim([min(-lim_,yl(1)) ,   max(lim_,yl(2))])
		end
		hold off;
    end
    pause(0.01)
    if ii==1
    legend_names = model_names(:,2)'
    h=legend(legend_names);
    set(h,'Position',[0.4 0 0.23 0.03],...
        'Orientation','Horizontal',...
        'Fontsize',8,...
        'Interpreter','Latex');
    legend('boxoff')
    end
end



end

