
% NKSOE Quantitative Model

////////////////////////////////////////////////////////////////////////////////////////////
// 0. Housekeeping and options ------------------------------------------------------------/
////////////////////////////////////////////////////////////////////////////////////////////



%close all;
clc;

@#include "options_XMAS_dtbc.inc"


		
////////////////////////////////////////////////////////////////////////////////////////////
// 1. Preamble ----------------------------------------------------------------------------/ 
////////////////////////////////////////////////////////////////////////////////////////////

	// Endogenous variables ----------------------------------------------------------------

		@#define endo_vars_base   	= [ "bPr"			,\\
										"bR"			,\\
										"bUFA"      	,\\
										"c"				,\\
										"cA"			,\\
										"cfCotil"		,\\
										"cfCo_cyc"		,\\
										"cG"			,\\
										"chitilNR" 		,\\
										"chitilR" 		,\\
										"cNR"			,\\
                                        "cPr"			,\\
										"cR"			,\\
										"chatNR"		,\\
										"chatR"			,\\
										"cZ"			,\\
										"d"				,\\
										"dR"			,\\
										"bG" 			,\\
										"DelF"			,\\
										"DelH"			,\\
										"DelHstar"		,\\	
										"bstar"			,\\
										"bGstar"		,\\
										"bPrstar"		,\\
										"bRstar"		,\\
										"fF"			,\\
										"fH"			,\\
										"fHstar"		,\\							
										"fstar"         ,\\
										"g"				,\\
										"gGamaF"		,\\
										"gGamaH"		,\\
										"gGamaHstar"	,\\									
										"gtil"			,\\
										"gtilExo"		,\\
										"gtilRule"		,\\
										"h"				,\\
										"hn"			,\\
										"i"				,\\
										"iACo"			,\\
										"iAG"			,\\
										"iCo"			,\\
										"iCof"			,\\	
										"iG"			,\\
										"imp"			,\\
										"if"			,\\
										"iR"			,\\
										"itot"	 		,\\
										"k"				,\\
										"kCo"			,\\
										"kG"			,\\
										"kR"			,\\
										"kS"			,\\
										"kSR"			,\\
										"ktil"			,\\
										"lamCo"			,\\
										"lamNR"			,\\
										"lamR"			,\\
										"mcF"			,\\
										"mcH"			,\\
										"mcHstar"		,\\
										"mcZtil"        ,\\							
										"n" 			,\\
										"o"				,\\
										"oC"			,\\
										"xO"			,\\
										"pA"			,\\
										"pCG"			,\\
										"pCostar"		,\\
										"pZ"			,\\
										"pF"			,\\
										"phi_ubar"		,\\
										"phi_uCo"		,\\
										"pH"			,\\
										"pHtil"			,\\
										"pHstar"		,\\
										"pi"			,\\
										"pistar"		,\\
										"piS"			,\\
										"pitil"			,\\
										"pI"			,\\
										"pICo"			,\\
										"pIG"			,\\
										"pMstar"		,\\
										"pO"			,\\
										"pOstar"		,\\
										"cfCo"			,\\
										"ptilCostar"	,\\
										"ptilF"			,\\
										"ptilH"			,\\
										"ptilHstar"		,\\
										"pY"			,\\
										"q"				,\\
										"qCo"			,\\
										"R"				,\\
										"Rbar"			,\\
										"renRstar"		,\\
										"renstar"		,\\
										"rer"			,\\
										"rK"			,\\
										"rKCo"			,\\
										"rKtil"			,\\
										"stb"			,\\
										"t"				,\\
										"tR"			,\\
										"tNR"			,\\
										"tau"			,\\
										"tau_cyc"		,\\
										"tauL"			,\\								
										"tautil"		,\\
										"tb"			,\\
										"ThetaNR" 		,\\
										"ThetaR"    	,\\
										"trG"			,\\
										"trNR"			,\\
										"trR"			,\\
										"trUFA" 		,\\
										"u" 			,\\
										"ubar"			,\\
										"uCo"			,\\
										"w"				,\\
										"wedCo"			,\\
										"wedH"			,\\
										"xAF"			,\\
										"xAH"			,\\
										"xF"			,\\
										"xH"			,\\
										"xZF"			,\\
										"xCGF"			,\\
										"xCGH"			,\\
										"xZH"			,\\
										"xHstar"		,\\
										"xi"			,\\
										"xCoH"			,\\
										"xCoF"          ,\\
										"xIF"			,\\
										"xIGF"			,\\
										"xIGH"			,\\
										"xIH" 			,\\
                                        "xL"			,\\
										"y"				,\\
										"yr"			,\\
										"yC"			,\\
										"yCo"			,\\
										"yF"			,\\
										"yH"			,\\
										"yHstar"		,\\
										"yHtil"			,\\
										"yZtil"		,\\
										"ystar"			]
							 
		@#define endo_vars_search	= [	"cbar" 			,\\
										"e" 			,\\
										"gammaW" 		,\\
										"hC" 			,\\
										"psiU"			,\\
										"rho" 			,\\
										"rhon" 			,\\
										"s" 			,\\
										"sigmaU" 		,\\
										"sNRU" 			,\\
										"sRU" 			,\\
										"v" 			,\\
										"wn"			]

		@#define endo_vars_cw    	= [	"DelW"      	,\\
										"fW"			,\\
										"gGamaW"		,\\
										"hd"			,\\
										"lamU"			,\\
										"ThetaU"		,\\
										"mcW"			,\\
										"wtil"      	]
										
	// Exogenous AR(1) state variables -----------------------------------------------------
		
		@#define state_vars_base  	= [ "a"				,\\ 
										"eR"			,\\
										"kappa"     	,\\
										"pibar"			,\\
										"piFstar"   	,\\
										"Rstar"			,\\
										"varomega"		,\\
										"varomegaCo"	,\\
										"varrho"		,\\
										"xiCG"			,\\
										"xiCostar"		,\\
										"xiG"			,\\
										"xiIG"			,\\
										"xiMstar"		,\\
										"xiO"			,\\
										"xiOstar"		,\\
										"xiREN"			,\\
										"xiTR"			,\\
										"xistar"    	,\\
										"xiXHstar"  	,\\
										"z"				,\\
										"zA"			,\\
										"zCo"			,\\
										"zetao"			,\\
										"zetau"			,\\
										"zstar"			]
									
		@#define state_vars_tau  	= [ "tauC"			,\\
										"tauCo"			,\\
										"tauD"			,\\
										"tauK"			,\\
										"tauUFA" 		,\\
										"tauW"			]
		
		@#define state_vars_search	= [	"m"         	,\\
										"rhox"      	]

	// Auxiliary variable definitions ------------------------------------------------------
	
		@#define def_vars_base		= [	"aCo"			,\\
										"aH"			,\\
										"bGtot"			,\\
										"bGstar_tot"	,\\
										"bPrstar_tot"	,\\
										"gam_C"			,\\
										"gam_CG"		,\\
										"gam_CR"		,\\
										"gam_CNR"		,\\
										"gam_BSTAR"		,\\
										"gam_BGSTAR"	,\\
										"gam_BPRSTAR"	,\\
										"gam_I"			,\\
										"gam_IACo"		,\\
										"gam_IAG"		,\\
										"gam_ICo"		,\\
										"gam_IG"		,\\
										"gam_G"			,\\
										"gam_Gtil"		,\\
										"gam_K"			,\\
										"gam_KCo"		,\\
										"gam_KG"		,\\
										"gam_M"			,\\
										"gam_O"			,\\
										"gam_OC"		,\\
										"gam_XO"		,\\
										"gam_TRG"		,\\
										"gam_W"			,\\
										"gam_WN"		,\\
										"gam_XHstar"	,\\
										"gam_Y"			,\\
										"gam_YC"		,\\
										"gam_YCo"		,\\
										"gam_YF"		,\\
										"gam_YH"		,\\
										"gam_YHstar"	,\\
										"gam_YR"		,\\
										"gam_Ystar"		,\\ 
										"piA"			,\\
										"piCostar"		,\\
										"piH"			,\\
										"piF"			,\\
										"piHX"			,\\
										"piMstar"		,\\
										"piMtot"		,\\
										"piO"			,\\
										"piOstar"		,\\
										"piZ"			,\\
										"gam4_Y"		,\\
										"gam4_YR"		,\\
										"pi4"			,\\
										"piZ4"			,\\
										"pi4_E1"		,\\
										"pi4_E2"		,\\
										"pi4_E4"		,\\
										"sbstar"		,\\
										"yD"			,\\
										"yDr"			]

		@#define def_vars_search	= [	"job_cr"		,\\
										"job_des_endo"	,\\
										"job_des_exo"	,\\
										"job_des_tot"	]

		@#define def_vars_cw		= [	"gam_LAM"		]
		
	// Observable variable definitions -----------------------------------------------------
								
		@#define obs_vars_base		= [	"cG_obs"		,\\
										"dR_obs"		,\\
										"e_tauK_obs"	,\\
										"e_tauK2_obs"	,\\
										"e_tauK6_obs"	,\\
										"e_tauK10_obs"	,\\
										"e_tauK14_obs"	,\\
										"gam_C_obs"		,\\
										"gam_CG_obs"	,\\
										"gam_HN_obs"	,\\
										"gam_I_obs"		,\\
										"gam_ICo_obs"	,\\
										"gam_IG_obs"	,\\
										"gam_TRG_obs"	,\\
										"gam_W_obs"		,\\
										"gam_WN_obs"	,\\
										"gam_Y_obs"		,\\
										"gam_YCo_obs"	,\\
										"gam_YHstar_obs",\\
										"gam_YR_obs"	,\\
										"gam_Ystar_obs"	,\\
										"pCostar_obs"	,\\
										"pi_obs"		,\\
										"piA_obs"		,\\
										"piCostar_obs"	,\\
										"piM_obs"		,\\
										"piMstar_obs"	,\\
										"piO_obs"		,\\
										"piOstar_obs"	,\\
										"pistar_obs"	,\\
										"piS_obs"		,\\
										"piZ_obs"		,\\
										"pMstar_obs"	,\\
										"pOstar_obs"	,\\ 
										"rer_obs"		,\\
										"R_obs"			,\\
										"Rstar_obs"		,\\
										"stb_obs"		,\\
										"xi_obs"		,\\
										"yCo_obs"		,\\
										"ystar_obs"		,\\
										"h_obs"			,\\
										"n_obs"			,\\
										"gam_H_obs"		,\\
										"gam_N_obs"		,\\
										"hn_obs"		]
		

		
        @#if search
            @#define endo_vars = endo_vars_base + endo_vars_search + def_vars_base + def_vars_search + obs_vars_base
            @#define state_vars = state_vars_base + state_vars_search + state_vars_tau
        @#else
            @#define endo_vars = endo_vars_base + endo_vars_cw + def_vars_base + def_vars_cw + obs_vars_base
            @#define state_vars = state_vars_base + state_vars_tau
        @#endif
								
	// Declare variables -------------------------------------------------------------------
	
		@#for vars in endo_vars + state_vars
			var @{vars};
		@#endfor	
		
		@#for vars in state_vars
			varexo eps_@{vars};
		@#endfor
		
		varexo eps_tauK2 eps_tauK6 eps_tauK10 eps_tauK14;	

	// Define Parameters -------------------------------------------------------------------
	
		// Deep parameters
			parameters BETTA SIGMA VARSIGMA PHI bigPSI;
			parameters OMEGA OMEGA_UFA OMEGA_G OMEGA_U;
			parameters ALPHA ALPHA_Co;
			parameters DELTA DELTA_G DELTA_Co;
			parameters PHI_I PHI_ICo;
			parameters PHI_UBAR PHI_UCo;
			parameters EPSILON_H EPSILON_F EPSILON_Hstar EPSILON_W;
			parameters THETA_H THETA_F THETA_Hstar THETA_W;
			parameters VARTHETA_H VARTHETA_F VARTHETA_Hstar VARTHETA_IDX;
			parameters KAPPA_A KAPPA_O O_O;
			parameters ETA_C ETA_O;
			parameters O_Z O_IG O_A O_Co;
			parameters ETA_Z ETA_IG ETA_A ETA_Co;
		@#if diff_final_goods
			parameters O_I O_CG;
			parameters ETA_I ETA_CG;
		@#endif
			parameters MU ub VARPHI_U VARKAPPA_W UPSILON VARTHETA_W ALPHA_W;
			parameters SIGMA_CTIL MU_CTIL OMEGA_V srhox;
			parameters CHI_CO L_BAR N_Co RHO_VARPHI_Co;
		@#for j in 1:iCo_lags									
			parameters VARPHI_Co_@{j-1};
		@#endfor
			parameters ALPHA_CG ALPHA_IG ALPHA_D;
			parameters sb ALPHA_T VAREPSILON_T sDEF_ss n_pCostar GAMMA_D;
			parameters O_KG ETA_KG N_G RHO_VARPHI;
		@#for j in 1:iG_lags									
			parameters VARPHI_@{j-1};
		@#endfor
			parameters RHO_R ALPHA_PI ALPHA_PIz ALPHA_PIE ALPHA_Y;
			parameters OSTAR ETASTAR RHO_XHstar;
			parameters GAMMA_H GAMMA_Co;
			parameters GAMMA_star GAMMA_Mstar GAMMA_Costar GAMMA_Ostar;
			parameters VAREPSILON_UFA trUFAbar;
			parameters RHO_O ALPHA_O sOC;
			parameters O_CHAT ETA_CHAT;
			parameters pYy_ss scG_ss siG_ss str_ss sca_ss;
			parameters sCo_ss pCo_ss siCo_ss kCo_yCo_ss utCo_ss;
			parameters DifFinalGoods Search OilProd ValGovCons PubGoods yHstarVA_ss ADM_COST_RAT;
			parameters ZERO;
			
		// Steady state parameters
		@#for vars in endo_vars + state_vars
			parameters @{vars}_ss;
		@#endfor
		
		// Parameters of exogenous AR(1) state variables
		@#for vars in state_vars_base + state_vars_search + state_vars_tau
			parameters RHO_@{vars} SIG_@{vars};
		@#endfor		
	
	// Options used as parameters	--------------------------------------------------- 
	
			LogUt 			= @{log_utility};
			DifFinalGoods	= @{diff_final_goods};	
			DistTaxes		= @{dist_taxes};
			ValGovCons		= @{val_gov_cons};	
			GovTr			= @{gov_transfers};
			PubGoods		= @{public_goods};
			NonRic			= @{non_ricardian};
			NomFricHom		= @{nom_fric_hom};
			NomFricExp		= @{nom_fric_exp};
			NomFricImp		= @{nom_fric_imp};
			NomFricWag		= @{nom_fric_wag};
			TvIt 			= @{tv_it};
			OilCons 		= @{oil_cons};
			OilProd 		= @{oil_prod};
			MEPCO 			= @{oil_mepco};
			DebtDol			= @{debt_dol};
			AgricCons		= @{agric_cons};
			VarCapUtil		= @{var_cap_util};
			VarCapUtilCommo	= @{var_cap_util_commo};
			EndoCommo		= @{endo_commo};
			CointProd		= @{coint_prod};
            CointPrice		= @{coint_price};
            Search          = @{search};
	
	// Parameter values	(value is overridden if parameter is included in the estimation section) --------------------------------------------------- 
				
	@#include "param_values_XMAS_dtbc.inc"	
		
	// Steady state values of observables	
		@#for x in obs_vars_base 
			@{x}_ss=0;
		@#endfor		
		
////////////////////////////////////////////////////////////////////////////////////////////
// 2. Model -------------------------------------------------------------------------------/
////////////////////////////////////////////////////////////////////////////////////////////

	model; 
	
	// Aux vars ----------------------------------------------------------------------------
	
		// Real stochastic discount factor	
			@#for s in 0:iCo_lags
			#CHI_R_@{s}=BETTA^@{s}*(varrho(@{s})/varrho)*(lamR(+@{s})/lamR)  
				*a(-1)^SIGMA
				@#for i in 0:s
					/a(@{i-1})^SIGMA
				@#endfor
			;	
			@#endfor
			
		// Home bias different sectors
			@#if diff_final_goods==0
				#O_CG=O_Z;
				#O_I=O_Z;	
				#ETA_CG=ETA_Z;
				#ETA_I=ETA_Z;
			@#endif			

	// Equilibrium conditions --------------------------------------------------------------
	
		// E1 to E20 - Households
			chatR					= ((1-O_CHAT)^(1/ETA_CHAT)*(cR-VARSIGMA*cR(-1)/a(-1))^((ETA_CHAT-1)/ETA_CHAT)+O_CHAT^(1/ETA_CHAT)*cG^((ETA_CHAT-1)/ETA_CHAT))^(ETA_CHAT/(ETA_CHAT-1));
			chatNR					= ((1-O_CHAT)^(1/ETA_CHAT)*(cNR-VARSIGMA*cNR(-1)/a(-1))^((ETA_CHAT-1)/ETA_CHAT)+O_CHAT^(1/ETA_CHAT)*cG^((ETA_CHAT-1)/ETA_CHAT))^(ETA_CHAT/(ETA_CHAT-1));
			tauL					= tauUFA+tauW;
			kSR						= ubar*kR(-1)/a(-1);
			phi_ubar                = rK/PHI_UBAR*(exp(PHI_UBAR*(ubar-1))-1);
            kR						= (1-DELTA)*kR(-1)/a(-1)+(1-PHI_I/2*(iR/iR(-1)*a(-1)-a_ss)^2)*varomega*iR;
			(1+tauC)*lamR			= (chatR)^(-SIGMA)*((1-O_CHAT)*chatR/(cR-VARSIGMA*cR(-1)/a(-1)))^(1/ETA_CHAT);
			lamR					= BETTA/a^SIGMA*R*varrho(+1)/varrho*lamR(+1)/pi(+1);
			lamR					= BETTA/a^SIGMA*Rstar*xi*varrho(+1)/varrho*piS(+1)*lamR(+1)/pi(+1);
			q						= BETTA/a^SIGMA*varrho(+1)/varrho*lamR(+1)/lamR*(rK(+1)*ubar(+1)*(1-tauK(+1))+q(+1)*(1-DELTA)+pI(+1)*(tauK(+1)*DELTA-phi_ubar(+1)*(1-tauK(+1))));
			pI/q					= (1-PHI_I/2*(iR/iR(-1)*a(-1)-a_ss)^2-PHI_I*(iR/iR(-1)*a(-1)-a_ss)*iR/iR(-1)*a(-1))*varomega+BETTA/a^SIGMA*PHI_I*varrho(+1)/varrho*q(+1)/q*lamR(+1)/lamR*(iR(+1)/iR*a-a_ss)*(iR(+1)/iR*a)^2*varomega(+1);
			ubar					= 1+(log(rK/rK_ss)-log(pI))/PHI_UBAR;
			xi						= xi_ss*exp(-bigPSI/100*(rer*bstar/pY/y-rer_ss*bstar_ss/pY_ss/y_ss)+(zetao-zetao_ss)/zetao_ss+(zetau-zetau_ss)/zetau_ss);
			bstar					= bPrstar+bGstar;
			(1+tauC)*lamNR			= (chatNR)^(-SIGMA)*((1-O_CHAT)*chatNR/(cNR-VARSIGMA*cNR(-1)/a(-1)))^(1/ETA_CHAT);
			(1+tauC)*cNR			= (1-tauL)*w*n*h+u*ub+trNR-tNR;
				#chatRbar           = ((1-O_CHAT)^(1/ETA_CHAT)*(cR-VARSIGMA*cR(-1)/a(-1))^((ETA_CHAT-1)/ETA_CHAT)+O_CHAT^(1/ETA_CHAT)*cG_ss^((ETA_CHAT-1)/ETA_CHAT))^(ETA_CHAT/(ETA_CHAT-1));	
				#chatNRbar          = ((1-O_CHAT)^(1/ETA_CHAT)*(cNR-VARSIGMA*cNR(-1)/a(-1))^((ETA_CHAT-1)/ETA_CHAT)+O_CHAT^(1/ETA_CHAT)*cG_ss^((ETA_CHAT-1)/ETA_CHAT))^(ETA_CHAT/(ETA_CHAT-1));	
			ThetaR                  = chitilR*wedH(-1)^SIGMA*(chatRbar)^-SIGMA;
			ThetaNR                 = chitilNR*wedH(-1)^SIGMA*(chatNRbar)^-SIGMA;
			chitilR                 = chitilR(-1)^(1-UPSILON)*wedH(-1)^(-SIGMA*UPSILON)*(chatRbar)^(SIGMA*UPSILON);
			chitilNR                = chitilNR(-1)^(1-UPSILON)*wedH(-1)^(-SIGMA*UPSILON)*(chatNRbar)^(SIGMA*UPSILON);
			
		// E23 to E28 - Labor Market
		@#if search
			n 						= (1-rho)*(n(-1)+m(-1)*v(-1)^(1-MU)*u(-1)^MU);
			u 						= 1-n;
			s 						= m*(v/u)^(1-MU);
			e 						= m*(v/u)^-MU;
			rho 					= rhox+(1-rhox)*rhon;
			rhon 					= 1-normcdf((log(cbar)-MU_CTIL)/SIGMA_CTIL);
		@#else
			n						= 1;
			u 						= 1-n;
		@#endif
			
		// E29 to E50 - Final Goods
			c						= ((1-KAPPA_O-KAPPA_A)^(1/ETA_C)*cZ^((ETA_C-1)/ETA_C)+KAPPA_O^(1/ETA_C)*oC^((ETA_C-1)/ETA_C)+KAPPA_A^(1/ETA_C)*cA^((ETA_C-1)/ETA_C))^(ETA_C/(ETA_C-1));
			cZ						= (1-KAPPA_O-KAPPA_A)*pZ^-ETA_C*c;
			oC						= KAPPA_O*pO^-ETA_C*c;
			cA						= KAPPA_A*pA^-ETA_C*c;
			cZ						= ((1-O_Z)^(1/ETA_Z)*xZH^((ETA_Z-1)/ETA_Z)+O_Z^(1/ETA_Z)*xZF^((ETA_Z-1)/ETA_Z))^(ETA_Z/(ETA_Z-1));
			xZH						= (1-O_Z)*(pH/pZ)^(-ETA_Z)*cZ;
			xZF						= O_Z*(pF/pZ)^(-ETA_Z)*cZ;
			cA						= zA*((1-O_A)^(1/ETA_A)*xAH^((ETA_A-1)/ETA_A)+O_A^(1/ETA_A)*xAF^((ETA_A-1)/ETA_A))^(ETA_A/(ETA_A-1));
			xAH						= zA^(ETA_A-1)*(1-O_A)*(pH/pA)^-ETA_A*cA;
			xAF						= zA^(ETA_A-1)*O_A*(pF/pA)^-ETA_A*cA;
			cG						= ((1-O_CG)^(1/ETA_CG)*xCGH^((ETA_CG-1)/ETA_CG)+O_CG^(1/ETA_CG) *xCGF^((ETA_CG-1)/ETA_CG))^(ETA_CG/(ETA_CG-1));
			xCGH					= (1-O_CG)*(pH/pCG)^(-ETA_CG)*cG;
			xCGF					= O_CG*(pF/pCG)^(-ETA_CG)*cG;
			if						= ((1-O_I)^(1/ETA_I)*xIH^((ETA_I-1)/ETA_I)+O_I^(1/ETA_I)*xIF^((ETA_I-1)/ETA_I))^(ETA_I/(ETA_I-1));
			xIH						= (1-O_I)*(pH/pI)^(-ETA_I)*if;
			xIF						= O_I*(pF/pI)^(-ETA_I)*if;
			if						= i+phi_ubar*k(-1)/a(-1);
			iCof					= ((1-O_Co)^(1/ETA_Co)*xCoH^((ETA_Co-1)/ETA_Co)+O_Co^(1/ETA_Co)*xCoF^((ETA_Co-1)/ETA_Co))^(ETA_Co/(ETA_Co-1));
			xCoH					= (1-O_Co)*(pH/pICo)^(-ETA_Co)*iCof;
			xCoF					= O_Co*(pF/pICo)^(-ETA_Co)*iCof;
			iG						= ((1-O_IG)^(1/ETA_IG)*xIGH^((ETA_IG-1)/ETA_IG)+O_IG^(1/ETA_IG)*xIGF^((ETA_IG-1)/ETA_IG))^(ETA_IG/(ETA_IG-1));
			xIGH					= (1-O_IG)*(pH/pIG)^(-ETA_IG)*iG;
			xIGF					= O_IG *(pF/pIG)^(-ETA_IG)*iG;
			
		// E51 to E65 - Differentiated Varieties
					// E51 to E65 - Differentiated Varieties
			fH						= ptilH^-EPSILON_H*yH*mcH+BETTA*THETA_H/a^(SIGMA-1)*varrho(+1)/varrho*lamR(+1)/lamR*(gGamaH/pi(+1))^-EPSILON_H*(ptilH/ptilH(+1))^-EPSILON_H*(pH/pH(+1)*(1+tauC(+1))/(1+tauC))^(-1-EPSILON_H)*fH(+1);
			fH						= ptilH^(1-EPSILON_H)*yH*(EPSILON_H-1)/EPSILON_H+BETTA/a^(SIGMA-1)*THETA_H*varrho(+1)/varrho*lamR(+1)/lamR*(gGamaH/pi(+1))^(1-EPSILON_H)*(ptilH/ptilH(+1))^(1-EPSILON_H)*(pH/pH(+1)*(1+tauC(+1))/(1+tauC))^-EPSILON_H*fH(+1);
			1						= (1-THETA_H)*ptilH^(1-EPSILON_H)+THETA_H*(pH(-1)/pH*gGamaH(-1)/pi*(1+tauC)/(1+tauC(-1)))^(1-EPSILON_H);
            mcH                     = pHtil/pH;
			#pi_index=pi^VARTHETA_IDX*piZ^(1-VARTHETA_IDX);
			gGamaH					= pi_index^VARTHETA_H*pi_ss^(1-VARTHETA_H);
			fF						= ptilF^-EPSILON_F*yF*mcF+BETTA/a^(SIGMA-1)*THETA_F*varrho(+1)/varrho*lamR(+1)/lamR*(gGamaF/pi(+1))^-EPSILON_F*(ptilF/ptilF(+1))^-EPSILON_F*(pF/pF(+1)*(1+tauC(+1))/(1+tauC))^(-1-EPSILON_F)*fF(+1);
			fF						= ptilF^(1-EPSILON_F)*yF*(EPSILON_F-1)/EPSILON_F+BETTA/a^(SIGMA-1)*THETA_F*varrho(+1)/varrho*(lamR(+1)/lamR*(gGamaF/pi(+1))^(1-EPSILON_F)*(ptilF/ptilF(+1))^(1-EPSILON_F)*(pF/pF(+1)*(1+tauC(+1))/(1+tauC))^-EPSILON_F*fF(+1));
			1						= (1-THETA_F)*ptilF^(1-EPSILON_F)+THETA_F*(pF(-1)/pF*gGamaF(-1)/pi*(1+tauC)/(1+tauC(-1)))^(1-EPSILON_F);
			mcF						= pMstar*rer/pF;
			gGamaF					= pi_index^VARTHETA_F*pi_ss^(1-VARTHETA_F);
			fHstar					= ptilHstar^-EPSILON_Hstar*yHstar*mcHstar+BETTA*THETA_Hstar/a^(SIGMA-1)*varrho(+1)/varrho*lamR(+1)/lamR*(gGamaHstar/pistar(+1))^-EPSILON_Hstar*(ptilHstar/ptilHstar(+1))^-EPSILON_Hstar*(pHstar/pHstar(+1))^(-1-EPSILON_Hstar)*fHstar(+1);
			fHstar					= ptilHstar^(1-EPSILON_Hstar)*yHstar*(EPSILON_Hstar-1)/EPSILON_Hstar+BETTA/a^(SIGMA-1)*THETA_Hstar*varrho(+1)/varrho*lamR(+1)/lamR*(gGamaHstar/pistar(+1))^(1-EPSILON_Hstar)*(ptilHstar/ptilHstar(+1))^(1-EPSILON_Hstar)*(pHstar/pHstar(+1))^-EPSILON_Hstar*fHstar(+1);
			1						= (1-THETA_Hstar)*ptilHstar^(1-EPSILON_Hstar)+THETA_Hstar*(pHstar(-1)/pHstar*gGamaHstar(-1)/pistar)^(1-EPSILON_Hstar);
			mcHstar					= pHtil/(rer*pHstar);
			gGamaHstar				= pistar^VARTHETA_Hstar*pistar_ss^(1-VARTHETA_Hstar);
			
		// E66 to E75 - Wholesale Domestic Goods
			yHtil					= z*((1-O_O)^(1/ETA_O)*yZtil^((ETA_O-1)/ETA_O)+O_O^(1/ETA_O)*xO^((ETA_O-1)/ETA_O))^(ETA_O/(ETA_O-1));
            yZtil                   = z^(ETA_O-1)*(1-O_O)*(mcZtil/pHtil)^-ETA_O*yHtil;
			xO						= z^(ETA_O-1)*O_O*(pO/pHtil)^-ETA_O*yHtil;
			yZtil					= ktil^ALPHA*(a*wedH*n*h)^(1-ALPHA);
			ktil					= ALPHA*(rKtil/mcZtil)^-1*yZtil;
			ktil					= ((1-O_KG)^(1/ETA_KG)*kS^((ETA_KG-1)/ETA_KG)+O_KG^(1/ETA_KG)*(kG(-1)/a(-1))^((ETA_KG-1)/ETA_KG))^(ETA_KG/(ETA_KG-1));
            kS                      = (1-O_KG)*(rK/rKtil)^-ETA_KG*ktil;
			@#if search
				pH*wedH(-1)*OMEGA_V/e	= BETTA*a^(1-SIGMA)*varrho(+1)/varrho*lamR(+1)/lamR*(1-rho(+1))*(mcZtil(+1)*(1-ALPHA)*yZtil(+1)/n(+1)-w(+1)*h(+1)-pH(+1)*hC(+1)+pH(+1)*wedH*OMEGA_V/e(+1));
                pH*wedH(-1)*cbar		= mcZtil*(1-ALPHA)*yZtil/n-w*h+pH*wedH(-1)*OMEGA_V/e;
                hC                  	= wedH(-1)*exp(MU_CTIL+SIGMA_CTIL^2/2)*normcdf((log(cbar)-MU_CTIL-SIGMA_CTIL^2)/SIGMA_CTIL)/(1-rhon);
			@#endif
		
		// E76 to E93 - Wages and Hours
		@#if search
			h						= ((mcZtil*(1-ALPHA)^2*yZtil/n)/(psiU*kappa/(1-tauL)*(wedH(-1))^(1-SIGMA)))^(1/(1+PHI));
			wn*h                    = VARPHI_U*(mcZtil*(1-ALPHA)*yZtil/n-pH*hC+pH/e*wedH(-1)*OMEGA_V)+(1-VARPHI_U)/(1-tauL)*(ub+psiU*kappa*(wedH(-1))^(1-SIGMA)*h^(1+PHI)/(1+PHI)-(1-s)*sigmaU);
			sigmaU					= (1-OMEGA_U)*BETTA/a^(SIGMA-1)*varrho(+1)/varrho*lamR(+1)/lamR*(1-rho(+1))*sRU(+1)+OMEGA_U*BETTA/a^(SIGMA-1)*varrho(+1)/varrho*lamNR(+1)/lamNR*(1-rho(+1))*sNRU(+1);
			sRU						= (1-tauL)*wn*h-ThetaR*kappa*wedH(-1)^(1-SIGMA)*h^(1+PHI)/(1+PHI)/lamR-ub+(1-s)*BETTA/a^(SIGMA-1)*varrho(+1)/varrho*lamR(+1)/lamR*(1-rho(+1))*sRU(+1);
			sNRU					= (1-tauL)*wn*h-ThetaNR*kappa*wedH(-1)^(1-SIGMA)*h^(1+PHI)/(1+PHI)/lamNR-ub+(1-s)*BETTA/a^(SIGMA-1)*varrho(+1)/varrho*lamNR(+1)/lamNR*(1-rho(+1))*sNRU(+1);
			pi*w					= VARKAPPA_W*gammaW(-1)*w(-1)/a(-1)*(1+tauC)/(1+tauC(-1))+(1-VARKAPPA_W)*pi*wn;
			gammaW					= a_ss^(1-ALPHA_W)*(a*wedH/wedH(-1))^ALPHA_W*pi_index^VARTHETA_W*pi_ss^(1-VARTHETA_W);
			psiU					= (1-OMEGA)*ThetaR/lamR+OMEGA*ThetaNR/lamNR;
		@#else
			mcW						= wedH(-1)*ThetaU*kappa*hd^PHI/lamU/(1-tauW)/w;
			hd 						= (1-ALPHA)*(w/mcZtil)^-1*yZtil;
			fW						= mcW*wtil^(-EPSILON_W*(1+PHI))*hd+BETTA/a^(SIGMA-1)*THETA_W*varrho(+1)/varrho*lamU(+1)/lamU*(gGamaW/pi(+1))^(-EPSILON_W*(1+PHI))*(wtil/wtil(+1))^(-EPSILON_W*(1+PHI))*(w/w(+1))^(-1-EPSILON_W*(1+PHI))*fW(+1);
			fW						= wtil^(1-EPSILON_W)*hd*(EPSILON_W-1)/EPSILON_W+BETTA/a^(SIGMA-1)*THETA_W*varrho(+1)/varrho*lamU(+1)/lamU*(1-tauW(+1))/(1-tauW)*(gGamaW/pi(+1))^(1-EPSILON_W)*(wtil/wtil(+1))^(1-EPSILON_W)*(w/w(+1))^-EPSILON_W*fW(+1);
			1						= (1-THETA_W)*wtil^(1-EPSILON_W)+THETA_W*(w(-1)/w*gGamaW(-1)/pi)^(1-EPSILON_W);
			gGamaW					= pi_index^VARTHETA_W*pibar^(1-VARTHETA_W);
			h						= hd*DelW;
			DelW					= (1-THETA_W)*wtil^-EPSILON_W+THETA_W*(w(-1)/w*gGamaW(-1)/pi)^-EPSILON_W*DelW(-1);
			lamU 					= OMEGA_U*lamNR+(1-OMEGA_U)*lamR;
			ThetaU					= OMEGA_U*ThetaNR+(1-OMEGA_U)*ThetaR;
		@#endif
			
		// E84 to E93 - Commodity Sector
			yCo						= zCo*(uCo*kCo(-1)/a(-1))^ALPHA_Co*(a*wedCo*L_BAR)^(1-ALPHA_Co);
			kCo						= (1-DELTA_Co)*kCo(-1)/a(-1)+(1-PHI_ICo/2*(a(@{-iCo_lags})*iACo(@{-iCo_lags+1})/iACo(@{-iCo_lags})-a_ss)^2)*iACo(@{-iCo_lags+1})*a
										@#for i in 0:iCo_lags-1
											/a(@{-i})
										@#endfor
										*varomegaCo(@{-iCo_lags+1});
			iCo 					= 
									@#for j in 0:iCo_lags-1
										+VARPHI_Co_@{j}*iACo(@{-j})*a
										@#for i in -(j):0
											/a(@{i})
										@#endfor
									@#endfor
									;
			phi_uCo					= rKCo_ss/PHI_UCo*(exp(PHI_UCo*(uCo-1))-1);
			iCof					= iCo+phi_uCo*kCo(-1)/a(-1);
			cfCo 					= rer*pCostar*yCo-pICo*iCof;
            lamCo                   = (1-tauCo*(1-CHI_CO))*rer*pCostar;
			qCo						= CHI_R_1*(lamCo(+1)*ALPHA_Co*a*yCo(+1)/kCo+qCo(+1)*(1-DELTA_Co)-pICo(+1)*phi_uCo(+1));
				#disc_inv_price		=
									@#for j in 0:iCo_lags-1
										+CHI_R_@{j}*VARPHI_Co_@{j}*pICo(@{j})
									@#endfor
									;			
			0 						= (disc_inv_price/CHI_R_@{iCo_lags-1}/qCo(@{iCo_lags-1}))-(1-PHI_ICo/2*(iACo/iACo(-1)*a(-1)-a_ss)^2-PHI_ICo*(a(-1)*iACo/iACo(-1)-a_ss)*iACo/iACo(-1)*a(-1))*varomegaCo-(CHI_R_@{iCo_lags}/CHI_R_@{iCo_lags-1}*qCo(@{iCo_lags})/qCo(@{iCo_lags-1})*PHI_ICo*(iACo(+1)/iACo*a-a_ss)*(iACo(+1)/iACo*a)^2*varomegaCo(+1));
			rKCo					= lamCo*ALPHA_Co*yCo/uCo/kCo(-1)*a(-1);
            uCo						= 1+(log(rKCo/rKCo_ss)-log(pICo))/PHI_UCo;
			
		// E94 to E116 - Fiscal Policy
			g						= pCG*cG+pIG*iG+trG+(rer*pOstar-pO)*o;
			t						= ALPHA_T*pY*y+(1-@{fiscal_rule})*VAREPSILON_T*(rer*bGstar_ss+bG_ss-rer*bGstar-bG);
            OMEGA*tNR               = OMEGA_G*t;
            (1-OMEGA)*tR            = (1-OMEGA_G)*t;
			tau						= tauC*c+tauW*w*n*h+tauK*(rK*ubar-pI*(DELTA+phi_ubar))*k(-1)/a(-1)+tauD*d+(1-CHI_CO)*tauCo*(cfCo+pICo*iCof)+t;
			bG+rer*bGstar			= R(-1)*bG(-1)/pi/a(-1)+Rstar(-1)*xi(-1)*rer*bGstar(-1)/pistar/a(-1)+tau+CHI_CO*cfCo-g;
			rer*bGstar				= ALPHA_D*(rer*bGstar+bG);
			gtil					= gtilRule^@{fiscal_rule}*gtilExo^(1-@{fiscal_rule});
			gtilExo					= g_ss*xiG;
			gtilRule				= (R(-1)-1)*bG(-1)/pi/a(-1)+(Rstar(-1)*xi(-1)-1)*rer*bGstar(-1)/a(-1)/pistar+tau-GAMMA_D*tau_cyc+CHI_CO*(cfCo-GAMMA_D*cfCo_cyc)-sb*pY*y+g_ss*log(xiG)*pY*y/(pY_ss*y_ss); //last term is useless if xiG is shut off
            tau_cyc      			= tau-tautil;
			tautil					= tauC*c_ss+tauW*w_ss*n_ss*h_ss+tauK*(rK_ss*ubar_ss-pI_ss*(DELTA+phi_ubar_ss))*k_ss/a_ss+tauD*d_ss+(1-CHI_CO)*tauCo*(cfCo_ss+pICo_ss*iCof_ss)+t_ss;
            cfCo_cyc     			= cfCo-cfCotil;
            cfCotil                 = rer*ptilCostar*yCo-pICo*iCof;
				#aux_PHI_pCostar    = (1-GAMMA_Costar)*(1-(1-GAMMA_Costar)^n_pCostar)/(n_pCostar*GAMMA_Costar);
				#aux_PHI_fstar      = (1-GAMMA_star)*(1-(1-GAMMA_star)^n_pCostar)/(n_pCostar*GAMMA_star)-aux_PHI_pCostar;
				#aux_PHI_piFstar    = ((1-GAMMA_star)*RHO_piFstar)/(1-GAMMA_star-RHO_piFstar)*(aux_PHI_pCostar+aux_PHI_fstar-RHO_piFstar*(1-RHO_piFstar^n_pCostar)/(n_pCostar*(1-RHO_piFstar)))-((1-GAMMA_Costar)*RHO_piFstar)/(1-GAMMA_Costar-RHO_piFstar)*(aux_PHI_pCostar-RHO_piFstar*(1-RHO_piFstar^n_pCostar)/(n_pCostar*(1-RHO_piFstar)));
				#aux_PHI_xiCostar   = RHO_xiCostar/(1-GAMMA_Costar-RHO_xiCostar)*(aux_PHI_pCostar-RHO_xiCostar*(1-RHO_xiCostar^n_pCostar)/(n_pCostar*(1-RHO_xiCostar)));
				#aux_PHI_xistar     = RHO_xistar/(1-GAMMA_star-RHO_xistar)*(aux_PHI_pCostar+aux_PHI_fstar-RHO_xistar*(1-RHO_xistar^n_pCostar)/(n_pCostar*(1-RHO_xistar)));
				#aux_PHI            = log(xistar_ss)/GAMMA_star*(aux_PHI_pCostar+aux_PHI_fstar-1)-log(xiCostar_ss)/GAMMA_Costar*(aux_PHI_pCostar-1);
			log(ptilCostar)    		= aux_PHI_pCostar*log(pCostar)+aux_PHI_fstar*log(fstar)+aux_PHI_piFstar*log(piFstar/piFstar_ss)+aux_PHI_xiCostar*log(xiCostar/xiCostar_ss)+aux_PHI_xistar*log(xistar/xistar_ss)+aux_PHI;
			pCG_ss*cG					= ALPHA_CG*gtil*xiCG;
			trG						= (1-ALPHA_CG-ALPHA_IG-trUFA_ss/g_ss)*gtil*xiTR+trUFA;
			OMEGA*trNR				= OMEGA_G*(trG-trUFA);
			(1-OMEGA)*trR			= (1-OMEGA_G)*(trG-trUFA);
			kG						= (1-DELTA_G)*kG(-1)/a(-1)+iAG(@{-iG_lags+1})*a
										@#for i in 0:iG_lags-1
											/a(@{-i})
										@#endfor
										;
			iG 						= 
									@#for j in 0:iG_lags-1
										+VARPHI_@{j}*iAG(@{-j})*a
										@#for i in -(j):0
											/a(@{i})
										@#endfor
									@#endfor
									;
				#gtil_mean			=	 
									@#for j in 0:iG_lags-1		  
										+VARPHI_@{j}*gtil(@{j})/a(-1)   
										@#for i in 0:j
											*a(@{i-1})
										@#endfor
									@#endfor	
									;
			pIG_ss*iAG				= ALPHA_IG*gtil_mean*xiIG;
			pO						= (pO_ss^(1-ALPHA_O)*pO(-1)^ALPHA_O)^RHO_O*(rer*pOstar)^(1-RHO_O)*xiO;
			
		// E117 to E120 - Monetary Policy
			R   					= R(-1)^RHO_R*(Rbar*(pitil/pibar)^ALPHA_PI*(yD/yD(-1))^ALPHA_Y)^(1-RHO_R)*eR;
            pitil                   = (piZ^ALPHA_PIz*pi^(1-ALPHA_PIz))^(1-ALPHA_PIE)*(piZ(+4)^ALPHA_PIz*pi(+4)^(1-ALPHA_PIz))^ALPHA_PIE;
            yD                      = y-xL-phi_ubar*k(-1)/a(-1)-phi_uCo*kCo(-1)/a(-1);
            piZ                     = pZ/pZ(-1)*pi;
			
		// E121 to E124 - Unemployment Funds Administrator
			@#if search
				bUFA				= tauUFA*w*n*h-(1-n)*ub+trUFA+R(-1)*bUFA(-1)/pi/a(-1);
				trUFA				= trUFAbar+VAREPSILON_UFA*(bUFA_ss-bUFA);
			@#else
				trUFA				= 0;
				bUFA				= 0;
			@#endif
				
		// E125 to E137 - Rest of the World
			rer/rer(-1)				= piS*pistar/pi;
			xHstar					= xHstar(-1)^RHO_XHstar*(OSTAR*(pHstar)^-ETASTAR*ystar)^(1-RHO_XHstar)*xiXHstar;
			ystar					= a*zstar;
			wedH					= (a_ss/a*wedH(-1))^(1-GAMMA_H);
			wedCo					= (a_ss/a*wedCo(-1))^(1-GAMMA_Co);
			piFstar					= fstar/fstar(-1)*pistar;
			1						= (pistar_ss/pistar)^(1-GAMMA_star)*fstar^GAMMA_star*xistar;
			pCostar					= (pistar_ss/pistar*pCostar(-1))^(1-GAMMA_Costar)*fstar^GAMMA_Costar*xiCostar;
			pOstar					= (pistar_ss/pistar*pOstar(-1))^(1-GAMMA_Ostar)*fstar^GAMMA_Ostar*xiOstar;
			pMstar					= (pistar_ss/pistar*pMstar(-1))^(1-GAMMA_Mstar)*fstar^GAMMA_Mstar*xiMstar;
			piCostar                = pCostar/pCostar(-1)*pistar;
            piOstar                 = pOstar/pOstar(-1)*pistar;
            piMstar                 = pMstar/pMstar(-1)*pistar;
            
		// E138 to E163 - Aggregation and Market Clearing
			c						= OMEGA*cNR+(1-OMEGA)*cR;
			k						= (1-OMEGA)*kR;
			kS						= (1-OMEGA)*kSR;
			i						= (1-OMEGA)*iR;
            bPr                     = (1-OMEGA)*bR;
			bPrstar					= (1-OMEGA)*bRstar;
            d                       = (1-OMEGA)*dR;
			yH                      = xH;
			xH						= xZH+xIH+xCoH+xCGH+xIGH+xAH+xL;
			yF                      = xF;
			yF						= xZF+xIF+xCoF+xCGF+xIGF+xAF;
			yHstar					= xHstar;
            @#if search
                xL					= hC*n+wedH(-1)*OMEGA_V*v;
			@#else
                xL						= 0;
            @#endif
			yHtil					= yH*DelH+yHstar*DelHstar;
			imp						= yF*DelF;
			DelH					= (1-THETA_H)*ptilH^-EPSILON_H+THETA_H*(pH(-1)/pH*gGamaH(-1)/pi*(1+tauC)/(1+tauC(-1)))^-EPSILON_H*DelH(-1);
			DelF					= (1-THETA_F)*ptilF^-EPSILON_F+THETA_F*(pF(-1)/pF*gGamaF(-1)/pi*(1+tauC)/(1+tauC(-1)))^-EPSILON_F*DelF(-1);
			DelHstar				= (1-THETA_Hstar)*ptilHstar^-EPSILON_Hstar+THETA_Hstar*(pHstar(-1)/pHstar*gGamaHstar(-1)/pistar)^-EPSILON_Hstar*DelHstar(-1);
			o						= oC+xO;
			yC						= c+pI*if+pICo*iCof+pCG*cG+pIG*iG+pH*xL;
			tb						= rer*pHstar*yHstar+rer*pCostar*yCo-rer*pMstar*imp-rer*pOstar*o;
			y						= c+if+iCof+cG+iG+xL+yHstar+yCo-imp-o;
			pY*y					= yC+tb;
			d						= pY*y-rer*pCostar*yCo-rK*kS+o*(rer*pOstar-pO)-w*n*h-pH*xL;
			rer*(bstar-bstar(-1)/a(-1)/pistar) = rer*bstar(-1)/a(-1)/pistar*(Rstar(-1)*xi(-1)-1)+tb+rer*renstar;
			renstar					= (1-OMEGA)*renRstar-(1-CHI_CO)*(cfCo-tauCo*(cfCo+pICo*iCof))/rer;
			renRstar				= renRstar_ss*xiREN;
			bPr+bG+bUFA				= 0;
						
	// Exogenous AR(1) processes -----------------------------------------------------------
	
		@#if search
			@#for x in state_vars_base + state_vars_search + ["tauCo","tauD","tauW","tauC","tauUFA"]
				@#if x == "rhox"
					rhox-rhox_ss=RHO_rhox*(rhox(-1)-rhox_ss)+eps_rhox/100;
				@#else
					log(@{x}/@{x}_ss)=RHO_@{x}*log(@{x}(-1)/@{x}_ss)+eps_@{x}/100;
				@#endif	
			@#endfor
		@#else
			@#for x in state_vars_base + ["tauCo","tauD","tauW","tauC","tauUFA"]
				log(@{x}/@{x}_ss)=RHO_@{x}*log(@{x}(-1)/@{x}_ss)+eps_@{x}/100;
			@#endfor
		@#endif
		
		tauK-tauK_ss=RHO_tauK*(tauK(-1)-tauK_ss) + eps_tauK  + eps_tauK2(-2) + eps_tauK6(-6) + eps_tauK10(-10) + eps_tauK14(-14);
		
	// Additional variable definitions -----------------------------------------------------

            aCo         	= wedCo/wedCo(-1)*a;
            aH          	= wedH/wedH(-1)*a;
			cPr				= OMEGA*cNR+(1-OMEGA)*cR;
            bGtot       	= bG+rer*bGstar;
            bGstar_tot  	= bGstar/bstar;
            bPrstar_tot  	= bPrstar/bstar;
            gam_C       	= cPr/cPr(-1)*a(-1);
            gam_CG      	= cG/cG(-1)*a(-1);
            gam_CNR     	= cNR/cNR(-1)*a(-1);
            gam_CR      	= cR/cR(-1)*a(-1);
            gam_BSTAR   	= bstar/bstar(-1)*a(-1);
            gam_BGSTAR  	= bGstar/bGstar(-1)*a(-1);
            gam_BPRSTAR  	= bPrstar/bPrstar(-1)*a(-1);
            gam_G       	= g/g(-1)*a(-1);
            gam_Gtil    	= gtil/gtil(-1)*a(-1);
            gam_I       	= itot/itot(-1)*a(-1);
            gam_IACo    	= iACo/iACo(-1)*a(-1);
            gam_IAG     	= iAG/iAG(-1)*a(-1);
            gam_ICo     	= iCo/iCo(-1)*a(-1);
            gam_IG      	= iG/iG(-1)*a(-1);
            gam_K       	= k/k(-1)*a(-1);
            gam_KCo     	= kCo/kCo(-1)*a(-1);
            gam_KG      	= kG/kG(-1)*a(-1);
            gam_M       	= imp/imp(-1)*a(-1);
            gam_O       	= o/o(-1)*a(-1);
            gam_OC      	= oC/oC(-1)*a(-1);
            gam_XO      	= xO/xO(-1)*a(-1);
            gam_TRG     	= trG/trG(-1)*a(-1);
            gam_W       	= w/w(-1)*a(-1);
			gam_WN      	= gam_W*pi;
            gam_XHstar  	= xHstar/xHstar(-1)*a(-1);
            gam_Y       	= yD/yD(-1)*a(-1);
			gam_YC      	= yC/yC(-1)*a(-1);
            gam_YCo     	= yCo/yCo(-1)*a(-1);
            gam_YF      	= yF/yF(-1)*a(-1);
            gam_YH      	= yH/yH(-1)*a(-1);
            gam_YHstar  	= yHstar/yHstar(-1)*a(-1);
            gam_YR      	= yDr/yDr(-1)*a(-1);
            gam_Ystar   	= ystar/ystar(-1)*a(-1);
            hn              = h*n;
			itot 			= i+iCo+iG;
            piA         	= pA/pA(-1)*pi*(1+tauC(-1))/(1+tauC);
            piH         	= pH/pH(-1)*pi*(1+tauC(-1))/(1+tauC);
            piHX        	= pHstar*rer/pHstar(-1)/rer(-1)*pi*(1+tauC(-1))/(1+tauC);
            piF         	= pF/pF(-1)*pi*(1+tauC(-1))/(1+tauC);
            piMtot      	= ((rer*pMstar*imp+rer*pOstar*o)/(imp+o))/((rer(-1)*pMstar(-1)*imp(-1)+rer(-1)*pOstar(-1)*o(-1))/(imp(-1)+o(-1)))*pi*(1+tauC(-1))/(1+tauC);
            piO         	= pO/pO(-1)*pi*(1+tauC(-1))/(1+tauC);
            Rbar        	= Rbar_ss*pibar/pibar_ss;
            sbstar      	= rer*bstar/(pY*y);
            stb         	= tb/(pY*y);
            yr 				= y-yCo;
			yDr         	= yD-yCo;
			
			gam4_Y 			= gam_Y *gam_Y(-1) *gam_Y(-2) *gam_Y(-3);
			gam4_YR 		= gam_YR*gam_YR(-1)*gam_YR(-2)*gam_YR(-3);
			
			pi4 			= pi * pi(-1) * pi(-2) * pi(-3);
			pi4_E1 			= pi4(+1);
			pi4_E2 			= pi4(+2);
			pi4_E4 			= pi4(+4);
			piZ4 			= piZ * piZ(-1) * piZ(-2) * piZ(-3);
			
			//pi4_meta 		=pi4(+8);

            
			@#if search
				job_cr		= (1-rho)*(m(-1)*v(-1)^(1-MU)*u(-1)^MU);
				job_des_endo= (1-rhox)*rhon*n(-1);
				job_des_exo	= rhox*n(-1);
				job_des_tot	= rho*n(-1);
			@#else
				gam_LAM     = lamU/lamU(-1)/a(-1);
			@#endif
			
	// Measurement equations ---------------------------------------------------------------
	
			cG_obs			= 100*log(cG/cG_ss);
			dR_obs 			= 100*(R-R(-1));
			e_tauK_obs		= 100*eps_tauK;
			e_tauK2_obs   	= 100*eps_tauK2;
			e_tauK6_obs   	= 100*eps_tauK6;
			e_tauK10_obs  	= 100*eps_tauK10;
			e_tauK14_obs  	= 100*eps_tauK14;
			gam_C_obs		= 100*log(gam_C/a_ss);
			gam_CG_obs		= 100*log(gam_CG/a_ss);
			gam_HN_obs		= 100*log(h/h(-1))+100*log(n/n(-1));
			gam_I_obs		= 100*log(gam_I/a_ss);
			gam_ICo_obs		= 100*log(gam_ICo/a_ss);
			gam_IG_obs		= 100*log(gam_IG/a_ss);
			gam_TRG_obs		= 100*log(gam_TRG/a_ss);
			gam_W_obs		= 100*log(gam_W/a_ss);
			gam_WN_obs		= 100*log(gam_WN/(a_ss*pi_ss));
			gam_Y_obs		= 100*log(gam_Y/a_ss);
			gam_YCo_obs		= 100*log(gam_YCo/a_ss);
            gam_YHstar_obs  = 100*log(gam_YHstar/a_ss);
			gam_YR_obs  	= 100*log(gam_YR/a_ss);
			gam_Ystar_obs	= 100*log(gam_Ystar/a_ss);
			pi_obs			= 100*log(pi/pi_ss);
			pCostar_obs		= 100*log(pCostar/pCostar_ss);
			piA_obs			= 100*log(piA/pi_ss);
			piCostar_obs	= 100*log(piCostar/pistar_ss);
			piO_obs			= 100*log(piO/pi_ss);
			piOstar_obs 	= 100*log(piOstar/pistar_ss);
			piM_obs     	= 100*log(piMtot/pi_ss);
			piMstar_obs 	= 100*log(piMtot/piS/pistar_ss);
			pistar_obs		= 100*log(pistar/pistar_ss);
			piS_obs			= 100*log(piS/piS_ss);
			piZ_obs     	= 100*log(piZ/pi_ss);
			pMstar_obs		= 100*log(pMstar/pMstar_ss);
			pOstar_obs		= 100*log(pOstar/pOstar_ss);
			rer_obs			= 100*log(rer/rer_ss);
			R_obs			= 100*log(R/Rbar);
			Rstar_obs		= 100*log(Rstar/Rstar_ss);
			stb_obs			= 100*(stb-stb_ss);
			xi_obs			= 100*(log(xi/xi_ss)-(zetau-zetau_ss)/zetau_ss);
			yCo_obs			= 100*log(yCo/yCo_ss);
			ystar_obs		= 100*log(ystar/ystar_ss);

			h_obs           = 100*log(h/h_ss);
			n_obs           = 100*log(n/n_ss);
            hn_obs          = 100*log(h/h_ss)+100*log(n/n_ss);

			gam_N_obs	= 100*log(n/n(-1));
			gam_H_obs	= 100*log(h/h(-1));

	end;

////////////////////////////////////////////////////////////////////////////////////////////	
// 3. Steady state ------------------------------------------------------------------------/
////////////////////////////////////////////////////////////////////////////////////////////

@#if search
	Guess 	=	{ ...
				'kG_ss'                5.00;
				'rKtil_ss'             0.01;
				'kS_ss'               25.00;
				'utCo_ss' 			   0.01;
				'yHstarVA_ss'          0.01;
				'xO_ss'                0.05;
				'oC_ss'                0.10;
				'hC_ss'                0.001;
				};
@#else
	Guess 	=	{ ...
				'kG_ss'                5.00;
				'rKtil_ss'             0.01;
				'kS_ss'               25.00;
				'utCo_ss' 			   0.01;
				'yHstarVA_ss'          0.01;
				'xO_ss'                0.05;
				'oC_ss'                0.10;
				};
@#endif


			
  	@#if generate_ss_file==1
		copyscript(M_,@{ss_algo},Guess)  				
	@#endif       
	
//save guess_parameters Guess
	
	steady; 
	/* check; */
	
////////////////////////////////////////////////////////////////////////////////////////////
// 4. Estimation and Simulation -----------------------------------------------------------/
////////////////////////////////////////////////////////////////////////////////////////////

	// Define observed variables -----------------------------------------------------------
	
@#include "estim_obs_XMAS_dtbc.inc"


	estimated_params;
	
@#include "estim_priors_XMAS_dtbc.inc"


		
	end;

	// Estimation commands -----------------------------------------------------------------


@#include "estim_commands_XMAS_dtbc.inc"		


