%get variable
clear
close all

load XMAS_results

var_names={...
           'piZ_obs',       'Core Inflation (anual)',               4;
           'gam_YR_obs',    'Non mining GDP growth (anual)',        4;
           'R_obs',         'Nominal Interest Rate',                0.25;
           'gam_HN_obs',     'employment rate change(anual)',        4}

 for nn=1:4      
       
namevar1=var_names{nn,1}


var1=oo_.SmoothedVariables.(namevar1)
rec_forecast=oo_.RecursiveForecast.Mean.(namevar1)'

nobs=numel(var1);
nfor=size(rec_forecast,1);%%length of forecasts
nrec=size(rec_forecast,2);%% number of recursive forecasts


all_series=NaN(nobs+nfor,1+nrec);
all_series(1:numel(var1),1)=var1;

for ii=1:size(rec_forecast,2)
    inipos=nobs-nrec+ii+1;
    endpos=inipos+nfor-1;
   all_series(inipos:endpos,ii+1)= rec_forecast(:,ii);
   %all_series(inipos-1,ii+1)= var1(inipos-1);
   all_series(1:inipos-1,ii+1)= var1(1:inipos-1);
   %error_1(ii,1)=rec_forecast(1,ii)-all_series(inipos,1);
   %error_2(ii,1)=rec_forecast(2,ii)-all_series(inipos+1,1);
   for jj=1:nfor
    error_sq(ii,jj)=(rec_forecast(jj,ii)-all_series(inipos+jj-1,1))^2;
   end
   
end
error_sq

for ii=1:nfor
MSE1(ii)=nanmean(error_sq(:,ii));
end
MSE.(var_names{nn,1})=MSE1;



all_series4=all_series(1:nobs+nfor-3,:)+all_series(2:nobs+nfor-2,:)+all_series(3:nobs+nfor-1,:)+all_series(4:nobs+nfor,:);

if var_names{nn,3}==0.25
   all_series4=4* all_series;
end
% all_series4=cumsum(all_series(:,:),1);
% all_series4=-(all_series4-nanmean(all_series4(:,1)));
if nn==1
figure
end
subplot(2,2,nn)

for ii=1:nrec+1
    if ii==1
plot(all_series4(:,ii),'Color','b')
hold on
    else
        plot(all_series4(:,ii),'Color','r')
        hold on
    end
    
end
plot(all_series4(:,1),'Color','b')
hold off
title(var_names{nn,2})

 end
        
