////////////////////////////////////////////////////////////////////////////////////////////
// 0. Housekeeping and options ------------------------------------------------------------/ 
////////////////////////////////////////////////////////////////////////////////////////////

close all;
clc;

@#include "options_MAS_proxy.inc"


////////////////////////////////////////////////////////////////////////////////////////////
// 1. Preamble ----------------------------------------------------------------------------/ 
////////////////////////////////////////////////////////////////////////////////////////////

	// Endogenous variables ----------------------------------------------------------------

		@#define endo_vars      = [ "c"				,\\
									"cZ"			,\\
									"cO"			,\\
									"cA"			,\\
									"cR"			,\\
									"cNR"			,\\
									"lamR"			,\\
									"lamNR"			,\\
									"lamU"			,\\
									"i"				,\\
									"iCo"			,\\
									"if"			,\\
									"iCof"			,\\
									"k"				,\\
									"kCo"			,\\
									"kS"			,\\
									"u"				,\\
									"uCo"			,\\
									"phi_u"			,\\
									"phi_uCo"		,\\
									"q"				,\\
									"qCo"			,\\
									"rK"			,\\
									"rKCo"			,\\
                                    "b"				,\\
									"d"				,\\
									"dstar"			,\\
									"dstarG"		,\\
									"h"				,\\
									"hd"			,\\
									"w"				,\\
									"wtil"			,\\
									"ptilH"			,\\
									"ptilHstar"		,\\
									"ptilF"			,\\
									"mcW"			,\\
									"mcH"			,\\
									"mcHstar"		,\\
									"mcF"			,\\
									"fW"			,\\
									"fH"			,\\
									"fHstar"		,\\
									"fF"			,\\
									"gGamaW"		,\\
									"gGamaH"		,\\
									"gGamaHstar"	,\\
									"gGamaF"		,\\
									"DelW"			,\\
									"DelH"			,\\
									"DelHstar"		,\\
									"DelF"			,\\
									"pZ"			,\\
									"pO"			,\\
									"pA"			,\\
									"pG"			,\\
									"pI"			,\\
									"pICo"			,\\
									"pCostar"		,\\
									"pH"			,\\
									"pHtil"			,\\  
									"pHstar"        ,\\
									"pF"			,\\ 
									"pi"			,\\
									"piZ"			,\\
									"piS"			,\\
									"pitil"			,\\
									"pistar"	    ,\\
									"fstar"         ,\\
									"pMstar"		,\\
									"piMtot"		,\\
									"pOstar"		,\\
									"pY"			,\\
									"R"				,\\
									"g"				,\\
									"t"				,\\
									"tau"			,\\	
									"tb"			,\\
                                    "m"             ,\\
									"o"				,\\
									"cfCo"			,\\
									"renstar"		,\\
									"renRstar"		,\\
									"rer"			,\\								
									"wedCo"			,\\
									"wedH"			,\\
									"xH"            ,\\
									"xF"            ,\\
									"xZH"			,\\
									"xZF"			,\\
									"xAH"			,\\
									"xAF"			,\\
									"xIH"			,\\
									"xIF"			,\\
									"xCoH"			,\\
									"xCoF"			,\\
									"xGH"			,\\
									"xGF"			,\\
									"xHstar"		,\\
 									"xZ"            ,\\
									"xO"			,\\
									"xi"			,\\
									"y"				,\\
									"yC"			,\\
									"yCo"			,\\
									"yH"			,\\
									"yHtil"			,\\
									"yHstar"		,\\
									"yZ"            ,\\
									"yF"			,\\
									"imp"			,\\
									"ystar"			]

    // Exogenous AR(1) state variables -----------------------------------------------------	
						 
		@#define exo_state_vars = [ "varrho"        ,\\
									"kappa"         ,\\
                                    "a"             ,\\ 
									"z"         	,\\
									"zA"        	,\\
									"zCo"       	,\\
									"varomega"      ,\\
									"varomegaCo"    ,\\
                                    "varomegaCo2"   ,\\
									"cG"            ,\\
									"zetao"     	,\\
									"zetau"     	,\\
									"Rstar"         ,\\
									"piFstar"       ,\\
									"xistar"        ,\\
									"xiCostar"      ,\\
									"xiMstar"       ,\\
									"xiOstar"       ,\\
									"xiO"           ,\\
									"xiREN"         ,\\
									"xiXHstar"      ,\\
									"zstar"         ,\\
									"eR"            ]
	
    // Auxiliary variable definitions ------------------------------------------------------

		@#define def_vars       = [ "gam_C"         ,\\
                                    "gam_CG"        ,\\
                                    "gam_I"         ,\\
                                    "gam_ICo"       ,\\
                                    "gam_Y"     	,\\
                                    "gam_YCo"       ,\\
                                    "gam_YR"     	,\\
                                    "gam_Ystar"     ,\\
                                    "gam_W"         ,\\
                                    "piA"           ,\\
                                    "piO"           ,\\
                                    "piCostar"      ,\\
                                    "piMstar"       ,\\
                                    "piOstar"       ,\\
                                    "stb"           ,\\
                                    "sdstar"        ]
		
    // Observable variable definitions -----------------------------------------------------	

		@#define obs_vars       = [ "gam_C_obs"         ,\\
                                    "gam_CG_obs"        ,\\
                                    "gam_I_obs"         ,\\
                                    "gam_ICo_obs"       ,\\
                                    "gam_Y_obs"     	,\\
                                    "gam_YCo_obs"       ,\\
                                    "gam_YR_obs"     	,\\
                                    "gam_Ystar_obs"     ,\\
                                    "gam_W_obs"         ,\\
									"gam_WN_obs"        ,\\
									"gam_HN_obs"		,\\
                                    "pi_obs"            ,\\
                                    "piZ_obs"           ,\\
                                    "piA_obs"           ,\\
                                    "piO_obs"           ,\\
                                    "piCostar_obs"      ,\\
                                    "piMstar_obs"       ,\\
                                    "piOstar_obs"       ,\\
                                    "pistar_obs"        ,\\
                                    "R_obs"             ,\\
                                    "Rstar_obs"         ,\\
                                    "rer_obs"           ,\\
                                    "stb_obs"           ,\\
                                    "xi_obs"            ,\\
									"piM_obs"			,\\
                                    "piS_obs"]

    // Declare variables -------------------------------------------------------------------	

		@#for vars in endo_vars+exo_state_vars+def_vars+obs_vars
			var @{vars};
		@#endfor	
		
		@#for vars in exo_state_vars
			varexo eps_@{vars};
		@#endfor

	// Define parameters -------------------------------------------------------------------

        // Deep parameters
			parameters BETTA SIGMA VARSIGMA PHI PSI; 
            parameters OMEGA OMEGA_U OMEGA_G;
            parameters ALPHA ALPHA_Co; 
            parameters DELTA DELTA_Co;
            parameters PHI_I PHI_ICo;
            parameters PHI_U PHI_UCo;
            parameters EPSILON_W EPSILON_H EPSILON_Hstar EPSILON_F;
            parameters THETA_W THETA_H THETA_Hstar THETA_F;
            parameters VARTHETA_W VARTHETA_H VARTHETA_Hstar VARTHETA_F;
            parameters KAPPA_O KAPPA_A;
            parameters O_Z O_G;
            parameters ALPHA_O;
            parameters ETA_C ETA_Z ETA_G ETA_O;
		@#if diff_final_goods
			parameters O_A O_I O_Co;
            parameters ETA_A ETA_I ETA_Co;
		@#endif	
            parameters OSTAR ETASTAR RHO_XHstar;
            parameters L_BAR CHI_Co;
			parameters GAMMA_H GAMMA_Co;
			parameters GAMMA_Mstar GAMMA_Costar GAMMA_Ostar GAMMA_star;
            parameters RHO_R ALPHA_PI ALPHA_Y ALPHA_PIz ALPHA_PIE pibar;
			parameters ALPHA_T EPSILON_T ALPHA_D sDEF_ss;
            parameters TAU_C TAU_K TAU_W TAU_D TAU_Co;
			parameters RHO_O sCO_ss;
            parameters sYCo_ss pYy_ss scG_ss pCo_ss sca_ss siCo_ss sKCo_ss;
            parameters DifFinalGoods OilProd OilShareExo yHstarVA_ss utCo_ss;
            parameters ZERO;

		// Steady state parameters
		@#for vars in endo_vars+exo_state_vars+def_vars+obs_vars
			parameters @{vars}_ss;
		@#endfor
		
		// Parameters of exogenous AR(1) state variables
		@#for vars in exo_state_vars
			parameters RHO_@{vars} SIG_@{vars};
		@#endfor				
	
	// Options used as parameters ----------------------------------------------------------
		
			LogUt 			= @{log_utility};
			DifFinalGoods	= @{diff_final_goods};	
			NonRic			= @{non_ricardian};
			NomFricHom		= @{nom_fric_hom};
			NomFricExp		= @{nom_fric_exp};
			NomFricImp		= @{nom_fric_imp};
			NomFricWag		= @{nom_fric_wag};
			TvIt 			= @{tv_it};
			OilCons 		= @{oil_cons};
			OilProd 		= @{oil_prod};
			OilShareExo 	= @{oil_share_exo};
			MEPCO 			= @{oil_mepco};
			DebtDol			= @{debt_dol};
			AgricCons		= @{agric_cons};
			VarCapUtil		= @{var_cap_util};
			VarCapUtilCommo	= @{var_cap_util_commo};
			EndoCommo		= @{endo_commo};
			CointProd		= @{coint_prod};
            CointPrice		= @{coint_price};			
	
	// Parameter values	(value is overridden if parameter is included in the estimation section) --------------------------------------------------- 
				
	@#include "param_values_MAS_proxy.inc"	

		// Steady state values of observables		
        @#for x in obs_vars
            @{x}_ss=0;
        @#endfor
		
////////////////////////////////////////////////////////////////////////////////////////////
// 2. Model -------------------------------------------------------------------------------/
////////////////////////////////////////////////////////////////////////////////////////////

	model; 

	// Aux vars ---------------------------------------------------------------------------- 	
					
		// Home bias different sectors
        @#if diff_final_goods==0
            #O_G=O_Z;
            #O_A=O_Z;	
			#O_I=O_Z;	
            #O_Co=O_Z;
			#ETA_G=ETA_Z;
            #ETA_A=ETA_Z;
			#ETA_I=ETA_Z;
            #ETA_Co=ETA_Z;
        @#endif			

	// Equilibrium conditions -------------------------------------------------------------- 

		// E1 to E12 - Households
            kS=u*k(-1)/a(-1);	
            phi_u=rK_ss/PHI_U*(exp(PHI_U*(u-1))-1);
            k=(1-DELTA)*k(-1)/a(-1)+(1-PHI_I/2*(i/i(-1)*a(-1)-a_ss)^2)*varomega*i;
        	(1+TAU_C)*lamR=(cR-VARSIGMA*cR(-1)/a(-1))^-SIGMA;
            lamR=BETTA/a^SIGMA*R*varrho(+1)/varrho*lamR(+1)/pi(+1);	
            lamR=BETTA/a^SIGMA*Rstar*xi*varrho(+1)/varrho*piS(+1)*lamR(+1)/pi(+1);	
            q=BETTA/a^SIGMA*varrho(+1)/varrho*lamR(+1)/lamR*(rK(+1)*u(+1)*(1-TAU_K)+q(+1)*(1-DELTA)+pI(+1)*(TAU_K*DELTA-phi_u(+1)*(1-TAU_K)));
            pI/q=(1-PHI_I/2*(i/i(-1)*a(-1)-a_ss)^2-PHI_I*(i/i(-1)*a(-1)-a_ss)*i/i(-1)*a(-1))*varomega+BETTA/a^SIGMA*varrho(+1)/varrho*lamR(+1)/lamR*q(+1)/q*PHI_I*(i(+1)/i*a-a_ss)*(i(+1)/i*a)^2*varomega(+1);	
            u=1+(log(rK/rK_ss)-log(pI))/PHI_U;
            xi=xi_ss*exp(PSI*(rer*dstar/pY/y-rer_ss*dstar_ss/pY_ss/y_ss)+(zetao-zetao_ss)/zetao_ss+(zetau-zetau_ss)/zetau_ss);
            (1+TAU_C)*lamNR=(cNR-VARSIGMA*cNR(-1)/a(-1))^-SIGMA;
            (1+TAU_C)*cNR=(1-TAU_W)*w*hd-OMEGA_G/OMEGA*t;
        // E13 to E18 - Labor Market
           	lamU=OMEGA_U*lamNR+(1-OMEGA_U)*lamR; 
            fW=wtil^(-EPSILON_W)*hd*mcW+BETTA/a^(SIGMA-1)*THETA_W*varrho(+1)/varrho*lamU(+1)/lamU*(gGamaW/a/pi(+1))^-EPSILON_W*(wtil/wtil(+1))^-EPSILON_W*(w/w(+1))^(-1-EPSILON_W)*fW(+1);
			fW=wtil^(1-EPSILON_W)*hd*(EPSILON_W-1)/ EPSILON_W+BETTA/a^(SIGMA-1)*THETA_W*varrho(+1)/ varrho*lamU(+1)/ lamU*(gGamaW/a/pi(+1))^(1-EPSILON_W)*(wtil/wtil(+1))^(1-EPSILON_W)*(w/w(+1))^-EPSILON_W*fW(+1);
			1=(1-THETA_W)*wtil^(1-EPSILON_W)+THETA_W*(w(-1)/w*gGamaW(-1)/a(-1)/pi)^(1-EPSILON_W);
            mcW=kappa*wedH(-1)^(1-SIGMA)*h^PHI/lamU/(1-TAU_W)/w;
			gGamaW=a_ss*pi^VARTHETA_W*pi_ss^(1-VARTHETA_W);
        // E19 to E39 - Final Goods
            c=((1-KAPPA_O-KAPPA_A)^(1/ETA_C)*cZ^((ETA_C-1)/ETA_C)+KAPPA_O^(1/ETA_C)*cO^((ETA_C-1)/ETA_C)+KAPPA_A^(1/ETA_C)*cA^((ETA_C-1)/ETA_C))^(ETA_C/(ETA_C-1));
            cZ=(1-KAPPA_O-KAPPA_A)*pZ^-ETA_C*c;
            cO=KAPPA_O*pO^-ETA_C*c;
            cA=KAPPA_A*pA^-ETA_C*c;
            cZ=((1-O_Z)^(1/ETA_Z)*xZH^((ETA_Z-1)/ETA_Z)+O_Z^(1/ETA_Z)*xZF^((ETA_Z-1)/ETA_Z))^(ETA_Z/(ETA_Z-1));
            xZH=(1-O_Z)*(pH/pZ)^-ETA_Z*cZ;
            xZF=O_Z*(pF/pZ)^-ETA_Z*cZ;
            cA=zA*((1-O_A)^(1/ETA_A)*xAH^((ETA_A-1)/ETA_A)+O_A^(1/ETA_A)*xAF^((ETA_A-1)/ETA_A))^(ETA_A/(ETA_A-1));
            xAH=zA^(ETA_A-1)*(1-O_A)*(pH/pA)^-ETA_A*cA;
            xAF=zA^(ETA_A-1)*O_A*(pF/pA)^-ETA_A*cA;
			cG=((1-O_G)^(1/ETA_G)*xGH^((ETA_G-1)/ETA_G)+O_G^(1/ETA_G)*xGF^((ETA_G-1)/ETA_G))^(ETA_G/(ETA_G-1));	
            xGH=(1-O_G)*(pH/pG)^-ETA_G*cG;
			xGF=O_G*(pF/pG)^-ETA_G*cG;            
			if=((1-O_I)^(1/ETA_I)*xIH^((ETA_I-1)/ETA_I)+O_I^(1/ETA_I)*xIF^((ETA_I-1)/ETA_I))^(ETA_I/(ETA_I-1));	
            xIH=(1-O_I)*(pH/pI)^-ETA_I*if;	  
			xIF=O_I*(pF/pI)^-ETA_I*if;             
			iCof=((1-O_Co)^(1/ETA_Co)*xCoH^((ETA_Co-1)/ETA_Co)+O_Co^(1/ETA_Co)*xCoF^((ETA_Co-1)/ETA_Co))^(ETA_Co/(ETA_Co-1));	
            xCoH=(1-O_Co)*(pH/pICo)^-ETA_Co*iCof;
			xCoF=O_Co*(pF/pICo)^-ETA_Co*iCof;
			if=i+phi_u*k(-1)/a(-1);
			iCof=iCo+phi_uCo*kCo(-1)/a(-1); 
	    // E40 to E54 - Differentiated Varieties
            fH=ptilH^-EPSILON_H*yH*mcH+BETTA*THETA_H/a^(SIGMA-1)*varrho(+1)/varrho*lamR(+1)/lamR*(gGamaH/pi(+1))^-EPSILON_H*(ptilH/ptilH(+1))^-EPSILON_H*(pH/pH(+1))^(-1-EPSILON_H)*fH(+1);
            fH=ptilH^(1-EPSILON_H)*yH*(EPSILON_H-1)/EPSILON_H+BETTA/a^(SIGMA-1)*THETA_H*varrho(+1)/varrho*lamR(+1)/lamR*(gGamaH/pi(+1))^(1-EPSILON_H)*(ptilH/ptilH(+1))^(1-EPSILON_H)*(pH/pH(+1))^-EPSILON_H*fH(+1);
            1=(1-THETA_H)*ptilH^(1-EPSILON_H)+THETA_H*(pH(-1)/pH*gGamaH(-1)/pi)^(1-EPSILON_H);
            pH*mcH=pHtil;
            gGamaH=pi^VARTHETA_H*pi_ss^(1-VARTHETA_H);
            fF=ptilF^-EPSILON_F*yF*mcF+BETTA/a^(SIGMA-1)*THETA_F*varrho(+1)/varrho*lamR(+1)/lamR*(gGamaF/pi(+1))^-EPSILON_F*(ptilF/ptilF(+1))^-EPSILON_F*(pF/pF(+1))^(-1-EPSILON_F)*fF(+1); 			
            fF=ptilF^(1-EPSILON_F)*yF*(EPSILON_F-1)/EPSILON_F+BETTA/a^(SIGMA-1)*THETA_F*varrho(+1)/varrho*(lamR(+1)/lamR*(gGamaF/pi(+1))^(1-EPSILON_F)*(ptilF/ptilF(+1))^(1-EPSILON_F)*(pF/pF(+1))^-EPSILON_F*fF(+1));
            1=(1-THETA_F)*ptilF^(1-EPSILON_F)+THETA_F*(pF(-1)/pF*gGamaF(-1)/pi)^(1-EPSILON_F);
            pF*mcF=pMstar*rer;
            gGamaF=pi^VARTHETA_F*pi_ss^(1-VARTHETA_F);
  			fHstar=ptilHstar^-EPSILON_Hstar*yHstar*mcHstar+BETTA*THETA_Hstar/a^(SIGMA-1)*varrho(+1)/varrho*lamR(+1)/lamR*rer(+1)/rer*(gGamaHstar/pi(+1))^-EPSILON_Hstar*(ptilHstar/ptilHstar(+1))^-EPSILON_Hstar*(pHstar/pHstar(+1))^(-1-EPSILON_Hstar)*fHstar(+1); 	          
			fHstar=ptilHstar^(1-EPSILON_Hstar)*yHstar*(EPSILON_Hstar-1)/EPSILON_Hstar+BETTA/a^(SIGMA-1)*THETA_Hstar*varrho(+1)/varrho*lamR(+1)/lamR*rer(+1)/rer*(gGamaHstar/pi(+1))^(1-EPSILON_Hstar)*(ptilHstar/ptilHstar(+1))^(1-EPSILON_Hstar)*(pHstar/pHstar(+1))^-EPSILON_Hstar*fHstar(+1);
			1=(1-THETA_Hstar)*ptilHstar^(1-EPSILON_Hstar)+THETA_Hstar*(pHstar(-1)/pHstar*gGamaHstar(-1)/pi)^(1-EPSILON_Hstar);
            pHstar*mcHstar=pHtil/rer;
            gGamaHstar=pistar^VARTHETA_Hstar*pistar_ss^(1-VARTHETA_Hstar);
        // E55 to E60 - Wholesale Goods
            yHtil=z*((1-ALPHA_O)^(1/ETA_O)*xZ^((ETA_O-1)/ETA_O)+ALPHA_O^(1/ETA_O)*xO^((ETA_O-1)/ETA_O))^(ETA_O/(ETA_O-1));
            pO=pHtil*(ALPHA_O*yHtil/(z^(1-ETA_O)*xO))^(1/ETA_O);
            yZ=kS^ALPHA*(a*wedH*hd)^(1-ALPHA);
            yZ=xZ;
            w=pHtil*(1-ALPHA)*xZ/hd*((1-ALPHA_O)*yHtil/(z^(1-ETA_O)*xZ))^(1/ETA_O);
            rK=pHtil*ALPHA*xZ/kS*((1-ALPHA_O)*yHtil/(z^(1-ETA_O)*xZ))^(1/ETA_O);	
        // E61 to E68 - Commodities         
			yCo=zCo*(uCo*kCo(-1)/a(-1))^ALPHA_Co*(a*wedCo*L_BAR)^(1-ALPHA_Co);
            kCo=(1-DELTA_Co)*kCo(-1)/a(-1)+(1-PHI_ICo/2*(iCo/iCo(-1)*a(-1)-a_ss)^2)*varomegaCo*varomegaCo2*iCo;	
            phi_uCo=rKCo_ss/PHI_UCo*(exp(PHI_UCo*(uCo-1))-1);            
            cfCo=rer*pCostar*yCo-pICo*iCof;
			rKCo=(1-TAU_Co*(1-CHI_Co))*rer*pCostar*ALPHA_Co*yCo/uCo/kCo(-1)*a(-1);
            uCo=1+(log(rKCo/rKCo_ss)-log(pICo))/PHI_UCo;
            qCo=BETTA/a^SIGMA*varrho(+1)/varrho*lamR(+1)/lamR*((1-TAU_Co*(1-CHI_Co))*rer(+1)*pCostar(+1)*ALPHA_Co*yCo(+1)/kCo*a+qCo(+1)*(1-DELTA_Co));		    
            pICo/qCo=(1-PHI_ICo/2*(iCo/iCo(-1)*a(-1)-a_ss)^2-PHI_ICo*(iCo/iCo(-1)*a(-1)-a_ss)*iCo/iCo(-1)*a(-1))*varomegaCo*varomegaCo2+BETTA/a^SIGMA*PHI_ICo*varrho(+1)/varrho*qCo(+1)/qCo*lamR(+1)/lamR*(iCo(+1)/iCo*a-a_ss)*(iCo(+1)/iCo*a)^2*varomegaCo(+1)*varomegaCo2(+1);
		// E69 to E74 - Fiscal Policy
			g=pG*cG+(rer*pOstar-pO)*o;
			tau=TAU_C*c+TAU_W*w*hd+TAU_K*(rK*u-pI*(DELTA+phi_u))*k(-1)/a(-1)+TAU_D*d+TAU_Co*(1-CHI_Co)*(cfCo+pICo*iCof)+t;
            t=ALPHA_T*y*pY+EPSILON_T*(b+rer*dstarG-b_ss-rer*dstarG_ss);
			b+rer*dstarG=g+R(-1)*b(-1)/a(-1)/pi+rer*Rstar(-1)*xi(-1)*dstarG(-1)/a(-1)/pistar-tau-CHI_Co*cfCo;
            rer*dstarG=ALPHA_D*(b+rer*dstarG);
            pO=(pO(-1))^RHO_O*(rer*pOstar)^(1-RHO_O)*xiO;
		// E75 to E77 - Monetary Policy	
            R/R_ss=(R(-1)/R_ss)^RHO_R*((pitil/pibar)^ALPHA_PI*(y/y(-1))^ALPHA_Y)^(1-RHO_R)*eR;	
            pitil=(piZ^ALPHA_PIz*pi^(1-ALPHA_PIz))^(1-ALPHA_PIE)*(piZ(+4)^ALPHA_PIz*pi(+4)^(1-ALPHA_PIz))^ALPHA_PIE;
            piZ=pZ/pZ(-1)*pi;
     	// E78 to E87 - Rest of the World
            rer/rer(-1)=piS*pistar/pi;
			xHstar=xHstar(-1)^RHO_XHstar*(OSTAR*pHstar^-ETASTAR*ystar)^(1-RHO_XHstar)*xiXHstar;
            ystar=a*zstar;
			wedH=(a_ss/a*wedH(-1))^(1-GAMMA_H);			
			wedCo=(a_ss/a*wedCo(-1))^(1-GAMMA_Co);	
            piFstar=fstar/fstar(-1)*pistar;
            1=(pistar_ss/pistar)^(1-GAMMA_star)*fstar^GAMMA_star*xistar;
            pCostar=(pistar_ss/pistar*pCostar(-1))^(1-GAMMA_Costar)*fstar^GAMMA_Costar*xiCostar;
			pOstar=(pistar_ss/pistar*pOstar(-1))^(1-GAMMA_Ostar)*fstar^GAMMA_Ostar*xiOstar;
            pMstar=(pistar_ss/pistar*pMstar(-1))^(1-GAMMA_Mstar)*fstar^GAMMA_Mstar*xiMstar;
        // E88 to E109 - Aggregation and Market Clearing
            c=OMEGA*cNR+(1-OMEGA)*cR;
            yH=xH;
            xH=xZH+xAH+xGH+xIH+xCoH;
            yF=xF;
            xF=xZF+xAF+xGF+xIF+xCoF;
            yHstar=xHstar;
            o=cO+xO;
            h=hd*DelW;
            DelW=(1-THETA_W)*wtil^-EPSILON_W+THETA_W*(w(-1)/w/a(-1)*gGamaW(-1)/pi)^-EPSILON_W*DelW(-1);
            yHtil=yH*DelH+yHstar*DelHstar;
            m=yF*DelF;
            DelH=(1-THETA_H)*ptilH^-EPSILON_H+THETA_H*(pH(-1)/pH*gGamaH(-1)/pi)^-EPSILON_H*DelH(-1);
            DelF=(1-THETA_F)*ptilF^-EPSILON_F+THETA_F*(pF(-1)/pF*gGamaF(-1)/pi)^-EPSILON_F*DelF(-1);
            DelHstar=(1-THETA_Hstar)*ptilHstar^-EPSILON_Hstar+THETA_Hstar*(pHstar(-1)/pHstar*gGamaHstar(-1)/pi)^-EPSILON_Hstar*DelHstar(-1);
            yC=c+pG*cG+pI*if+pICo*iCof;
            tb=rer*(pHstar*yHstar+pCostar*yCo-pMstar*m-pOstar*o);
            y=c+cG+if+iCof+yHstar+yCo-m-o;
            pY*y=yC+tb;
            d=pY*y-rer*pCostar*yCo-(pO-rer*pOstar)*o-rK*kS-w*hd;
            rer*(dstar-dstar(-1)/a(-1)/pistar)=rer*dstar(-1)/a(-1)/pistar*(Rstar(-1)*xi(-1)-1)-tb-rer*renstar;
            renstar=(1-OMEGA)*renRstar-(1-CHI_Co)*(cfCo-TAU_Co*(cfCo+pICo*iCof))/rer;
            renRstar=xiREN;

	// Exogenous AR(1) processes ----------------------------------------------------------- 

        @#for x in exo_state_vars
            @#if x == "kappa"
                log(kappa/kappa_ss)=RHO_kappa*log(kappa(-1)/kappa_ss)+10*eps_kappa;
            @#else
                log(@{x}/@{x}_ss)=RHO_@{x}*log(@{x}(-1)/@{x}_ss)+eps_@{x};
            @#endif	
        @#endfor
  
	// Additional variable definitions ------------------------------------------------------	

            gam_C       = c/c(-1)*a(-1); 	
            gam_CG      = cG/cG(-1)*a(-1);
            gam_I       = (i+iCo)/(i(-1)+iCo(-1))*a(-1); 
            gam_ICo     = iCo/iCo(-1)*a(-1);
            gam_W       = w/w(-1)*a(-1);   
            gam_Y       = y/y(-1)*a(-1);
            gam_YCo     = yCo/yCo(-1)*a(-1);
			gam_YR      = (y-yCo)/(y(-1)-yCo(-1))*a(-1);
            gam_Ystar   = ystar/ystar(-1)*a(-1);
            piA         = pA/pA(-1)*pi;
            piCostar    = pCostar/pCostar(-1)*pistar;
            piMstar     = pMstar/pMstar(-1)*pistar;
            piO         = pO/pO(-1)*pi;
            piOstar     = pOstar/pOstar(-1)*pistar;
            sdstar      = rer*dstar/(pY*y); 
            stb         = tb/(pY*y);
			imp						= yF*DelF;
			piMtot      	= ((rer*pMstar*imp+rer*pOstar*o)/(imp+o))/((rer(-1)*pMstar(-1)*imp(-1)+rer(-1)*pOstar(-1)*o(-1))/(imp(-1)+o(-1)))*pi;

	// Measurement equations ----------------------------------------------------------------

			gam_C_obs       = 100*log(gam_C/a_ss); 
			gam_CG_obs      = 100*log(gam_CG/a_ss); 					
			gam_I_obs       = 100*log(gam_I/a_ss); 		
			gam_ICo_obs     = 100*log(gam_ICo/a_ss); 			
			gam_W_obs       = 100*log(gam_W/a_ss); 
			gam_WN_obs		= 100*log(gam_W*pi/(a_ss*pi_ss));
			gam_HN_obs 		= 100*log(h/h(-1));
			gam_Y_obs       = 100*log(gam_Y/a_ss);
			gam_YCo_obs     = 100*log(gam_YCo/a_ss); 
			gam_YR_obs      = 100*log(gam_YR/a_ss);
			gam_Ystar_obs   = 100*log(gam_Ystar/a_ss);
			pi_obs          = 100*log(pi/pi_ss);
			piA_obs         = 100*log(piA/pi_ss);
			piCostar_obs    = 100*log(piCostar/pistar_ss);	
			piMstar_obs 	= 100*log(piMtot/piS/pistar_ss);	
			piO_obs         = 100*log(piO/pi_ss);	
			piOstar_obs     = 100*log(piOstar/pistar_ss);
			pistar_obs      = 100*log(pistar/pistar_ss); 
			piZ_obs         = 100*log(piZ/pi_ss);
			R_obs           = 100*log(R/R_ss); 	
			Rstar_obs       = 100*log(Rstar/Rstar_ss); 		
			rer_obs         = 100*log(rer/rer_ss);		
            stb_obs         = 100*(stb-stb_ss); 
			xi_obs          = 100*(log(xi/xi_ss)-(zetau-zetau_ss)/zetau_ss);
            piS_obs         = 100*log(piS/piS_ss);
			piM_obs     	= 100*log(piMtot/pi_ss);
	end;

////////////////////////////////////////////////////////////////////////////////////////////	
// 3. Steady state ------------------------------------------------------------------------/
////////////////////////////////////////////////////////////////////////////////////////////
	


Guess 	= 	{ ...
             'kS_ss'                30.0;
             'yHstarVA_ss'          0.01;
			 'utCo_ss' 				0.01;
             'xO_ss'                0.01;
             'cO_ss'                0.05;
            };
			 
  	@#if generate_ss_file==1
		copyscript(M_,@{ss_algo},Guess)  				
	@#endif       
	
//save guess_parameters Guess
	
	steady; 
	/* check; */
	
////////////////////////////////////////////////////////////////////////////////////////////
// 4. Estimation and Simulation -----------------------------------------------------------/
////////////////////////////////////////////////////////////////////////////////////////////
 
	// Define observed variables -----------------------------------------------------------

		@#include "estim_obs_MAS_proxy.inc"	

	estimated_params;
	
		@#include "estim_priors_MAS_proxy.inc"	
	
	end;		

	// Estimation commands ----------------------------------------------------------------- 

@#include "estim_commands_MAS_proxy.inc"
	
