clc 
clearvars -except do_


paths.local             =   cd;
paths.results           =   [paths.local '\replic_aux_codes\results\'];
paths.model_variations  =   [paths.local '\replic_aux_codes\model_variations\'];
paths.models            = { [paths.local '\models\GarciaGuardaKirchnerTranamil_2019\XMAS\']
                            [paths.local '\models\GarciaGuardaKirchnerTranamil_2019\MAS_proxy\']
                            [paths.local '\models\GarciaGuerra_2020\']};
           
addpath([paths.local '\replic_aux_codes'])

                        %%name          Long Name                   options     params      e_prior     e_obs    e_command       
    model_base =    {   'base'          'Shock Autocorrelacionado'  0           0         	0           0        0       }
    
    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_base;
    
    solve_models(models,paths);

    %%doing_plots_a -> same shock, different models
    %%doing_plots_b -> same model, different shocks
    %%doing_plots_c -> different shocks and models
    
%% FIG 3.3.2.2    
    

                        %%name          Long Name                       options     params      e_prior     e_obs	e_command 
    model_spec =    {
                        'rhoM_0'        'Shock Sin Autocorrelacion'      0           1         	1           0       0
                        }
    
    paths.model         	= paths.models{1};
    models.modfile          = 'XMAS_dtbc';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results)  
        model_names={};
        model_names{2,1} = ['results_' model_base{1,1}];
        model_names{2,2} = model_base{1,2};   
  
        model_names{1,1} = ['results_' model_spec{1,1}];
        model_names{1,2} = model_spec{1,2};


 
        %           Name            Latex name          shock scale     long_name
    Impulse     =   {	        
                    'eR'         ,'e^R'             , 1/0.3881          ,'Figure 3.3.2.2(BCCh_2020): Monetary Policy Shock';   
                    };

        %                Name           Latex Name                  Cusum	Factor	Div_ss
    Response    = {     'gam4_Y'        ,' $ Crec. anual PIB $ ' 	,0   	,1    	,0;
                        'pi4'           ,' $ Inflacion anual $ '  	,0  	,1   	,0;
                        'R'             ,' $ TPM $ '                ,0      ,4    	,0;
                         };

    plot_options.n_col	= 2;
    plot_options.n_row	= 2;

    doing_plots_a(model_names,Impulse, Response, plot_options)  


%%

cd(paths.local)
