
// Calibrated parameters --------------------------------------------------------------- 
		
			ZERO            = 10^-5;                // "small" number to avoid dividing by 0
		
		// Utility function parameters
			SIGMA           = 1*LogUt+2*(1-LogUt);	// utility Function Parameter
			PHI             = 1;           			// unitary Frisch elasticity (Adolfson et al., 2008)
			
		// Depreciation rates	
			DELTA           = 0.01;				    // annual depreciation rate (Adolfson et al., 2008)

		// Domestic/foreign shares		
		@#if diff_final_goods		
			O_Z             = 1-0.79;		// home bias in domestic demand, 2008-2016 
			O_I             = 1-0.67;    	// home bias in domestic investment, 2008-2016
			O_Co            = 1-0.59;    	// home bias in domestic investment in the Co sector (Fornero & Kirchner, 2016)  
			O_G             = ZERO;  		// assumption (Garca-Cicco et al., 2015)
		@#else	
			O_Z             = 1-0.67;		// home bias in consumption goods (imports/dom demand), 2001-2016
		@#endif	
			O_A             = O_Z;          // home bias in Aggricultural goods
		
		//Substitution elasticities (irrelevant)			
			ETA_G           = 0.5;          // home/foreign substitution elasticity in government consumption 		 	
											
		// Nominal price rigidities
			EPSILON_H       = 11+ZERO^-1*(1-NomFricHom);	// 10% ss price markup (Medina & Soto, 2007) 
			EPSILON_F       = 11+ZERO^-1*(1-NomFricImp);	// 10% ss price markup (Medina & Soto, 2007) 
			EPSILON_W       = 11+ZERO^-1*(1-NomFricWag);	// 10% ss wage markup (Medina & Soto, 2007)
			EPSILON_Hstar   = 11+ZERO^-1*(1-NomFricExp);	// 10% ss price markup (Medina & Soto, 2007)
				
		// Input shares
			ALPHA           = 1-0.66;                   	// labor share of 66% (Medina and Soto, 2007)
			KAPPA_A         = 0.19*AgricCons+ZERO;      	// share food in final Consumption basket (Ponderador IPC base 2013)
			ALPHA_O         = OilProd*0.01+ZERO;         	// share oil in domestic technology	(Medina & Soto, 2007)
					
		// Ricardians and non-Ricardians
			OMEGA           = 0.5*NonRic+ZERO;				// share of non-Ricardian households                               
			OMEGA_U         = OMEGA;						// union's weight of non-Ricardians welfare                         
			OMEGA_G         = OMEGA;						// share of total lump-sum taxes given to non-Ricardian households 
		
		//Monetary Policy
			pibar           = 1.03^.25;     // central bank inflation target since 2001
            ALPHA_PIE       = 0;// 0.5;          // central bank weight on inflation expectations

		//Fiscal Policy		
			TAU_C           = 0.19;                                 // tax on consumption (IVA efectivo desde 2014)
			TAU_K           = 0.20;                                 // tax on capital income (impuestos a las empresas desde 2011)
			TAU_W           = 0.07;                                 // tax on labor income (impuestos al ingreso laboral ponderada por percentil de ingreso desde 2013)
			TAU_D           = 0.20;                                 // tax on profit income (impuestos a las empresas desde 2011)
			TAU_Co          = 0.35;                                 // tax on foreign companies (Fornero & Kirchner 2016)
			ALPHA_D         = (1-ZERO)*DebtDol+ZERO*(1-DebtDol);	// currency denomination of gov. debt (assumption) 		
			EPSILON_T       = 0.001;                                // small number

		// Shares of GDP
			sca_ss          = -(0.35*0+0.5)/100; 		// current account / GDP, 2001-2016 (adjusted so that sdstar_ss=~0.54 -> NFA/GDP=0.14, avergage 2003-2016)                                     
			stb_ss          = 0.05;						// average share of trade balance / GDP, 2001-2016         
			scG_ss          = 0.12;  					// average share of government consumption / GDP, 2001-2016 
			sGtotal_ss      = scG_ss;                   // share of total government spending
			sYCo_ss          = 0.12;         			// average share of commodity sector / GDP, 2001-2016 
			siCo_ss         = 0.04*EndoCommo+ZERO;     	// average share of commodity investment / GDP, 2001-2016
			sKCo_ss      	= 12;     					// average ratio of commodity capital / commodity GDP of 12 (Fornero & Kirchner, 2016)
			sCO_ss          = 0.06*OilCons+ZERO;		// share oil consumption (Ponderador IPC base 2013)
			CHI_Co          = 0.33;						// Codelco production / total commodity production, 2001-2015
			sDEF_ss 		= ZERO;
		//Other
			a_ss            = (1+(0.033-0.0181))^.25;   // long-term growth (3.3% tendencia - 1.81% fuerza de trabajo)
			BETTA           = 0.99997;           		// quarterly subjective discount factor (real rate around 1.5%)
            //Rstar_ss      = ((1+0.03)*(1+0.02))^.25;  // quarterly foreign nominal rate (3% meta BCCH, 2% tasa neutral externa (Fuentes and Gredig, 2008))
			piS_ss          = 1.000^0.25;               // calibrated
            xi_ss           = 1.015^.25;       			// EMBI Chile, 2001-2016
	
	// Estimated parameters ----------------------------------------------------------------
	
		// Elasticities		
			ETA_Z           = 0.4648;    // home/Foreign in consumption goods       
			ETA_I           = 0.4632;    // home/Foreign in private investment goods    
			ETA_Co          = 0.4632;    // home/Foreign in commodity investment goods   
            ETA_A           = 0.4603;	 // home/Foreign in aggricultural goods 
			ETASTAR         = 0.1922;    // home/Foreign in foreign demand (MAS estimation, 2016)  
			ETA_O           = 0.3664;	 // core/oil in domestic production
			ETA_C           = 0.3179;    // core/oil/agric in private consumption (MAS estimation, 2016)
			
		// Nominal Rigidities		
			THETA_W         = 0.8802*NomFricWag+ZERO;  
			THETA_H         = 0.7438*NomFricHom+ZERO;  
			THETA_Hstar     = 0.3290*NomFricExp+ZERO;  
			THETA_F         = 0.6232*NomFricImp+ZERO;  

			VARTHETA_W 		= 0.2931; 
			VARTHETA_H 		= 0.1099; 
			VARTHETA_Hstar 	= 0.3577; 	
			VARTHETA_F 		= 0.3933; 	
			
			RHO_O          = 0.6902*MEPCO+ZERO;	// Poil smothness parameter
			
		// Taylor Rule				
			RHO_R           = 0.8061;		// Taylor persistence parameter (MAS estimation, 2016)          
			ALPHA_PI        = 1.7599;		// Taylor response to inflation (MAS estimation, 2016)              
			ALPHA_PIz       = 0;// 0.4437;		// Taylor response to core inflation (MAS estimation, 2016)        
			ALPHA_Y         = 0.1130;		// Taylor response to output (MAS estimation, 2016)                
		
		// Cointegrated Processes
			GAMMA_Co        = 0.7810*CointProd+(1-ZERO)*(1-CointProd);
			GAMMA_H         = 0.7841*CointProd+(1-ZERO)*(1-CointProd);
			
		// Other
			VARSIGMA        = 0.8273;
			PSI             = 0.0028;			
			PHI_I           = 1.5831;
			PHI_ICo         = 0.1189+1000*(1-EndoCommo);
			PHI_U           = 0.8742+ZERO^-1*(1-VarCapUtil);	
			PHI_UCo         = 0.8742+ZERO^-1*(1-VarCapUtilCommo);
			RHO_XHstar      = 0;
		
	// Normalizations ----------------------------------------------------------------------

			h_ss            = 0.3;		
            L_BAR           = 1;
			varrho_ss       = 1;					 
			z_ss            = 1;	
			zCo_ss          = 1;
			zstar_ss        = 1;
			zA_ss           = 1;
			varomega_ss     = 1;
			varomegaCo_ss   = 1;
            varomegaCo2_ss  = 1;					 	 
			zetao_ss        = 1;						 
			zetau_ss        = 1;						 
			eR_ss           = 1;
			pH_ss           = 1;
			pCo_ss          = 1;						 
			pO_ss           = 1;							
			xiO_ss          = 1;
			xiREN_ss        = 1;
			xistar_ss       = 1;
			xiMstar_ss      = 1;
			xiXHstar_ss     = 1;

	// Exogenous processes -----------------------------------------------------------------	
	
		// Calibrated or estimated by Bayesian methods
        @#for x in exo_state_vars
            RHO_@{x}        = 0;
            SIG_@{x}        = ZERO;
        @#endfor

		// Estimated by MLE			
            RHO_piFstar     = 0.4181;  
            RHO_xistar      = 0*CointPrice+0*(1-CointPrice);
            RHO_xiMstar     = 0*CointPrice+0*(1-CointPrice);	
            RHO_xiCostar    = 0.9588;	
            RHO_xiOstar 	= 0.9143;   
            RHO_Rstar		= 0.9676;
                
            SIG_piFstar     = 0.0259;   
            SIG_xistar      = ZERO*CointPrice+ZERO*(1-CointPrice);			
            SIG_xiMstar 	= ZERO*CointPrice+ZERO*(1-CointPrice);				
            SIG_xiCostar 	= 0.1221;   
            SIG_xiOstar 	= 0.1425;	
            SIG_Rstar		= 0.0010;   

            GAMMA_Costar 	= 0.8148*CointPrice+(1-ZERO)*(1-CointPrice);
            GAMMA_Ostar  	= 0.9719*CointPrice+(1-ZERO)*(1-CointPrice);			
            GAMMA_Mstar 	= 0.8279*CointPrice+(1-ZERO)*(1-CointPrice);              
			GAMMA_star      = (1-ZERO)*CointPrice+(1-ZERO)*(1-CointPrice);

