function []=copyscript(M_,solve_method,Guess)



if solve_method==0 
    steady_name_old='steady_state_iterative_a.m';
    disp('ss algorithm "a" : optimized for simulations and debugging')
elseif solve_method==1 
    steady_name_old='steady_state_iterative_b.m';
    disp('ss algorithm "b" : optimized for model estimation')
else
    error('ERROR: unknown method for computing steady state')
end


	steady_name_new=[M_.fname '_steadystate.m'];
	copyfile(steady_name_old,steady_name_new) ;

  obs_vars={};  
    
    
for ii=1:M_.orig_endo_nbr
        deblank_name=deblank(M_.endo_names{ii,:});
        if strcmp(deblank_name(max(1,end-2):end),'obs')
            idx1=numel(obs_vars)+1;
            obs_vars{idx1}=deblank_name;
        end
end

    N_obs=length(obs_vars);
    for j=1:N_obs     
        obs_loc.(obs_vars{j}) = loc(M_.endo_names,obs_vars{j});
    end        
  
    fileID = fopen('obs_locations.m','w');
    for j=1:numel(obs_vars) 
        fwrite(fileID,['obs_loc.' obs_vars{j} '='  num2str(obs_loc.(obs_vars{j})) ';' newline ]);
    end
    fclose(fileID);       
        
        
        
    
     for ii=1:M_.orig_endo_nbr
        loc_ss(ii,1)=loc(M_.param_names,[deblank(M_.endo_names{ii,:}) '_ss']);
     end
     
    guess_vars=Guess(:,1)';
    initial_guess=cell2mat(Guess(:,2))';

    N_guess=length(guess_vars);
    for j=1:N_guess      
        guess_loc.(guess_vars{j}) = loc(M_.param_names,guess_vars{j});
    end
     
    fileID = fopen('guess_locations.m','w');
    fwrite(fileID,'loc_ss=[');
    for j=1:numel(loc_ss)   
        fwrite(fileID,[' ' num2str(loc_ss(j))]);
    end
    fwrite(fileID,['];' newline ]);
    for j=1:numel(guess_vars) 
        fwrite(fileID,['guess_loc.' guess_vars{j} '='  num2str(guess_loc.(guess_vars{j})) ';']);
    end
    fclose(fileID);

%% write 'guess_variables.m'
    fileID = fopen('guess_variables.m','w');
    fwrite(fileID,'Guess ={');
    for j=1:numel(guess_vars)   
        fwrite(fileID,['''' guess_vars{j} '''' ',' num2str(initial_guess(j),20) ';' newline ]);
    end
    fwrite(fileID,'};');
    fclose(fileID);

    %% copy steady state equations with name steady_state_equations2
    SteadyEqs_name_old=['steady_state_equations.m'];
    SteadyEqs_name_new=['steady_state_equations2.m'];
    copyfile(SteadyEqs_name_old,SteadyEqs_name_new) ;
   
    numel_M=size(M_.param_names,1);
    numel_Guess=size(Guess,1);
    
    %% for estimation algorithm replace names with location of variables in M_
    
    if solve_method==1
        
        for ii=1:numel_M
            find_and_replace('steady_state_equations2.m', ['\<' deblank(M_.param_names{ii,:}) '\>'], ['M_.params(' num2str(ii) ')' ])
        end
        
        for ii=1:numel_Guess
            find_and_replace('steady_state_equations2.m', ['\<' Guess{ii,1} '\>'], ['guess_params.' Guess{ii,1}])
        end
        
        for ii=1:numel_Guess
            find_and_replace('steady_state_equations2.m', ['\<' [Guess{ii,1} '_upd'] '\>'], ['upd(' num2str(ii) ')'])
        end
        
    end
%%
end

%%

function find_and_replace(file, expression, replacement)

% find_and_replace(file, to_find, to_replace)
% 
% Replaces a string (expression) in a given file (file) with a new string 
% (replacement).
%
% See regexprep for info on valid 'expression' and 'replace' inputs.
%
% Examples:
%
% Replace all instances of the string 'abs', including 'cabs', with 'mag':
%
% find_and_replace('my_file.m', 'abs', 'mag');
%
% Replace all the exact variable names 'my_var' with 'my_other_var'. This
% *won't* match 'my_var_2' or 'this_is_my_var'.
%
% find_and_replace('my_file.m', '\<my_var\>', 'my_other_var');
%
% Replace all calls to sqrt(...) with my_sqrt(...), keeping the function's 
% argument (this is using regular expressions).
%
% find_and_replace(tc.file_name, 'sqrt\((.*?)\)', 'my_sqrt\($1\)');
%
% Note that the above does *not* work for nested parentheses (regular
% expressions can't match nested parentheses to an arbitrary depth).
%
% This function can also handle multiple files, where the first input is
% either a cell array of file names (e.g., {'file1.txt', 'file2.m'}) or a
% struct with a 'name' field that contains the file name, such as is output
% from files = dir('*.m');
%
% For example, to replace in all .m files in the current directory:
%
% find_and_replace(dir('*.m'), 'string_1', 'string_2');
%
% See doc regexprep for more examples.
%
% Tucker McClure
% Copyright 2013, The MathWorks, Inc.

    % If user passed in a single file name, wrap it as a cell.
    if ischar(file)
        file = {file};
    elseif isstruct(file) && any(strcmp(fieldnames(file), 'name'))
        file = {file(:).name};
    elseif ~iscell(file);
        error('find_and_replace:invalid_inputs', ...
              'Unknown input type for ''file''.');
    end

    % For all files in the cell array...
    for k = 1:length(file)
        
        % Make sure the file exists.
        if ~exist(file{k}, 'file')
            error('find_and_replace:no_file', ...
                  ['File doesn''t exist. To replace strings in text, ' ...
                   'use regexprep.']);
        end

        % Read in the file as binary and convert to chars.
        fid = fopen(file{k});
        text = fread(fid, inf, '*char')';
        fclose(fid);

        % Find and replace.
        text = regexprep(text, expression, replacement);

        % Write out the new file.
        fid = fopen(file{k}, 'w');
        fwrite(fid, text);
        fclose(fid);
        
    end

end


