clc 
clearvars -except do_


paths.local             =   cd;
paths.results           =   [paths.local '\replic_aux_codes\results\'];
paths.model_variations  =   [paths.local '\replic_aux_codes\model_variations\'];
paths.models            = { [paths.local '\models\GarciaGuardaKirchnerTranamil_2019\XMAS\']
                            [paths.local '\models\GarciaGuardaKirchnerTranamil_2019\MAS_proxy\']
                            [paths.local '\models\GarciaGuerra_2020\']};
           
addpath([paths.local '\replic_aux_codes'])

                        %%name          Long Name                       options     params      e_prior     e_obs    e_command       
    model_base =    {   'Xmas_mig'      'Baseline '                     0           0         	0           0        0       }
    
    paths.model         	= paths.models{3};
    models.modfile          = 'XMAS_mig';
    models.specifications   = model_base;
    
    solve_models(models,paths);

    %%doing_plots_a -> same shock, different models
    %%doing_plots_b -> same model, different shocks
    %%doing_plots_c -> different shocks and models
    
%% FIG 5    
    
if do_.fig_GG_2020(5) 
                        %%name          Long Name                       options     params      e_prior     e_obs	e_command 
    model_spec =    { }
    
    paths.model         	= paths.models{3};
    models.modfile          = 'XMAS_mig';
    models.specifications   = model_spec;
    
    solve_models(models,paths);

    %%% load and plot
    
        cd(paths.results)  
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

 
        %           Name            Latex name          shock scale     long_name
    Impulse     =   {	        
                    'muL1'      ,'\mu L'          , 100           ,'Figure 5(GG_2020): Baseline Effects of an immigration shock';   
                    };

        %         	Name      	Latex Name      Cusum       Factor	 Div_ss
    Response    = { 'gam_YR'  	,'YR'           ,1          ,1       ,0;
                    'gam_C'   	,'C'            ,1          ,1       ,0;        
                    'gam_I'  	,'I'            ,1          ,1       ,0;
                    'piZ'    	,'4\pi Z'     	,0          ,4       ,0;
                    'L'      	,'L'         	,0          ,1       ,1;
                    'urate'    	,'u'            ,0          ,1       ,0;
                    'theta'     ,'\theta'       ,0          ,1       ,1;
                    'h'        	,'h'            ,0          ,1       ,1;   
                    'rer'     	,'rer'          ,0          ,1       ,1;
                    'gam_WN'   	,'WN'          	,1          ,1       ,0;              
                    'R'        	,'4R'           ,0          ,4       ,1;             
                    };

    plot_options.n_col	= 4;
    plot_options.n_row	= 3;

    doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 6    
    
if do_.fig_GG_2020(6) 
                    %%name         Long Name                       options     params      e_prior     e_obs   e_command
    model_spec =    {
                 	'mig_labsup'      'Stronger labor supply effect'	0          	1       	0           0       0
                 	}

    paths.model         	= paths.models{3};
    models.modfile          = 'XMAS_mig';
    models.specifications   = model_spec;
    
    solve_models(models,paths);
    
    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

        %           Name            Latex name   	shock scale     long_name
    Impulse     =   {	        
                    'muL1'      ,'\mu L'          , 100           ,'Figure 6(GG_2020): An Immigration Shock with Stronger Labor Supply Effects';   
                    };

        %           Name    	Latex Name                              Cusum	Factor	Div_ss
    Response    = { 'gam_YR'  	,'YR'           ,1          ,1       ,0;
                    'gam_C'   	,'C'            ,1          ,1       ,0;        
                    'gam_I'  	,'I'            ,1          ,1       ,0;
                    'piZ'    	,'4\pi Z'     	,0          ,4       ,0;
                    'L'      	,'L'         	,0          ,1       ,1;
                    'urate'    	,'u'            ,0          ,1       ,0;
                    'kappa_mig' ' \kappa ^M '  	,0          ,1/12.75 ,0;
                    'h'        	,'h'            ,0          ,1       ,1;   
                    'rer'     	,'rer'          ,0          ,1       ,1;
                    'gam_WN'   	,'WN'          	,1          ,1       ,0;              
                    'R'        	,'4R'           ,0          ,4       ,1;             
                    };

    plot_options.n_col	= 4;
    plot_options.n_row	= 3;

    doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 7

if do_.fig_GG_2020(7) 
                    %%name          Long Name    	  options     params      e_prior     e_obs   e_command 
  model_spec =    {
                 	'mig_remit'     'Remmitances'      0          	1       	0           0       0
                 	}

    paths.model         	= paths.models{3};
    models.modfile          = 'XMAS_mig';
    models.specifications   = model_spec;
    
    solve_models(models,paths);
    
    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

        %           Name            Latex name   	shock scale     long_name
    Impulse     =   {	        
                    'muL1'      ,'\mu L'          , 100           ,'Figure 7(GG_2020): Allowing for Remmitances';   
                    };

        %           Name    	Latex Name                              Cusum	Factor	Div_ss
    Response    = { 'gam_YR'  	,'YR'           ,1          ,1       ,0;
                    'gam_C'   	,'C'            ,1          ,1       ,0;        
                    'gam_I'  	,'I'            ,1          ,1       ,0;
                    'piZ'    	,'4\pi Z'     	,0          ,4       ,0;
                    'L'      	,'L'         	,0          ,1       ,1;
                    'urate'    	,'u'            ,0          ,1       ,0;
                    'theta'     ,'\theta'       ,0          ,1       ,1;
                    'h'        	,'h'            ,0          ,1       ,1;   
                    'rer'     	,'rer'          ,0          ,1       ,1;
                    'gam_WN'   	,'WN'          	,1          ,1       ,0;              
                    'R'        	,'4R'           ,0          ,4       ,1;             
                    };

    plot_options.n_col	= 4;
    plot_options.n_row	= 3;

    doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 8

if do_.fig_GG_2020(8) 
                    %%name          Long Name    	  options     params      e_prior     e_obs   e_command 
  model_spec =    {
                 	'mig_alp'     'Productivity effect'      1          	0       	0           0       0
                 	}

    paths.model         	= paths.models{3};
    models.modfile          = 'XMAS_mig';
    models.specifications   = model_spec;
    
    solve_models(models,paths);
    
    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

        %           Name            Latex name   	shock scale     long_name
    Impulse     =   {	        
                    'muL1'      ,'\mu L'          , 100           ,'Figure 8(GG_2020): Immigrant Underemployment: Lower Average Labor Productivity';   
                    };

        %           Name    	Latex Name                              Cusum	Factor	Div_ss
    Response    = { 'gam_YR'  	,'YR'           ,1          ,1       ,0;
                    'gam_C'   	,'C'            ,1          ,1       ,0;        
                    'gam_I'  	,'I'            ,1          ,1       ,0;
                    'piZ'    	,'4\pi Z'     	,0          ,4       ,0;
                    'L'      	,'L'         	,0          ,1       ,1;
                    'urate'    	,'u'            ,0          ,1       ,0;
                    'alp_mig' 	,' z^M '        ,0          ,1       ,1;
                    'h'        	,'h'            ,0          ,1       ,1;   
                    'rer'     	,'rer'          ,0          ,1       ,1;
                    'gam_WN'   	,'WN'          	,1          ,1       ,0;              
                    'R'        	,'4R'           ,0          ,4       ,1;             
                    };

    plot_options.n_col	= 4;
    plot_options.n_row	= 3;

    doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%% FIG 9

if do_.fig_GG_2020(9) 
                    %%name          Long Name    	  options     params      e_prior     e_obs   e_command 
  model_spec =    {
                 	'mig_all'     'All features included'      1          	1       	0           0       0
                 	}

    paths.model         	= paths.models{3};
    models.modfile          = 'XMAS_mig';
    models.specifications   = model_spec;
    
    solve_models(models,paths);
    
    %%% load and plot
    
        cd(paths.results) 
        model_names={};
        model_names{1,1} = ['results_' model_base{1,1}];
        model_names{1,2} = model_base{1,2};   
    for m_nmbr=1:size(model_spec,1)   
        model_names{m_nmbr+1,1} = ['results_' model_spec{m_nmbr,1}];
        model_names{m_nmbr+1,2} = model_spec{m_nmbr,2};
    end

        %           Name            Latex name   	shock scale     long_name
    Impulse     =   {	        
                    'muL1'      ,'\mu L'          , 100           ,'Figure 9(GG_2020): Dynamic Effects of an Immigration Shock';   
                    };

        %           Name    	Latex Name                              Cusum	Factor	Div_ss
    Response    = { 'gam_YR'  	,'YR'           ,1          ,1       ,0;
                    'gam_C'   	,'C'            ,1          ,1       ,0;        
                    'gam_I'  	,'I'            ,1          ,1       ,0;
                    'piZ'    	,'4\pi Z'     	,0          ,4       ,0;
                    'L'      	,'L'         	,0          ,1       ,1;
                    'urate'    	,'u'            ,0          ,1       ,0;
                    'theta'     ,'\theta'       ,0          ,1       ,1;
                    'h'        	,'h'            ,0          ,1       ,1;   
                    'rer'     	,'rer'          ,0          ,1       ,1;
                    'gam_WN'   	,'WN'          	,1          ,1       ,0;              
                    'R'        	,'4R'           ,0          ,4       ,1;             
                    };

    plot_options.n_col	= 4;
    plot_options.n_row	= 3;

    doing_plots_a(model_names,Impulse, Response, plot_options)  

end

%%

cd(paths.local)