% poner en carpeta ...\NKSOE_extensions\metropolis de cada modelo.

clear;
close all;

%         param_names   position   latex_names
input = {'PHI_I'        ,'24'      ,'\phi_I';
         'VARTHETA_W'   ,'32'      ,'\vartheta_W';
         'RHO_zetao'    ,'48'      ,'\rho_{\zeta^O}';
         'RHO_PO'       ,'39'      ,'\rho_{PO}'
         'RHO_PO'       ,'39'      ,'\rho_{PO}'
         'RHO_PO'       ,'39'      ,'\rho_{PO}'};

plot_raws   = 3;
plot_column = 2;

for i=1:length(input(:,1))
    param_name     = input{i,1};
    param_position = input{i,2};
    j=1;
    MH_Draws = ['NKSOE_extensions_mh' num2str(j) '_blck1.mat'];
    eval([param_name '=[];'])
    
    while exist(MH_Draws,'file')==2
        load(MH_Draws)
        eval([param_name '= [' param_name '; x2(:,' param_position ')];']);
        j=j+1;
        MH_Draws = ['NKSOE_extensions_mh' num2str(j) '_blck1.mat'];
    end
    plot_y = eval(param_name);
    num_draws = length(plot_y);
    
    plot_y_init = plot_y(1);
    plot_y_mean = mean(plot_y);
    
    subplot(plot_raws,plot_column,i);
    plot(plot_y)
    hold on
    hline1 = refline([0 plot_y_init]);
    hline1.Color = 'r';
    hline2 = refline([0 plot_y_mean]);
    hline2.Color = 'g';
    hold off
    %ylabel('parameter values')
    xlim([1 num_draws])
    title(['parameter ' input{i,3}])
end
hL = legend('Param value in each draw','Mode (init point)',...
    ['MH mean for ' num2str(num_draws) ' draws'],...
    'Orientation','horizontal');
newPosition = [0.447048612554659 0.0171998425943974...
    0.130381943000894 0.022703817877361];
set(hL,'Position',newPosition,'Units','normalized','FontSize',12);



