// Calibrated parameters ---------------------------------------------------------------
	
			ZERO			= 10^-5;						// "small" number to avoid dividing by 0
		
		// Utility Function Parameters
			SIGMA			= 1*LogUt+2*(1-LogUt);			// Utility Function Parameter
			PHI             = 1;           					// unitary Frisch elasticity (Adolfson et al., 2008)
						
		// Depreciation rates	
			DELTA			= 0.01;				    		// annual depreciation rate (Adolfson et al., 2008)
			DELTA_G			= DELTA;						// annual depreciation rate of public capital
		
		// Domestic/Foreign Shares		
		@#if diff_final_goods		
			O_Z  			= 1-0.79;						// home bias in domestic demand, 2008-2016 
			O_I  			= 1-0.67;    					// home bias in domestic investment, 2008-2016 
			O_CG 			= ZERO;  						// Normalization (García-Cicco et al., 2015)
			O_IG 			= ZERO;  						// Normalization (Coenen et al 2013)
			O_Co			= 1-0.59;    					// home bias in domestic investment in the Co sector (Fornero & Kirchner 2016) 
		@#else	
			O_Z 			= 1-0.67;						// home bias in consumption goods (imports/dom demand), 2001-2016
		@#endif	
			O_A 			= O_Z;							// home bias in Aggricultural goods
		
		// Elasticities	(irrelevant)			
			ETA_CG 			= 0.5; 							// Home/Foreign in Government Goods 		
			ETA_IG 			= 0.5;							// Home/Foreign in Public Investment Goods 	
									
		// Nominal Price Rigidities
			EPSILON_H	  	= 11+ZERO^-1*(1-NomFricHom);	// 10% ss price markup (Medina and Soto, 2007) 
			EPSILON_F	  	= 11+ZERO^-1*(1-NomFricImp);	// 10% ss price markup (Medina and Soto, 2007) 
			EPSILON_W	  	= 11+ZERO^-1*(1-NomFricWag);	// 10% ss price markup (Medina and Soto, 2007) 
			EPSILON_Hstar 	= 11+ZERO^-1*(1-NomFricExp);	// 10% ss price markup
				
		// Input Shares
			ALPHA 			= 1-0.66;				     	// labor share of 66% (Medina and Soto, 2007)
			ALPHA_Co		= 0.31*EndoCommo+ZERO; 	 		// to obtain a share of physical capital to quarterly output in the commodity sector of 12 (Fornero & Kirchner 2016)
			KAPPA_A         = 0.19*AgricCons+ZERO;     		// share food in final Consumption basket (Ponderador IPC base 2013)
			O_O  			= 0.01*OilProd+ZERO; 	 		// share oil in domestic technology	(Medina y Soto, 2007)

		// Ricardian-NonRicardians
			OMEGA			= 0.5*NonRic+ZERO;				// share of non-Ricardian households                               
			OMEGA_U			= OMEGA;						// union's weight of non-Ricardians welfare   
			OMEGA_UFA		= OMEGA;	    				// UFA's weight of non-Ricardians transfers 
			OMEGA_G			= OMEGA;                        // share of total transfers and lump sum taxes given to non-Ricardian households      
		
		// Search											// (Endogenous: ALPHA_BG=ub*u_ss/g_ss, u_ss-> OMEGA_V, h_ss-> ub, srhox,rho_ss-> rhox_ss, rho_ss-> rhon_ss, e_ss-> m_ss)
			VARPHI_U    	= 0.5;           				// union's bargaining power
			ALPHA_W     	= 0;             				// 0 for no indexation to A/A(-1), 1 for indexation
			e_ss			= 0.8;           				// steady state vacancy filling probability (Cooley and Quadrini, 1999; Den Haan et al., 2000; Trigari, 2009)
			rho_ss			= 0.04;         				// Jones and Naudon (2009)
			srhox       	= 2/3;           				// exogenous separations 2/3 of total (Den Haan et al., 2000, and others)		    
			ADM_COST_RAT	= 0.1/100;						// Ratio of total adm costs over GDP (pH*hC*n/pYy)
			VAREPSILON_UFA 	= 10^-4;						// small number to avoid indeterminancy of UFA net asset position
		@#if search
			u_ss			= 0.08;          				// average unemployment rate, 1987-2014 (=2001-2014)
		@#else
			u_ss			= 0;
		@#endif
		
		// Taxes
			tauC_ss 		= 0.19*DistTaxes+ZERO;    		// tax on Consumption (IVA efectivo desde 2014)
			tauK_ss 		= 0.20*DistTaxes+ZERO;    		// tax on Capital income (Impuestos a las empresas desde 2011)
			tauW_ss 		= 0.07*DistTaxes+ZERO;    		// tax on Labour income (Impuestos al ingreso laboral ponderada por percentil de ingreso desde 2013)
			tauD_ss 		= 0.20*DistTaxes+ZERO;    		// tax on Profit income (Impuestos a las empresas desde 2011)
			tauCo_ss		= 0.35;                   		// tax on foreign companies (Fornero & Kirchner 2016)
			tauUFA_ss 		= 0.03*DistTaxes*Search+(1-Search)*ZERO;
					
		// Monetary Policy
			pibar_ss 		= 1.03^.25;						// central bank inflation target since 2001

		// Fiscal Budget			
			ALPHA_D = (1-ZERO)*DebtDol+ZERO*(1-DebtDol);	// Currency denomination of gov debt (Normalization) 
			GAMMA_D 		= 1;							// Fiscal rule cyclicality(Normalization)
            VAREPSILON_T    = 0.001;                        // Small number to avoid indeterminancy of UFA net asset position

		// Government investment
			N_G				= @{iG_lags};					// time to build parameter for public capital
			RHO_VARPHI	= 1+ZERO;							// time to build parameter for public capital
			@#for j in 1:iG_lags	
                VARPHI_@{j-1}=(1-RHO_VARPHI)/(1-RHO_VARPHI^@{iG_lags})*RHO_VARPHI^(@{j-1});		
			@#endfor	

		// Commodity investment
			N_Co			= @{iCo_lags};					// time to build parameter for commodity capital
			RHO_VARPHI_Co	= 1+ZERO;						// time to build parameter for commodity capital
			@#for j in 1:iCo_lags	
                VARPHI_Co_@{j-1}=(1-RHO_VARPHI_Co)/(1-RHO_VARPHI_Co^@{iCo_lags})*RHO_VARPHI_Co^(@{j-1});		
			@#endfor				
				
		// Shares of GDP
			sca_ss  		= -(0.5)/100; 					// Current account / GDP, 2001-2016 (adjusted so that sbstar_ss=~0.54 -> NFA/GDP=~0.14, average 2003-2016)                                     
			stb_ss  		= 0.05;							// average share of trade balance / GDP, 2001-2016         
			siG_ss  		= 0.04*PubGoods+ZERO;       	// average share of government investment / GDP,  2001-2016  
			str_ss  		= 0.11*GovTr+ZERO;  			// average share of government transfers / GDP,   2001-2016 
			scG_ss  		= 0.12;  						// average share of government consumption / GDP, 2001-2016 
			sGtotal_ss		= scG_ss+siG_ss+str_ss;			// share of total government spending
			sCo_ss  		= 0.12;         				// average share of commodity sector / GDP, 2001-2016 
			siCo_ss 		= 0.04*EndoCommo+ZERO;     		// average share of commodity investment / GDP, 2001-2016
			kCo_yCo_ss		= 12;     						// average ratio of commodity capital / commodity GDP of 12 (Fornero Kirchner 2016)
			sOC     		= 0.06*OilCons+ZERO;			// share oil consumption (Ponderador IPC base 2013)
			sDEF_ss 		= ZERO;        					// fiscal deficit in Steady State 			
			CHI_CO     		= 0.33;							// Codelco production / total commodity production, 2001-2015
			
		// Other
			a_ss    		= (1+(0.033-0.0181))^.25;   	// long term growth (3.3% trend - 1.81% labor force)
			BETTA   		= 0.99997;           			// quarterly subjective discount factor (real rate around 1.5%)
			piS_ss			= 1.000^0.25;                  	// calibrated
            xi_ss   		= 1.015^.25;       				// EMBI Chile, 2001-2016
			n_pCostar 		= 40;        					// Periods for ref copper price (Fornero & Kirchner 2016)
			ALPHA_PIE       = 0.5;                          // Taylor response to expected inflation
			PHI_UCo        	= 0.5+1000*(1-VarCapUtilCommo);

			
	// Estimated parameters	----------------------------------------------------------------
	
		// Elasticities		
			ETA_Z  			= 1.76074847692813;    			// Home/Foreign in Consumption Goods       
			ETA_I  			= 1.18277650386023;    			// Home/Foreign in Private Investment Goods    
			ETA_Co			= 1.03265211536001;      		// Home/Foreign in Mining Investment Goods
            ETA_A  			= 1.07193675432198;	 			// Home/Foreign in Aggricultural Goods 
			ETA_KG 			= 0.60168697061659; 	 		// private/public capital      
			ETA_CHAT 		= 2.23675564427129;             // private/public consumption
			ETASTAR 		= 0.33916789722628;    			// Home/Foreign in Foreign Demand 
			ETA_O  			= 0.53739671488140;	 			// Core/Oil in Domestic Production
			ETA_C 			= 0.66254103025640;    			// Core/Oil/Aggric in Private Consumption
			
		// Nominal Rigidities		
			THETA_H 		= 0.82464099311683*NomFricHom+ZERO;  
			THETA_F 		= 0.73266943042806*NomFricImp+ZERO;  
            THETA_W 		= 0.82737572841196*NomFricWag+ZERO; // inertia of wages, set to search model's VARKAPPA_W
			THETA_Hstar 	= 0.72763027416763*NomFricExp+ZERO;
			VARTHETA_H 		= 0.20506149931792; 
			VARTHETA_F 		= 0.24742422463821;
			VARTHETA_Hstar 	= 0.25579821011833;
			VARTHETA_IDX    = 0.26544038507490;
			RHO_O			= 0.69764304048562*MEPCO+ZERO;	// Poil smothness parameter
			ALPHA_O			= 0.43267887492849;	    		// Poil smothness parameter2
			
		// Search											
			PHI         	= 1.50897661683776;       		// Inverse Frisch elasticity 
			MU      		= 0.90967557401104;    			// match elasticity
			VARKAPPA_W 		= 0.82737572841196*NomFricWag+ZERO;	// inertia of wages
			VARTHETA_W  	= 0.31164288106012;				// indexation to past wage inflation
			SIGMA_CTIL 		= 5.80184688062356;     		// s.d. of ctil
			UPSILON 		= 0.05922541814186;    			// short-run wealth effects on labor supply 
															// UPSILON->0 then Greenwood, Hercowitz, and Huffman preferences (no wealth effect)		
															// UPSILON->1 then King, Plosser, and Rebelo preferences (fully wealth effect)
			
		// Taylor Rule				
			RHO_R 			= 0.74429202061356;				// Taylor persistence parameter
			ALPHA_PI 		= 1.95017463183813;				// Taylor response to inflation
			ALPHA_PIz 		= 0.71474449696773;				// Taylor response to core inflation
			ALPHA_Y 		= 0.12973628404307;				// Taylor response to output
		
		// Cointegrated Processes
			GAMMA_Co		= 0.501490129682535*CointProd +(1-ZERO)*(1-CointProd);
			GAMMA_H 		= 0.565392284231617*CointProd +(1-ZERO)*(1-CointProd);
			GAMMA_Costar 	= 0.518153497014942*CointPrice+(1-ZERO)*(1-CointPrice);
            GAMMA_Ostar  	= 0.765487010885464*CointPrice+(1-ZERO)*(1-CointPrice);			
            GAMMA_Mstar 	= 0.342288724829490*CointPrice+(1-ZERO)*(1-CointPrice);                
			GAMMA_star      = 0.750511641762917*CointPrice+(1-ZERO)*(1-CointPrice); 
			
		// Other
			VARSIGMA    	= 0.61376939468984;
			bigPSI         	= 0.23668778688413;			
			PHI_I       	= 3.08983477511382;
			PHI_ICo     	= 0.49426655413420+1000*(1-EndoCommo);
			PHI_UBAR       	= 1.06989457091420+1000*(1-VarCapUtil);  
			
			

			
	// Normalizations ----------------------------------------------------------------------
	
			eR_ss       	= 1;
			h_ss        	= 0.3;
            L_BAR       	= 1;			
			pCo_ss      	= 1;						 
			pH_ss       	= 1;							
			pO_ss       	= 1;
			varomega_ss 	= 1;					 	 
			varrho_ss   	= 1;					 
			xiCG_ss     	= 1;
			xiG_ss      	= 1;
			xiIG_ss     	= 1;
			xiMstar_ss 		= 1;
			xiO_ss          = 1;
			xiREN_ss    	= 1;
			xistar_ss   	= 1;
			xiTR_ss     	= 1;
			xiXHstar_ss 	= 1;
			z_ss        	= 1;
			zA_ss       	= 1;
			zCo_ss      	= 1;
			zetao_ss    	= 1;
			zetau_ss    	= 1;
			zstar_ss    	= 1;
			varomegaCo_ss	= 1;
			
	// Exogenous processes -------------------------------------
	
		// Estimated
		
			RHO_a 			= 0.57188591477628;
			RHO_eR 			= 0.27205105177038;
			RHO_kappa 		= 0.72572568808500;
			RHO_rhox  		= 0.71228897355843;
			RHO_varomega	= 0.45139021645720;			
			RHO_varrho 		= 0.81302070094737;			
			RHO_xiCG		= 0.76944097984694;			
			RHO_xiO			= 0.71938290536376;
			RHO_z 			= 0.72937976267090;
			RHO_zCo 		= 0.78076717279519;
			RHO_zetao 		= 0.74086031305394;
			RHO_zetau 		= 0.71290958752617;
			RHO_zstar 		= 0.89173199074388;			
			RHO_xiTR		= 0.79067619109113;			
			RHO_xiIG		= 0.21637041301406;			
			RHO_varomegaCo	= 0.10640828415773;			
			RHO_zA 			= 0.90063467532990;
			RHO_piFstar     = 0.16759001786831; 
			RHO_xiCostar 	= 0.71125896541646;
			RHO_xiOstar 	= 0.66317329619366;
            RHO_Rstar		= 0.87842726603255;
			RHO_xistar      = 0.50681442489213*CointPrice+ZERO*(1-CointPrice);
            RHO_xiMstar 	= 0.84072241097150;

			SIG_a 			= 0.23766577840354;
			SIG_eR 			= 0.13552519443515;
			SIG_kappa 		= 2.34806213170054;
			SIG_varomega	= 8.14076295068849;
			SIG_varrho 		= 2.51767431166945;
			SIG_xiCG		= 1.08938369433855;
			SIG_xiO			= 2.02625280459642;
			SIG_z 			= 0.62380792271863;
			SIG_zCo 		= 2.80925361697356;
			SIG_zetao 		= 0.08113931228597;
			SIG_zetau 		= 0.59517372337547;
			SIG_zstar   	= 0.51363703225974;
			SIG_xiTR		= 3.16098410566530;
			SIG_xiIG		= 10.0729448253984;
			SIG_varomegaCo	= 11.5122561328929;
			SIG_zA			= 1.27818899616113;
			SIG_rhox  		= 0.27543377510939;
			SIG_Rstar		= 0.12013367678634;
			SIG_piFstar     = 3.30670201960005;
			SIG_xiCostar 	= 11.4602921709756;
			SIG_xiOstar 	= 13.5848355074910;
			SIG_xistar      = 0.18958008351248*CointPrice+ZERO*(1-CointPrice);
			SIG_xiMstar 	= 1.51787914614113;		
	
		// Calibrated
		
            RHO_xiG			= 0;
			RHO_xiREN 		= 0;			
			RHO_tauD		= 0;	
			RHO_tauC		= 0.999;  
			RHO_tauK		= 0.999;  
			RHO_tauW		= 0.999;  
			RHO_tauUFA		= 0.999;  
			RHO_tauCo		= 0;
			RHO_m 	  		= 0;
			RHO_pibar		= 0;
			RHO_xiXHstar 	= 0;
			RHO_XHstar 	   	= 0;	

			
			
			SIG_xiREN		= ZERO;
            SIG_xiG			= ZERO;
			SIG_tauD		= ZERO;
			SIG_tauC		= ZERO;  
			SIG_tauK		= 0.812/100;
			SIG_tauK2		= 0.125/100;
			SIG_tauK6		= 0.125/100;
			SIG_tauK10		= 0.186/100;
			SIG_tauK14		= 0.073/100;
			SIG_tauW		= ZERO;  
			SIG_tauUFA		= ZERO;  
			SIG_tauCo		= ZERO;
			SIG_m 	  		= ZERO;
			SIG_pibar		= ZERO;
    		SIG_xiXHstar 	= ZERO;