function [residual, g1, g2] = calculate_HD_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                     columns: variables in declaration order
%                                                     rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 174, 1);

%
% Model equations
%

T3 = (-1);
lhs =0;
rhs =y(75)+params(1)*y(46)+params(2)*y(31)+params(3)*(y(37)+y(37))+params(4)*(y(38)+y(38))+(-params(7))*(y(5)+y(156))-params(6)*(y(5)-y(156))-params(5)*(y(29)+y(29)-y(28)-y(28));
residual(1)= lhs-rhs;
lhs =y(75);
rhs =y(75)*params(48)+x(3);
residual(2)= lhs-rhs;
lhs =y(10);
rhs =y(78)+params(31)*x(7)+y(5)*params(17)+y(10)*params(15)+params(16)*(y(10)-params(31)*y(172));
residual(3)= lhs-rhs;
lhs =y(78);
rhs =y(78)*params(20)+params(30)*x(6);
residual(4)= lhs-rhs;
lhs =y(11);
rhs =params(33)*x(9)+y(79)+y(31)*params(25)+y(5)*params(23)+params(24)*(y(36)+y(6)-y(42)+y(36)+y(6)-y(42))+y(11)*params(21)+params(22)*(y(11)-params(33)*y(173));
residual(5)= lhs-rhs;
lhs =y(79);
rhs =y(79)*params(27)+params(32)*x(8);
residual(6)= lhs-rhs;
lhs =y(12);
rhs =params(35)*x(11)+y(80)+y(31)*params(111)+(y(36)+y(6)-y(42))*params(110)+params(28)*(y(12)-params(35)*y(174));
residual(7)= lhs-rhs;
lhs =y(80);
rhs =y(80)*params(29)+params(34)*x(10);
residual(8)= lhs-rhs;
lhs =y(9);
rhs =(y(10)*params(8)+y(11)*params(9))/params(10)+params(36)*x(13);
residual(9)= lhs-rhs;
lhs =y(8);
rhs =(y(9)*params(10)+y(12)*(params(11)-params(10)))/params(11)+params(37)*x(12);
residual(10)= lhs-rhs;
lhs =y(6);
rhs =y(8)*params(11)+params(12)*y(16)+params(13)*y(15)+params(38)*x(14);
residual(11)= lhs-rhs;
lhs =y(13);
rhs =y(9)+y(9)+y(157)+y(158);
residual(12)= lhs-rhs;
lhs =y(14);
rhs =y(8)+y(8)+y(159)+y(160);
residual(13)= lhs-rhs;
lhs =y(23)-y(24);
rhs =(y(23)-y(24))*params(42)+(1-params(42))*(y(14)*params(41)+y(5)*params(40))+y(81);
residual(14)= lhs-rhs;
lhs =y(81);
rhs =y(81)*params(49)+x(18);
residual(15)= lhs-rhs;
lhs =0;
rhs =y(1)-y(2);
residual(16)= lhs-rhs;
lhs =y(2);
rhs =y(3)+x(1);
residual(17)= lhs-rhs;
lhs =y(3);
rhs =params(91)*params(92)+y(3)*(1-params(91))+x(2);
residual(18)= lhs-rhs;
lhs =y(4);
rhs =y(1)+y(1)+y(161)+y(162);
residual(19)= lhs-rhs;
lhs =y(19);
rhs =y(18)+y(17);
residual(20)= lhs-rhs;
lhs =y(17);
rhs =params(81)*params(93)+y(17)*(1-params(81))+y(20)+params(86)*params(89)*x(15);
residual(21)= lhs-rhs;
lhs =y(20);
rhs =y(20)*(1-params(82))+params(86)*params(89)*x(16);
residual(22)= lhs-rhs;
lhs =y(18);
rhs =y(18)*params(83)-y(5)*params(84)+y(22);
residual(23)= lhs-rhs;
lhs =y(22);
rhs =y(22)*params(85)+params(86)*params(90)*x(17);
residual(24)= lhs-rhs;
lhs =y(16);
rhs =y(16)*params(39)+y(5)*params(109)+y(77);
residual(25)= lhs-rhs;
lhs =y(77);
rhs =y(77)*params(50)+params(99)*x(4);
residual(26)= lhs-rhs;
lhs =y(74);
rhs =y(74)*0.301+0.3*(y(42)+y(36)+y(6)-y(42)+y(48)-y(48))+params(108)*x(37);
residual(27)= lhs-rhs;
lhs =y(15);
rhs =(y(74)*5.268090+2.272380*y(76))/7.540470;
residual(28)= lhs-rhs;
lhs =y(76);
rhs =y(76)*params(51)+params(100)*x(5);
residual(29)= lhs-rhs;
lhs =y(7);
rhs =y(6)+y(6)+y(163)+y(164);
residual(30)= lhs-rhs;
lhs =y(29)-y(28);
rhs =y(23)-y(24)-y(6)*4;
residual(31)= lhs-rhs;
lhs =y(25);
rhs =y(25)*params(95)+(y(29)-y(28))*(1-params(95))+y(83);
residual(32)= lhs-rhs;
lhs =y(26);
rhs =(y(29)-y(28))*(1-params(95))+params(95)*y(26);
residual(33)= lhs-rhs;
lhs =y(27);
rhs =(y(29)-y(28))*(1-params(95))+params(95)*y(27);
residual(34)= lhs-rhs;
residual(35) = y(69);
residual(36) = y(70);
lhs =(y(23)-y(24))/4-y(39)/4-y(44)/4;
rhs =(1-params(96))*y(32)-params(96)*y(32)+y(84);
residual(37)= lhs-rhs;
lhs =y(31);
rhs =y(71)+y(72);
residual(38)= lhs-rhs;
lhs =y(72);
rhs =y(44)/4+y(39)/4+(-(y(23)-y(24)))/4-params(107)*y(62);
residual(39)= lhs-rhs;
lhs =y(73);
rhs =y(42)+y(32)-y(6);
residual(40)= lhs-rhs;
lhs =y(71);
rhs =y(71)+y(73);
residual(41)= lhs-rhs;
lhs =y(31);
rhs =y(31)+y(36);
residual(42)= lhs-rhs;
lhs =y(83);
rhs =y(83)*params(52)+x(19);
residual(43)= lhs-rhs;
lhs =y(28);
rhs =y(2)*params(94)+y(82);
residual(44)= lhs-rhs;
lhs =y(82);
rhs =x(20);
residual(45)= lhs-rhs;
lhs =y(24);
rhs =y(28)+params(14);
residual(46)= lhs-rhs;
lhs =y(30);
rhs =y(23)-y(24);
residual(47)= lhs-rhs;
lhs =y(33);
rhs =y(32)+y(41)-y(6);
residual(48)= lhs-rhs;
lhs =y(35);
rhs =y(32)+y(34);
residual(49)= lhs-rhs;
lhs =y(40);
rhs =y(39)-4*y(41);
residual(50)= lhs-rhs;
lhs =y(84);
rhs =y(84)*params(55)+x(21);
residual(51)= lhs-rhs;
lhs =y(34);
rhs =y(34)*params(47)+y(85);
residual(52)= lhs-rhs;
lhs =y(85);
rhs =y(85)*params(56)+x(22);
residual(53)= lhs-rhs;
lhs =y(38);
rhs =y(38)*params(43)+y(86);
residual(54)= lhs-rhs;
lhs =y(86);
rhs =y(86)*params(53)+params(101)*x(23);
residual(55)= lhs-rhs;
lhs =y(37);
rhs =y(37)*params(44)+y(87);
residual(56)= lhs-rhs;
lhs =y(87);
rhs =y(87)*params(54)+params(102)*x(24);
residual(57)= lhs-rhs;
lhs =y(39);
rhs =y(39)*params(57)+y(88);
residual(58)= lhs-rhs;
lhs =y(88);
rhs =y(88)*params(58)+params(103)*x(25);
residual(59)= lhs-rhs;
lhs =y(44);
rhs =y(44)*params(45)+y(89);
residual(60)= lhs-rhs;
lhs =y(41);
rhs =y(41)*params(46)+y(90);
residual(61)= lhs-rhs;
lhs =y(90);
rhs =y(90)*params(59)+params(105)*x(26);
residual(62)= lhs-rhs;
lhs =y(43);
rhs =y(43)*params(60)+y(91);
residual(63)= lhs-rhs;
lhs =y(91);
rhs =y(91)*params(61)+params(106)*x(27);
residual(64)= lhs-rhs;
lhs =y(89);
rhs =y(89)*params(62)+params(104)*x(28);
residual(65)= lhs-rhs;
lhs =y(46);
rhs =y(49)-y(52);
residual(66)= lhs-rhs;
lhs =y(62);
rhs =y(63)-y(64);
residual(67)= lhs-rhs;
lhs =y(63);
rhs =params(63)*y(65)+(1-params(63))*y(66);
residual(68)= lhs-rhs;
lhs =y(64);
rhs =params(64)*y(67)+(1-params(64))*y(68);
residual(69)= lhs-rhs;
lhs =y(65);
rhs =y(47);
residual(70)= lhs-rhs;
lhs =y(66);
rhs =y(92);
residual(71)= lhs-rhs;
lhs =y(67);
rhs =y(48);
residual(72)= lhs-rhs;
lhs =y(68);
rhs =y(93);
residual(73)= lhs-rhs;
lhs =y(49);
rhs =params(63)*y(50)+(1-params(63))*y(51)+params(73)*x(31);
residual(74)= lhs-rhs;
lhs =y(50);
rhs =y(47)+params(74)*x(32);
residual(75)= lhs-rhs;
lhs =y(51);
rhs =y(92);
residual(76)= lhs-rhs;
lhs =y(92);
rhs =y(92)*params(69)+params(76)*x(33);
residual(77)= lhs-rhs;
lhs =y(52);
rhs =params(64)*y(53)+(1-params(64))*y(54)+params(77)*x(34);
residual(78)= lhs-rhs;
lhs =y(53);
rhs =y(48)+params(78)*x(35);
residual(79)= lhs-rhs;
lhs =y(54);
rhs =y(93);
residual(80)= lhs-rhs;
lhs =y(93);
rhs =y(93)*params(70)+params(80)*x(36);
residual(81)= lhs-rhs;
lhs =y(47);
rhs =y(47)*params(65)+params(71)*x(29);
residual(82)= lhs-rhs;
lhs =y(48);
rhs =y(94)+y(48)*params(66)+params(67)*y(165);
residual(83)= lhs-rhs;
lhs =y(94);
rhs =y(94)*params(68)+params(72)*x(30);
residual(84)= lhs-rhs;
residual(85) = y(55);
residual(86) = y(56);
residual(87) = y(57);
residual(88) = y(58);
residual(89) = y(59);
residual(90) = y(60);
residual(91) = y(61);
lhs =y(42);
rhs =y(41)*params(98)+y(43)*(1-params(98));
residual(92)= lhs-rhs;
lhs =y(95);
rhs =(y(168)+y(1)*3+y(1)*4+y(1)*3+y(111)+2*y(110)+2*y(161))/4;
residual(93)= lhs-rhs;
lhs =y(96);
rhs =(y(161)+2*y(110)+y(115)+2*y(114)+3*y(113)+4*y(112)+3*y(111))/4;
residual(94)= lhs-rhs;
lhs =y(97);
rhs =(y(110)+2*y(114)+y(119)+2*y(118)+3*y(117)+4*y(116)+3*y(115))/4;
residual(95)= lhs-rhs;
lhs =y(98);
rhs =(y(1)+2*y(1)+y(1)*3+3*y(111)+y(113)+2*y(112)+4*y(110))/4;
residual(96)= lhs-rhs;
lhs =y(99);
rhs =(y(111)+2*y(112)+3*y(113)+3*y(115)+y(117)+2*y(116)+4*y(114))/4;
residual(97)= lhs-rhs;
lhs =y(100);
rhs =(y(115)+2*y(116)+3*y(117)+y(121)+2*y(120)+3*y(119)+4*y(118))/4;
residual(98)= lhs-rhs;
lhs =y(101);
rhs =(y(119)+2*y(120)+y(125)+2*y(124)+3*y(123)+4*y(122)+3*y(121))/4;
residual(99)= lhs-rhs;
lhs =y(102);
rhs =(y(123)+2*y(124)+y(129)+2*y(128)+3*y(127)+4*y(126)+3*y(125))/4;
residual(100)= lhs-rhs;
lhs =y(103);
rhs =((y(127)+2*y(128)+y(133)+2*y(132)+3*y(131)+4*y(130)+3*y(129))/4+(y(131)+2*y(132)+y(137)+2*y(136)+3*y(135)+4*y(134)+3*y(133))/4+(y(135)+2*y(136)+y(141)+2*y(140)+3*y(139)+4*y(138)+3*y(137))/4+(y(139)+2*y(140)+y(145)+2*y(144)+3*y(143)+4*y(142)+3*y(141))/4+(y(143)+2*y(144)+y(149)+2*y(148)+3*y(147)+4*y(146)+3*y(145))/4)/5;
residual(101)= lhs-rhs;
lhs =y(104);
rhs =y(6)+y(6)+y(150)+y(151);
residual(102)= lhs-rhs;
lhs =y(105);
rhs =y(152)+y(153)+y(154)+y(155);
residual(103)= lhs-rhs;
lhs =y(17);
rhs =y(21);
residual(104)= lhs-rhs;
lhs =y(106);
rhs =y(8);
residual(105)= lhs-rhs;
lhs =y(107);
rhs =y(16);
residual(106)= lhs-rhs;
lhs =y(108);
rhs =y(15);
residual(107)= lhs-rhs;
lhs =y(109);
rhs =y(6);
residual(108)= lhs-rhs;
lhs =y(45);
rhs =y(41)+y(41)+y(169)+y(171);
residual(109)= lhs-rhs;
lhs =y(110);
rhs =y(1);
residual(110)= lhs-rhs;
lhs =y(111);
rhs =y(110);
residual(111)= lhs-rhs;
lhs =y(112);
rhs =y(111);
residual(112)= lhs-rhs;
lhs =y(113);
rhs =y(112);
residual(113)= lhs-rhs;
lhs =y(114);
rhs =y(113);
residual(114)= lhs-rhs;
lhs =y(115);
rhs =y(114);
residual(115)= lhs-rhs;
lhs =y(116);
rhs =y(115);
residual(116)= lhs-rhs;
lhs =y(117);
rhs =y(116);
residual(117)= lhs-rhs;
lhs =y(118);
rhs =y(117);
residual(118)= lhs-rhs;
lhs =y(119);
rhs =y(118);
residual(119)= lhs-rhs;
lhs =y(120);
rhs =y(119);
residual(120)= lhs-rhs;
lhs =y(121);
rhs =y(120);
residual(121)= lhs-rhs;
lhs =y(122);
rhs =y(121);
residual(122)= lhs-rhs;
lhs =y(123);
rhs =y(122);
residual(123)= lhs-rhs;
lhs =y(124);
rhs =y(123);
residual(124)= lhs-rhs;
lhs =y(125);
rhs =y(124);
residual(125)= lhs-rhs;
lhs =y(126);
rhs =y(125);
residual(126)= lhs-rhs;
lhs =y(127);
rhs =y(126);
residual(127)= lhs-rhs;
lhs =y(128);
rhs =y(127);
residual(128)= lhs-rhs;
lhs =y(129);
rhs =y(128);
residual(129)= lhs-rhs;
lhs =y(130);
rhs =y(129);
residual(130)= lhs-rhs;
lhs =y(131);
rhs =y(130);
residual(131)= lhs-rhs;
lhs =y(132);
rhs =y(131);
residual(132)= lhs-rhs;
lhs =y(133);
rhs =y(132);
residual(133)= lhs-rhs;
lhs =y(134);
rhs =y(133);
residual(134)= lhs-rhs;
lhs =y(135);
rhs =y(134);
residual(135)= lhs-rhs;
lhs =y(136);
rhs =y(135);
residual(136)= lhs-rhs;
lhs =y(137);
rhs =y(136);
residual(137)= lhs-rhs;
lhs =y(138);
rhs =y(137);
residual(138)= lhs-rhs;
lhs =y(139);
rhs =y(138);
residual(139)= lhs-rhs;
lhs =y(140);
rhs =y(139);
residual(140)= lhs-rhs;
lhs =y(141);
rhs =y(140);
residual(141)= lhs-rhs;
lhs =y(142);
rhs =y(141);
residual(142)= lhs-rhs;
lhs =y(143);
rhs =y(142);
residual(143)= lhs-rhs;
lhs =y(144);
rhs =y(143);
residual(144)= lhs-rhs;
lhs =y(145);
rhs =y(144);
residual(145)= lhs-rhs;
lhs =y(146);
rhs =y(145);
residual(146)= lhs-rhs;
lhs =y(147);
rhs =y(146);
residual(147)= lhs-rhs;
lhs =y(148);
rhs =y(147);
residual(148)= lhs-rhs;
lhs =y(149);
rhs =y(148);
residual(149)= lhs-rhs;
lhs =y(150);
rhs =y(6);
residual(150)= lhs-rhs;
lhs =y(151);
rhs =y(150);
residual(151)= lhs-rhs;
lhs =y(152);
rhs =y(151);
residual(152)= lhs-rhs;
lhs =y(153);
rhs =y(152);
residual(153)= lhs-rhs;
lhs =y(154);
rhs =y(153);
residual(154)= lhs-rhs;
lhs =y(155);
rhs =y(154);
residual(155)= lhs-rhs;
lhs =y(156);
rhs =y(5);
residual(156)= lhs-rhs;
lhs =y(157);
rhs =y(9);
residual(157)= lhs-rhs;
lhs =y(158);
rhs =y(157);
residual(158)= lhs-rhs;
lhs =y(159);
rhs =y(8);
residual(159)= lhs-rhs;
lhs =y(160);
rhs =y(159);
residual(160)= lhs-rhs;
lhs =y(161);
rhs =y(1);
residual(161)= lhs-rhs;
lhs =y(162);
rhs =y(161);
residual(162)= lhs-rhs;
lhs =y(163);
rhs =y(6);
residual(163)= lhs-rhs;
lhs =y(164);
rhs =y(163);
residual(164)= lhs-rhs;
lhs =y(165);
rhs =y(48);
residual(165)= lhs-rhs;
lhs =y(166);
rhs =y(162);
residual(166)= lhs-rhs;
lhs =y(167);
rhs =y(166);
residual(167)= lhs-rhs;
lhs =y(168);
rhs =y(167);
residual(168)= lhs-rhs;
lhs =y(169);
rhs =y(41);
residual(169)= lhs-rhs;
lhs =y(170);
rhs =y(169);
residual(170)= lhs-rhs;
lhs =y(171);
rhs =y(170);
residual(171)= lhs-rhs;
lhs =y(172);
rhs =x(7);
residual(172)= lhs-rhs;
lhs =y(173);
rhs =x(9);
residual(173)= lhs-rhs;
lhs =y(174);
rhs =x(11);
residual(174)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(174, 174);

  %
  % Jacobian matrix
  %

  g1(1,5)=(-((-params(7))-params(6)));
  g1(1,28)=params(5)*(-2);
  g1(1,29)=2*params(5);
  g1(1,31)=(-params(2));
  g1(1,37)=(-(2*params(3)));
  g1(1,38)=(-(2*params(4)));
  g1(1,46)=(-params(1));
  g1(1,75)=T3;
  g1(1,156)=(-((-params(7))-(-params(6))));
  g1(2,75)=1-params(48);
  g1(3,5)=(-params(17));
  g1(3,10)=1-(params(15)+params(16));
  g1(3,78)=T3;
  g1(3,172)=(-(params(16)*(-params(31))));
  g1(4,78)=1-params(20);
  g1(5,5)=(-params(23));
  g1(5,6)=(-(2*params(24)));
  g1(5,11)=1-(params(21)+params(22));
  g1(5,31)=(-params(25));
  g1(5,36)=(-(2*params(24)));
  g1(5,42)=(-(params(24)*(-2)));
  g1(5,79)=T3;
  g1(5,173)=(-(params(22)*(-params(33))));
  g1(6,79)=1-params(27);
  g1(7,6)=(-params(110));
  g1(7,12)=1-params(28);
  g1(7,31)=(-params(111));
  g1(7,36)=(-params(110));
  g1(7,42)=params(110);
  g1(7,80)=T3;
  g1(7,174)=(-(params(28)*(-params(35))));
  g1(8,80)=1-params(29);
  g1(9,9)=1;
  g1(9,10)=(-(params(8)/params(10)));
  g1(9,11)=(-(params(9)/params(10)));
  g1(10,8)=1;
  g1(10,9)=(-(params(10)/params(11)));
  g1(10,12)=(-((params(11)-params(10))/params(11)));
  g1(11,6)=1;
  g1(11,8)=(-params(11));
  g1(11,15)=(-params(13));
  g1(11,16)=(-params(12));
  g1(12,9)=(-2);
  g1(12,13)=1;
  g1(12,157)=T3;
  g1(12,158)=T3;
  g1(13,8)=(-2);
  g1(13,14)=1;
  g1(13,159)=T3;
  g1(13,160)=T3;
  g1(14,5)=(-((1-params(42))*params(40)));
  g1(14,14)=(-((1-params(42))*params(41)));
  g1(14,23)=1-params(42);
  g1(14,24)=T3-(-params(42));
  g1(14,81)=T3;
  g1(15,81)=1-params(49);
  g1(16,1)=T3;
  g1(16,2)=1;
  g1(17,2)=1;
  g1(17,3)=T3;
  g1(18,3)=1-(1-params(91));
  g1(19,1)=(-2);
  g1(19,4)=1;
  g1(19,161)=T3;
  g1(19,162)=T3;
  g1(20,17)=T3;
  g1(20,18)=T3;
  g1(20,19)=1;
  g1(21,17)=1-(1-params(81));
  g1(21,20)=T3;
  g1(22,20)=1-(1-params(82));
  g1(23,5)=params(84);
  g1(23,18)=1-params(83);
  g1(23,22)=T3;
  g1(24,22)=1-params(85);
  g1(25,5)=(-params(109));
  g1(25,16)=1-params(39);
  g1(25,77)=T3;
  g1(26,77)=1-params(50);
  g1(27,6)=(-0.3);
  g1(27,36)=(-0.3);
  g1(27,74)=0.6990000000000001;
  g1(28,15)=1;
  g1(28,74)=(-0.6986421270822641);
  g1(28,76)=(-0.3013578729177359);
  g1(29,76)=1-params(51);
  g1(30,6)=(-2);
  g1(30,7)=1;
  g1(30,163)=T3;
  g1(30,164)=T3;
  g1(31,6)=4;
  g1(31,23)=T3;
  g1(31,24)=1;
  g1(31,28)=T3;
  g1(31,29)=1;
  g1(32,25)=1-params(95);
  g1(32,28)=1-params(95);
  g1(32,29)=(-(1-params(95)));
  g1(32,83)=T3;
  g1(33,26)=1-params(95);
  g1(33,28)=1-params(95);
  g1(33,29)=(-(1-params(95)));
  g1(34,27)=1-params(95);
  g1(34,28)=1-params(95);
  g1(34,29)=(-(1-params(95)));
  g1(35,69)=1;
  g1(36,70)=1;
  g1(37,23)=0.25;
  g1(37,24)=(-0.25);
  g1(37,32)=(-(1-params(96)-params(96)));
  g1(37,39)=(-0.25);
  g1(37,44)=(-0.25);
  g1(37,84)=T3;
  g1(38,31)=1;
  g1(38,71)=T3;
  g1(38,72)=T3;
  g1(39,23)=0.25;
  g1(39,24)=(-0.25);
  g1(39,39)=(-0.25);
  g1(39,44)=(-0.25);
  g1(39,62)=params(107);
  g1(39,72)=1;
  g1(40,6)=1;
  g1(40,32)=T3;
  g1(40,42)=T3;
  g1(40,73)=1;
  g1(41,73)=T3;
  g1(42,36)=T3;
  g1(43,83)=1-params(52);
  g1(44,2)=(-params(94));
  g1(44,28)=1;
  g1(44,82)=T3;
  g1(45,82)=1;
  g1(46,24)=1;
  g1(46,28)=T3;
  g1(47,23)=T3;
  g1(47,24)=1;
  g1(47,30)=1;
  g1(48,6)=1;
  g1(48,32)=T3;
  g1(48,33)=1;
  g1(48,41)=T3;
  g1(49,32)=T3;
  g1(49,34)=T3;
  g1(49,35)=1;
  g1(50,39)=T3;
  g1(50,40)=1;
  g1(50,41)=4;
  g1(51,84)=1-params(55);
  g1(52,34)=1-params(47);
  g1(52,85)=T3;
  g1(53,85)=1-params(56);
  g1(54,38)=1-params(43);
  g1(54,86)=T3;
  g1(55,86)=1-params(53);
  g1(56,37)=1-params(44);
  g1(56,87)=T3;
  g1(57,87)=1-params(54);
  g1(58,39)=1-params(57);
  g1(58,88)=T3;
  g1(59,88)=1-params(58);
  g1(60,44)=1-params(45);
  g1(60,89)=T3;
  g1(61,41)=1-params(46);
  g1(61,90)=T3;
  g1(62,90)=1-params(59);
  g1(63,43)=1-params(60);
  g1(63,91)=T3;
  g1(64,91)=1-params(61);
  g1(65,89)=1-params(62);
  g1(66,46)=1;
  g1(66,49)=T3;
  g1(66,52)=1;
  g1(67,62)=1;
  g1(67,63)=T3;
  g1(67,64)=1;
  g1(68,63)=1;
  g1(68,65)=(-params(63));
  g1(68,66)=(-(1-params(63)));
  g1(69,64)=1;
  g1(69,67)=(-params(64));
  g1(69,68)=(-(1-params(64)));
  g1(70,47)=T3;
  g1(70,65)=1;
  g1(71,66)=1;
  g1(71,92)=T3;
  g1(72,48)=T3;
  g1(72,67)=1;
  g1(73,68)=1;
  g1(73,93)=T3;
  g1(74,49)=1;
  g1(74,50)=(-params(63));
  g1(74,51)=(-(1-params(63)));
  g1(75,47)=T3;
  g1(75,50)=1;
  g1(76,51)=1;
  g1(76,92)=T3;
  g1(77,92)=1-params(69);
  g1(78,52)=1;
  g1(78,53)=(-params(64));
  g1(78,54)=(-(1-params(64)));
  g1(79,48)=T3;
  g1(79,53)=1;
  g1(80,54)=1;
  g1(80,93)=T3;
  g1(81,93)=1-params(70);
  g1(82,47)=1-params(65);
  g1(83,48)=1-params(66);
  g1(83,94)=T3;
  g1(83,165)=(-params(67));
  g1(84,94)=1-params(68);
  g1(85,55)=1;
  g1(86,56)=1;
  g1(87,57)=1;
  g1(88,58)=1;
  g1(89,59)=1;
  g1(90,60)=1;
  g1(91,61)=1;
  g1(92,41)=(-params(98));
  g1(92,42)=1;
  g1(92,43)=(-(1-params(98)));
  g1(93,1)=(-2.5);
  g1(93,95)=1;
  g1(93,110)=(-0.5);
  g1(93,111)=(-0.25);
  g1(93,161)=(-0.5);
  g1(93,168)=(-0.25);
  g1(94,96)=1;
  g1(94,110)=(-0.5);
  g1(94,111)=(-0.75);
  g1(94,112)=T3;
  g1(94,113)=(-0.75);
  g1(94,114)=(-0.5);
  g1(94,115)=(-0.25);
  g1(94,161)=(-0.25);
  g1(95,97)=1;
  g1(95,110)=(-0.25);
  g1(95,114)=(-0.5);
  g1(95,115)=(-0.75);
  g1(95,116)=T3;
  g1(95,117)=(-0.75);
  g1(95,118)=(-0.5);
  g1(95,119)=(-0.25);
  g1(96,1)=(-1.5);
  g1(96,98)=1;
  g1(96,110)=T3;
  g1(96,111)=(-0.75);
  g1(96,112)=(-0.5);
  g1(96,113)=(-0.25);
  g1(97,99)=1;
  g1(97,111)=(-0.25);
  g1(97,112)=(-0.5);
  g1(97,113)=(-0.75);
  g1(97,114)=T3;
  g1(97,115)=(-0.75);
  g1(97,116)=(-0.5);
  g1(97,117)=(-0.25);
  g1(98,100)=1;
  g1(98,115)=(-0.25);
  g1(98,116)=(-0.5);
  g1(98,117)=(-0.75);
  g1(98,118)=T3;
  g1(98,119)=(-0.75);
  g1(98,120)=(-0.5);
  g1(98,121)=(-0.25);
  g1(99,101)=1;
  g1(99,119)=(-0.25);
  g1(99,120)=(-0.5);
  g1(99,121)=(-0.75);
  g1(99,122)=T3;
  g1(99,123)=(-0.75);
  g1(99,124)=(-0.5);
  g1(99,125)=(-0.25);
  g1(100,102)=1;
  g1(100,123)=(-0.25);
  g1(100,124)=(-0.5);
  g1(100,125)=(-0.75);
  g1(100,126)=T3;
  g1(100,127)=(-0.75);
  g1(100,128)=(-0.5);
  g1(100,129)=(-0.25);
  g1(101,103)=1;
  g1(101,127)=(-0.05);
  g1(101,128)=(-0.1);
  g1(101,129)=(-0.15);
  g1(101,130)=(-0.2);
  g1(101,131)=(-0.2);
  g1(101,132)=(-0.2);
  g1(101,133)=(-0.2);
  g1(101,134)=(-0.2);
  g1(101,135)=(-0.2);
  g1(101,136)=(-0.2);
  g1(101,137)=(-0.2);
  g1(101,138)=(-0.2);
  g1(101,139)=(-0.2);
  g1(101,140)=(-0.2);
  g1(101,141)=(-0.2);
  g1(101,142)=(-0.2);
  g1(101,143)=(-0.2);
  g1(101,144)=(-0.2);
  g1(101,145)=(-0.2);
  g1(101,146)=(-0.2);
  g1(101,147)=(-0.15);
  g1(101,148)=(-0.1);
  g1(101,149)=(-0.05);
  g1(102,6)=(-2);
  g1(102,104)=1;
  g1(102,150)=T3;
  g1(102,151)=T3;
  g1(103,105)=1;
  g1(103,152)=T3;
  g1(103,153)=T3;
  g1(103,154)=T3;
  g1(103,155)=T3;
  g1(104,17)=1;
  g1(104,21)=T3;
  g1(105,8)=T3;
  g1(105,106)=1;
  g1(106,16)=T3;
  g1(106,107)=1;
  g1(107,15)=T3;
  g1(107,108)=1;
  g1(108,6)=T3;
  g1(108,109)=1;
  g1(109,41)=(-2);
  g1(109,45)=1;
  g1(109,169)=T3;
  g1(109,171)=T3;
  g1(110,1)=T3;
  g1(110,110)=1;
  g1(111,110)=T3;
  g1(111,111)=1;
  g1(112,111)=T3;
  g1(112,112)=1;
  g1(113,112)=T3;
  g1(113,113)=1;
  g1(114,113)=T3;
  g1(114,114)=1;
  g1(115,114)=T3;
  g1(115,115)=1;
  g1(116,115)=T3;
  g1(116,116)=1;
  g1(117,116)=T3;
  g1(117,117)=1;
  g1(118,117)=T3;
  g1(118,118)=1;
  g1(119,118)=T3;
  g1(119,119)=1;
  g1(120,119)=T3;
  g1(120,120)=1;
  g1(121,120)=T3;
  g1(121,121)=1;
  g1(122,121)=T3;
  g1(122,122)=1;
  g1(123,122)=T3;
  g1(123,123)=1;
  g1(124,123)=T3;
  g1(124,124)=1;
  g1(125,124)=T3;
  g1(125,125)=1;
  g1(126,125)=T3;
  g1(126,126)=1;
  g1(127,126)=T3;
  g1(127,127)=1;
  g1(128,127)=T3;
  g1(128,128)=1;
  g1(129,128)=T3;
  g1(129,129)=1;
  g1(130,129)=T3;
  g1(130,130)=1;
  g1(131,130)=T3;
  g1(131,131)=1;
  g1(132,131)=T3;
  g1(132,132)=1;
  g1(133,132)=T3;
  g1(133,133)=1;
  g1(134,133)=T3;
  g1(134,134)=1;
  g1(135,134)=T3;
  g1(135,135)=1;
  g1(136,135)=T3;
  g1(136,136)=1;
  g1(137,136)=T3;
  g1(137,137)=1;
  g1(138,137)=T3;
  g1(138,138)=1;
  g1(139,138)=T3;
  g1(139,139)=1;
  g1(140,139)=T3;
  g1(140,140)=1;
  g1(141,140)=T3;
  g1(141,141)=1;
  g1(142,141)=T3;
  g1(142,142)=1;
  g1(143,142)=T3;
  g1(143,143)=1;
  g1(144,143)=T3;
  g1(144,144)=1;
  g1(145,144)=T3;
  g1(145,145)=1;
  g1(146,145)=T3;
  g1(146,146)=1;
  g1(147,146)=T3;
  g1(147,147)=1;
  g1(148,147)=T3;
  g1(148,148)=1;
  g1(149,148)=T3;
  g1(149,149)=1;
  g1(150,6)=T3;
  g1(150,150)=1;
  g1(151,150)=T3;
  g1(151,151)=1;
  g1(152,151)=T3;
  g1(152,152)=1;
  g1(153,152)=T3;
  g1(153,153)=1;
  g1(154,153)=T3;
  g1(154,154)=1;
  g1(155,154)=T3;
  g1(155,155)=1;
  g1(156,5)=T3;
  g1(156,156)=1;
  g1(157,9)=T3;
  g1(157,157)=1;
  g1(158,157)=T3;
  g1(158,158)=1;
  g1(159,8)=T3;
  g1(159,159)=1;
  g1(160,159)=T3;
  g1(160,160)=1;
  g1(161,1)=T3;
  g1(161,161)=1;
  g1(162,161)=T3;
  g1(162,162)=1;
  g1(163,6)=T3;
  g1(163,163)=1;
  g1(164,163)=T3;
  g1(164,164)=1;
  g1(165,48)=T3;
  g1(165,165)=1;
  g1(166,162)=T3;
  g1(166,166)=1;
  g1(167,166)=T3;
  g1(167,167)=1;
  g1(168,167)=T3;
  g1(168,168)=1;
  g1(169,41)=T3;
  g1(169,169)=1;
  g1(170,169)=T3;
  g1(170,170)=1;
  g1(171,170)=T3;
  g1(171,171)=1;
  g1(172,172)=1;
  g1(173,173)=1;
  g1(174,174)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],174,30276);
end
end
